/*
 * Decompiled with CFR 0.152.
 */
package genetic.statics;

import genetic.fitness.Fitness;
import java.util.Vector;
import util.statics.LogManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Kendall {
    public static double calculateKendallsTau(Vector<Object> phenotypes, Fitness initialFitness, Fitness lastFitness) {
        int n = phenotypes.size();
        double[] initialScores = new double[n];
        double[] finalScores = new double[n];
        for (int i = 0; i < phenotypes.size(); ++i) {
            initialScores[i] = initialFitness.evaluate(phenotypes.get(i));
            finalScores[i] = lastFitness.evaluate(phenotypes.get(i));
        }
        for (int pass = 1; pass < n; ++pass) {
            for (int i = 0; i < n - pass; ++i) {
                if (!(initialScores[i] > initialScores[i + 1])) continue;
                double tempInitial = initialScores[i];
                initialScores[i] = initialScores[i + 1];
                initialScores[i + 1] = tempInitial;
                double tempFinal = finalScores[i];
                finalScores[i] = finalScores[i + 1];
                finalScores[i + 1] = tempFinal;
            }
        }
        int discordantPairs = 0;
        int concordantPairs = 0;
        int totalRuns = 0;
        for (int pass = 1; pass < n; ++pass) {
            for (int i = 0; i < n - pass; ++i) {
                ++totalRuns;
                if (finalScores[i] > finalScores[i + 1]) {
                    double temp = finalScores[i];
                    finalScores[i] = finalScores[i + 1];
                    finalScores[i + 1] = temp;
                    ++discordantPairs;
                    continue;
                }
                ++concordantPairs;
            }
        }
        return (double)(concordantPairs - discordantPairs) / (0.5 * (double)n * (double)(n - 1));
    }

    public static double calculateKendallsTau(Vector<Object> initialPhenotypes, Fitness initialFitness, Vector<Object> lastPhenotypes, Fitness lastFitness) {
        if (initialPhenotypes.size() != lastPhenotypes.size()) {
            LogManager.writeError("Error", null, "phenotype size mismatch");
        }
        int n = initialPhenotypes.size();
        double[] initialScores = new double[n];
        double[] finalScores = new double[n];
        for (int i = 0; i < initialPhenotypes.size(); ++i) {
            initialScores[i] = initialFitness.evaluate(initialPhenotypes.get(i));
            finalScores[i] = lastFitness.evaluate(lastPhenotypes.get(i));
        }
        for (int pass = 1; pass < n; ++pass) {
            for (int i = 0; i < n - pass; ++i) {
                if (!(initialScores[i] > initialScores[i + 1])) continue;
                double tempInitial = initialScores[i];
                initialScores[i] = initialScores[i + 1];
                initialScores[i + 1] = tempInitial;
                double tempFinal = finalScores[i];
                finalScores[i] = finalScores[i + 1];
                finalScores[i + 1] = tempFinal;
            }
        }
        int discordantPairs = 0;
        int concordantPairs = 0;
        int totalRuns = 0;
        for (int pass = 1; pass < n; ++pass) {
            for (int i = 0; i < n - pass; ++i) {
                ++totalRuns;
                if (finalScores[i] > finalScores[i + 1]) {
                    double temp = finalScores[i];
                    finalScores[i] = finalScores[i + 1];
                    finalScores[i + 1] = temp;
                    ++discordantPairs;
                    continue;
                }
                ++concordantPairs;
            }
        }
        return (double)(concordantPairs - discordantPairs) / (0.5 * (double)n * (double)(n - 1));
    }
}

