/*
 * Decompiled with CFR 0.152.
 */
package util.collections;

import java.util.Hashtable;
import processing.core.PApplet;
import processing.core.PFont;

public class FontCollection {
    Hashtable<String, PFont> fonts;
    PApplet p;

    public FontCollection(PApplet p) {
        this.p = p;
        this.fonts = new Hashtable();
        this.fonts.put("Small", p.createFont("Arial", 9.0f, true));
        this.fonts.put("Base", p.createFont("Arial", 11.0f, true));
        this.fonts.put("Large", p.createFont("Arial", 14.0f, true));
        this.fonts.put("Huge", p.createFont("Arial", 24.0f, true));
    }

    public PFont getFont(String fontname) {
        PFont result = this.fonts.get(fontname);
        if (result == null) {
            System.out.println("FontCollection: Font " + fontname + " was not found!");
        }
        return result;
    }

    public float getFontHeight(String fontname) {
        PFont temp = this.getFont(fontname);
        if (temp == null) {
            System.out.println("FontCollection: Font " + fontname + " was not found!");
            return -1.0f;
        }
        this.p.textFont(temp);
        return this.p.textDescent() + this.p.textAscent();
    }

    public boolean isFont(String fontname) {
        return this.fonts.containsKey(fontname);
    }
}

