/*
 * Decompiled with CFR 0.152.
 */
package util.collections;

import java.io.File;
import java.io.FileWriter;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ParameterCollection {
    HashMap<String, String> parameters = new HashMap();

    public ParameterCollection() {
    }

    public ParameterCollection(ParameterCollection other) {
        for (Map.Entry<String, String> entry : other.parameters.entrySet()) {
            this.parameters.put(entry.getKey(), entry.getValue());
        }
    }

    public boolean contains(String name) {
        String temp = this.parameters.get(name);
        return temp != null;
    }

    public void setParameter(String name, String value) {
        this.parameters.put(name, value);
    }

    public void setParameter(String name, double value) {
        this.setParameter(name, Double.toString(value));
    }

    public void setParameter(String name, float value) {
        this.setParameter(name, Float.toString(value));
    }

    public void setParameter(String name, int value) {
        this.setParameter(name, Integer.toString(value));
    }

    public void setParameter(String name, boolean value) {
        if (value) {
            this.setParameter(name, Integer.toString(1));
        } else {
            this.setParameter(name, Integer.toString(0));
        }
    }

    public int getInteger(String name) {
        String temp = this.parameters.get(name);
        if (temp == null) {
            System.out.println("ParameterCollection: parameter " + name + " does not exist.");
            return 0;
        }
        return Integer.parseInt(temp);
    }

    public boolean getBoolean(String name) {
        int temp = this.getInteger(name);
        if (temp == 0) {
            return false;
        }
        if (temp == 1) {
            return true;
        }
        System.out.println("ParameterCollection: parameter " + name + " is not boolean.");
        return true;
    }

    public float getFloat(String name) {
        String temp = this.parameters.get(name);
        if (temp == null) {
            System.out.println("ParameterCollection: parameter " + name + " does not exist.");
            return 0.0f;
        }
        return Float.parseFloat(temp);
    }

    public double getDouble(String name) {
        String temp = this.parameters.get(name);
        if (temp == null) {
            System.out.println("ParameterCollection: parameter " + name + " does not exist.");
            return 0.0;
        }
        return Double.parseDouble(temp);
    }

    public String getString(String name) {
        String temp = this.parameters.get(name);
        if (temp == null) {
            System.out.println("ParameterCollection: parameter " + name + " does not exist.");
            return "";
        }
        return temp;
    }

    public String print() {
        String result = "--- BEGIN parameters --- \n";
        for (Map.Entry<String, String> e : this.parameters.entrySet()) {
            String name = e.getKey();
            String value = e.getValue();
            result = result + "\t" + name + ": " + value + "\n";
        }
        result = result + "--- END parameters --- \n";
        return result;
    }

    public ParameterCollection(String filename) {
        File file = new File(filename);
        if (!file.exists()) {
            System.out.println("ParameterCollection: File " + filename + " does not exist.");
            return;
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = null;
        Document doc = null;
        try {
            db = dbf.newDocumentBuilder();
            doc = db.parse(file);
        }
        catch (Exception e) {
            System.out.println("ParameterCollection: Error parsing file " + filename + ".");
            return;
        }
        doc.getDocumentElement().normalize();
        if (!doc.getDocumentElement().getNodeName().endsWith("parameters")) {
            System.out.println("ParameterCollection: Invalid XML root");
            return;
        }
        NodeList nodeLst = doc.getElementsByTagName("parameter");
        for (int i = 0; i < nodeLst.getLength(); ++i) {
            if (nodeLst.item(i).getNodeType() != 1) {
                System.out.println("ParameterCollection: Invalid XML node");
                break;
            }
            Element el = (Element)nodeLst.item(i);
            this.parameters.put(el.getAttribute("name"), el.getAttribute("value"));
        }
    }

    public String toXML() {
        String result = "<parameters>\n";
        for (Map.Entry<String, String> e : this.parameters.entrySet()) {
            String name = e.getKey();
            String value = e.getValue();
            result = result + "\t<parameter name=\"" + name + "\" value=\"" + value + "\"/>\n";
        }
        result = result + "</parameters>\n";
        return result;
    }

    public void saveToXML(String filename) {
        File file = new File(filename);
        FileWriter fw = null;
        try {
            fw = new FileWriter(file);
            fw.write(this.toXML());
            fw.close();
        }
        catch (Exception e) {
            System.out.println("ParameterCollection: Error writing to file " + filename + ".");
            return;
        }
    }
}

