/*
 * Decompiled with CFR 0.152.
 */
package util.collections;

public class PseudoRandomCollection {
    static final double[] allNumbers = new double[]{0.9615683023688752, 0.8377021226155646, 0.6083691291411522, 0.7417259775888816, 0.11325837892276736, 0.48246624474453137, 0.29492243201826884, 0.34138514496913996, 0.47758663560000325, 0.1810240280884815, 0.5674198848794723, 0.334653394786087, 0.47600955600105177, 0.28215920017114693, 0.4566933218271032, 0.433454355793226, 0.08973499713473654, 0.9246321016449884, 0.818197879873546, 0.3672377468230298, 0.6379422788344226, 0.18152985334915617, 0.7131149777496698, 0.7101572502531976, 0.8941000509535127, 0.2346471047888501, 0.8200732300478174, 0.3044558021447288, 0.09558788049957379, 0.20368309314021193, 0.9331814054177382, 0.7061146783099838, 0.285617216529125, 0.5528934661661401, 0.37648255238395933, 0.8922982775051014, 0.3414857712369267, 0.5769361640410855, 0.47060153735872, 0.06485424747866153, 0.9894894410713854, 0.3280022664336695, 0.024273191876075795, 0.7601039026838778, 0.08435342015933689, 0.48792485386627116, 0.1916016078018694, 0.6323857955685117, 0.4398350753923088, 0.11180955000032533, 0.9353155324899673, 0.21729041737360755, 0.5371884993701084, 0.8738330356601496, 0.7669488998483461, 0.7002519966414786, 0.5094708862190345, 0.43120634338619757, 0.3967895115666761, 0.21713876542895882, 0.902209441247013, 0.788902206216554, 0.41960278514232674, 0.4957102554851659, 0.8447366140360226, 0.0955966146580457, 0.18655190787065357, 0.710286785198124, 0.431540633571984, 0.13037686264616521, 0.5693995312486068, 0.2667022433368932, 0.30926732535058055, 0.8501193078168243, 0.4099902172489618, 0.8605886834802704, 0.6925483468009895, 0.7590423668201594, 0.06617702784187396, 0.5592672078032059, 0.2906196927917738, 0.5347909175638195, 0.6147697382559163, 0.8459963012562063, 0.9167340130345256, 0.29951111677879483, 0.9527457802532261, 0.5350555214700691, 0.873658608398968, 0.15972450735311328, 0.24987994247990364, 0.2171188387158146, 0.5610907051140769, 0.15541372708742496, 0.9491121054122774, 0.426598475488268, 0.1346101964548334, 0.5565819416307352, 0.7853864464529742, 0.0361168912672295, 0.4608293236462735, 0.5246511191850086, 0.09936039282048736, 0.4779906857717008, 0.059687757878926884, 0.5164149296944139, 0.0592946375282043, 0.2685872479844703, 0.20238066075505945, 0.44986387353031965, 0.27260000051560673, 0.968641274555276, 0.8421964368652008, 0.5740518681411231, 0.6679315909803931, 0.1510946692569598, 0.5955795726921175, 0.18927519907634172, 0.4593834176948749, 0.16775038121461583, 0.5620235217591659, 0.849185907972981, 0.46625218915405586, 0.5070068939319632, 0.37393754186457606, 0.4430636558112131, 0.055001927058540345, 0.31716672551002356, 0.5014198653842509, 0.6043213748897331, 0.49447575953931444, 0.23328908526279435, 0.5019098231573407, 0.22042190393982086, 0.5710649738582393, 0.9902829783225913, 0.6009792548567003, 0.4297339762889528, 0.8974596566897081, 0.43091407771253587, 0.7180636413735875, 0.3824577421042795, 0.46676936295309845, 0.42462489401290504, 0.8097219090025498, 0.21560163292954826, 0.6532158142898812, 0.901544507266248, 0.1930532248888318, 0.14609364116216894, 0.041264736727256834, 0.6757905794906133, 0.3331878530818321, 0.32146195737557937, 0.17697661033078482, 0.983143194751994, 0.4313084776182352, 0.0841212072841181, 0.5785214924245734, 0.6903960701921529, 0.033447250453805144, 0.6031525242719743, 0.11721634737183195, 0.9471680212858499, 0.7953431712501098, 0.4065664605146464, 0.18610736078621937, 0.6456834613950285, 0.4849330907110706, 0.20739040905456818, 0.9100345492866089, 0.4300075237801948, 0.2815889904587088, 0.5585225786246849, 0.019278886503306114, 0.15344810034206646, 0.44000317235533826, 0.2941471475966331, 0.9083073094163606, 0.6213134272787072, 0.42666184204048263, 0.41960610415839816, 0.8317942335359264, 0.175940558612816, 0.7081371893246405, 0.09697521341471138, 0.15201292878075467, 0.18188646871723468, 0.47296632110263337, 0.6401929292266031, 0.044853324842758724, 0.7514002701951312, 0.7026753006512078, 0.9814426194213386, 0.09613810162188186, 0.11377158731292991, 0.1725449762161484, 0.8995903465220481, 0.7755715980115827, 0.8768764578365563, 0.15900462585915687, 0.41183146517598546, 0.8625710880966753, 0.05521893303836922, 0.8580784976301418, 0.12130136935013958, 0.5163939302272386, 0.14599316607332413, 0.7780994865876621, 0.9862570589735467, 0.832387662007129, 0.7231668503394327, 0.6599427775556896, 0.9305375718974772, 0.4068546191866067, 0.9893142991880712, 0.7993221425225637, 0.9503635474804161, 0.6449366831654298, 0.4759029830798577, 0.9982296893223068, 0.8891367344881712, 0.28908969772565896, 0.614964908799375, 0.7563899240784692, 0.8497527344115384, 0.9201310003269972, 0.21855996334504868, 0.7286371842379611, 0.2930415375997213, 0.988508161672152, 0.9971653073370497, 0.9204150852312093, 0.23130161117654546, 0.2703502586170631, 0.12410173323050833, 0.5711354859005484, 0.5674955074320456, 0.5110279491047606, 0.5103336933127605, 0.18392370362579924, 0.5535257652761064, 0.418361816572685, 0.8924569696980534, 0.7003153309690143, 0.5451124791531803, 0.0982833026862836, 0.05641428932298964, 0.3897598843045388, 0.7161441074202118, 0.487665951845056, 0.5204555647676317, 0.6263245667554644, 0.16197596687975324, 0.33220936070230367, 0.7830864179235908, 0.358781393014728, 0.8690016882687502, 0.7816715681345815, 0.8052246683808068, 0.745299389922578, 0.35692441594310864, 0.7304105563188662, 0.7405114939612241, 0.12025298289121233, 0.4105066790654486, 0.6181087537669424, 0.05370044736940427, 0.18819649939476601, 0.20917877865325063, 0.5237190208678489, 0.07427369377703508, 0.09884396515632654, 0.33573757926037606, 0.03508453114248489, 0.7209119263043537, 0.846932395613319, 0.5994687094864495, 0.557349011880042, 0.6021707359754869, 0.26213574374006965, 0.3443773437902756, 0.4351877227840616, 0.949692713480931, 0.7067358980783149, 0.9298135005337101, 0.5070539267530592, 0.8725110929672525, 0.4825460209252719, 0.36863021744043833, 0.484049444579018, 0.23447764091711065, 0.8636205826941075, 0.6871139115749176, 0.8516919153235196, 0.051573702900629015, 0.6175758037025182, 0.431277842297514, 0.8297655766235431, 0.21647888527004677};
    final double[] randomNumbers;
    int currIndex;

    public PseudoRandomCollection(int seed, int arrayLength) {
        this.randomNumbers = new double[arrayLength];
        this.currIndex = 0;
        int seedIndex = seed;
        for (int i = 0; i < arrayLength; ++i) {
            this.randomNumbers[i] = allNumbers[seedIndex];
            if (++seedIndex < allNumbers.length) continue;
            seedIndex = 0;
        }
    }

    public int getRandomInt() {
        this.currIndex = this.currIndex >= this.randomNumbers.length - 1 ? 0 : this.currIndex + 1;
        return (int)Math.pow(2.0, 31.0 * this.randomNumbers[this.currIndex]);
    }

    public int getRandomInt(int min, int max) {
        this.currIndex = this.currIndex >= this.randomNumbers.length - 1 ? 0 : this.currIndex + 1;
        return min + (int)Math.floor(this.randomNumbers[this.currIndex] * (double)(max - min));
    }

    public double getRandomDouble() {
        this.currIndex = this.currIndex >= this.randomNumbers.length - 1 ? 0 : this.currIndex + 1;
        return this.randomNumbers[this.currIndex];
    }

    public double getRandomDouble(double min, double max) {
        this.currIndex = this.currIndex >= this.randomNumbers.length - 1 ? 0 : this.currIndex + 1;
        return min + this.randomNumbers[this.currIndex] * (max - min);
    }

    public float getRandomFloat() {
        this.currIndex = this.currIndex >= this.randomNumbers.length - 1 ? 0 : this.currIndex + 1;
        return (float)this.randomNumbers[this.currIndex];
    }

    public float getRandomFloat(float min, float max) {
        this.currIndex = this.currIndex >= this.randomNumbers.length - 1 ? 0 : this.currIndex + 1;
        return min + (float)(this.randomNumbers[this.currIndex] * (double)(max - min));
    }

    public boolean getRandomBoolean() {
        this.currIndex = this.currIndex >= this.randomNumbers.length - 1 ? 0 : this.currIndex + 1;
        return this.randomNumbers[this.currIndex] >= 0.5;
    }

    public double getRandomGaussian() {
        double v2;
        double v1;
        double s;
        do {
            this.currIndex = this.currIndex >= this.randomNumbers.length - 1 ? 0 : this.currIndex + 1;
            v1 = 2.0 * this.randomNumbers[this.currIndex] - 1.0;
            int n = this.currIndex = this.currIndex >= this.randomNumbers.length - 1 ? 0 : this.currIndex + 1;
        } while ((s = v1 * v1 + (v2 = 2.0 * this.randomNumbers[this.currIndex] - 1.0) * v2) >= 1.0 || s == 0.0);
        double multiplier = Math.sqrt(-2.0 * Math.log(s) / s);
        return v1 * multiplier;
    }
}

