/*
 * Decompiled with CFR 0.152.
 */
package util.image.processing;

public class Blurring {
    public static final int EDGES_AS_ZERO = 0;
    public static final int EDGES_AS_ONE = 1;

    public static float[][] blur(float[][] pixels, float radius) {
        float[] kernel = Blurring.makeKernel(radius);
        float[][] outPixels = Blurring.convolveAndTranspose(kernel, pixels, Integer.MAX_VALUE);
        float[][] result = Blurring.convolveAndTranspose(kernel, outPixels, Integer.MAX_VALUE);
        return result;
    }

    public static float[][] blur(float[][] pixels, float radius, int edgeValue) {
        float[] kernel = Blurring.makeKernel(radius);
        float[][] outPixels = Blurring.convolveAndTranspose(kernel, pixels, edgeValue);
        float[][] result = Blurring.convolveAndTranspose(kernel, outPixels, edgeValue);
        return result;
    }

    public static float[][] convolveAndTranspose(float[] kernel, float[][] pixels, int edgeValue) {
        int col = kernel.length;
        int halfCol = col / 2;
        float[][] result = new float[pixels[0].length][pixels.length];
        for (int y = 0; y < pixels[0].length; ++y) {
            for (int x = 0; x < pixels.length; ++x) {
                float r = 0.0f;
                for (int i = -halfCol; i <= halfCol; ++i) {
                    float v = x + i < 0 ? (edgeValue == Integer.MAX_VALUE ? pixels[0][y] : (float)edgeValue) : (x + i > pixels.length - 1 ? (edgeValue == Integer.MAX_VALUE ? pixels[pixels.length - 1][y] : (float)edgeValue) : pixels[x + i][y]);
                    float f = kernel[halfCol + i];
                    if (f == 0.0f) continue;
                    r += f * v;
                }
                result[y][x] = r;
            }
        }
        return result;
    }

    public static float[][] blur(float[][] pixels, float[][] filter, float radius) {
        float[] kernel = Blurring.makeKernel(radius);
        float[][] outPixels = Blurring.convolveAndTranspose(kernel, pixels, filter, 1.0f, Integer.MAX_VALUE);
        float[][] result = Blurring.convolveAndTranspose(kernel, outPixels, filter, 1.0f, Integer.MAX_VALUE);
        return result;
    }

    public static float[][] blur(float[][] pixels, float[][] filter, float radius, int edgeValue) {
        float[] kernel = Blurring.makeKernel(radius);
        float[][] outPixels = Blurring.convolveAndTranspose(kernel, pixels, filter, 1.0f, edgeValue);
        float[][] result = Blurring.convolveAndTranspose(kernel, outPixels, filter, 1.0f, edgeValue);
        return result;
    }

    public static float[][] blur(float[][] pixels, float[][] filter, float radius, float filterModifier) {
        float[] kernel = Blurring.makeKernel(radius);
        float[][] outPixels = Blurring.convolveAndTranspose(kernel, pixels, filter, filterModifier, Integer.MAX_VALUE);
        float[][] result = Blurring.convolveAndTranspose(kernel, outPixels, filter, filterModifier, Integer.MAX_VALUE);
        return result;
    }

    public static float[][] blur(float[][] pixels, float[][] filter, float radius, float filterModifier, int edgeValue) {
        float[] kernel = Blurring.makeKernel(radius);
        float[][] outPixels = Blurring.convolveAndTranspose(kernel, pixels, filter, filterModifier, edgeValue);
        float[][] result = Blurring.convolveAndTranspose(kernel, outPixels, filter, filterModifier, edgeValue);
        return result;
    }

    public static float[][] convolveAndTranspose(float[] kernel, float[][] pixels, float[][] filter, float filterModifier, int edgeValue) {
        int col = kernel.length;
        int halfCol = col / 2;
        float[][] result = new float[pixels[0].length][pixels.length];
        for (int y = 0; y < pixels[0].length; ++y) {
            for (int x = 0; x < pixels.length; ++x) {
                float r = 0.0f;
                for (int i = -halfCol; i <= halfCol; ++i) {
                    float v = x + i < 0 ? (edgeValue == Integer.MAX_VALUE ? pixels[0][y] * filter[0][y] : (float)edgeValue) : (x + i > pixels.length - 1 ? (edgeValue == Integer.MAX_VALUE ? pixels[pixels.length - 1][y] * filter[pixels.length - 1][y] : (float)edgeValue) : pixels[x + i][y] * filter[x + i][y]);
                    float f = kernel[halfCol + i];
                    if (f == 0.0f) continue;
                    r += f * v;
                }
                result[y][x] = r * filterModifier;
            }
        }
        return result;
    }

    public static float[] makeKernel(float radius) {
        int r = (int)Math.ceil(radius);
        int rows = r * 2 + 1;
        float[] matrix = new float[rows];
        float sigma = radius / 3.0f;
        float sigma22 = 2.0f * sigma * sigma;
        float sigmaPi2 = (float)(Math.PI * 2 * (double)sigma);
        float sqrtSigmaPi2 = (float)Math.sqrt(sigmaPi2);
        float radius2 = radius * radius;
        float total = 0.0f;
        int index = 0;
        for (int row = -r; row <= r; ++row) {
            float distance = row * row;
            matrix[index] = distance > radius2 ? 0.0f : (float)Math.exp(-distance / sigma22) / sqrtSigmaPi2;
            total += matrix[index];
            ++index;
        }
        int i = 0;
        while (i < rows) {
            int n = i++;
            matrix[n] = matrix[n] / total;
        }
        return matrix;
    }
}

