/*
 * Decompiled with CFR 0.152.
 */
package util.image.processing;

import processing.core.PApplet;
import processing.core.PImage;
import util.image.processing.ImageProcessing;

public class EdgeDetection {
    public static float[][] sobelX(PImage grayscale, PApplet p) {
        ImageProcessing imgProc = new ImageProcessing(p);
        return EdgeDetection.sobelX(imgProc.getGrayscaleImage(grayscale));
    }

    public static float[][] sobelX(float[][] pixels) {
        int x;
        float[][] sobelX = new float[pixels.length][pixels[0].length];
        for (x = 1; x < pixels.length - 1; ++x) {
            for (int y = 1; y < pixels[x].length - 1; ++y) {
                sobelX[x][y] = (-pixels[x - 1][y - 1] - 2.0f * pixels[x - 1][y] - pixels[x - 1][y + 1] + pixels[x + 1][y - 1] + 2.0f * pixels[x + 1][y] + pixels[x + 1][y + 1]) / 8.0f;
            }
        }
        sobelX[0][0] = sobelX[1][1];
        sobelX[pixels.length - 1][0] = sobelX[pixels.length - 2][1];
        sobelX[0][pixels[0].length - 1] = sobelX[1][pixels[0].length - 2];
        sobelX[pixels.length - 1][pixels[0].length - 1] = sobelX[pixels.length - 2][pixels[0].length - 2];
        for (x = 1; x < pixels.length - 1; ++x) {
            sobelX[x][0] = sobelX[x][1];
            sobelX[x][pixels[0].length - 1] = sobelX[x][pixels[0].length - 2];
        }
        for (int y = 1; y < pixels[0].length - 1; ++y) {
            sobelX[0][y] = sobelX[1][y];
            sobelX[pixels.length - 1][y] = sobelX[pixels.length - 2][y];
        }
        return sobelX;
    }

    public static float[][] sobelY(PImage grayscale, PApplet p) {
        ImageProcessing imgProc = new ImageProcessing(p);
        return EdgeDetection.sobelY(imgProc.getGrayscaleImage(grayscale));
    }

    public static float[][] sobelY(float[][] pixels) {
        int x;
        float[][] sobelY = new float[pixels.length][pixels[0].length];
        for (x = 1; x < pixels.length - 1; ++x) {
            for (int y = 1; y < pixels[x].length - 1; ++y) {
                sobelY[x][y] = (-pixels[x - 1][y - 1] - 2.0f * pixels[x][y - 1] - pixels[x + 1][y - 1] + pixels[x - 1][y + 1] + 2.0f * pixels[x][y + 1] + pixels[x + 1][y + 1]) / 8.0f;
            }
        }
        sobelY[0][0] = sobelY[1][1];
        sobelY[pixels.length - 1][0] = sobelY[pixels.length - 2][1];
        sobelY[0][pixels[0].length - 1] = sobelY[1][pixels[0].length - 2];
        sobelY[pixels.length - 1][pixels[0].length - 1] = sobelY[pixels.length - 2][pixels[0].length - 2];
        for (x = 1; x < pixels.length - 1; ++x) {
            sobelY[x][0] = sobelY[x][1];
            sobelY[x][pixels[0].length - 1] = sobelY[x][pixels[0].length - 2];
        }
        for (int y = 1; y < pixels[0].length - 1; ++y) {
            sobelY[0][y] = sobelY[1][y];
            sobelY[pixels.length - 1][y] = sobelY[pixels.length - 2][y];
        }
        return sobelY;
    }
}

