/*
 * Decompiled with CFR 0.152.
 */
package util.image.processing;

public class Gradient {
    public static float[][] verticalGradient(float[] points, float[] values, int sizeX, int sizeY) {
        float[][] result = new float[sizeX][sizeY];
        int currIndex = 0;
        int[] pointsImg_Y = new int[points.length];
        for (int i = 0; i < pointsImg_Y.length; ++i) {
            pointsImg_Y[i] = (int)Math.floor(points[i] * (float)sizeY);
        }
        for (int y = 0; y < result[0].length; ++y) {
            if (y > pointsImg_Y[currIndex + 1] && currIndex < points.length - 2) {
                ++currIndex;
            }
            float interp = ((float)y - (float)pointsImg_Y[currIndex]) / (float)(pointsImg_Y[currIndex + 1] - pointsImg_Y[currIndex]);
            float currVal = values[currIndex] + (values[currIndex + 1] - values[currIndex]) * interp;
            for (int x = 0; x < result.length; ++x) {
                result[x][y] = currVal;
            }
        }
        return result;
    }

    public static float[][] horizontalalGradient(float[] points, float[] values, int sizeX, int sizeY) {
        float[][] result = new float[sizeX][sizeY];
        int currIndex = 0;
        int[] pointsImg_X = new int[points.length];
        for (int i = 0; i < pointsImg_X.length; ++i) {
            pointsImg_X[i] = (int)Math.floor(points[i] * (float)sizeX);
        }
        for (int x = 0; x < result.length; ++x) {
            if (x > pointsImg_X[currIndex] && currIndex < points.length - 1) {
                ++currIndex;
            }
            float interp = ((float)x - (float)pointsImg_X[currIndex]) / (float)(pointsImg_X[currIndex + 1] - pointsImg_X[currIndex]);
            float currVal = values[currIndex] + (values[currIndex + 1] - values[currIndex]) * interp;
            for (int y = 0; y < result[0].length; ++y) {
                result[x][y] = currVal;
            }
        }
        return result;
    }
}

