/*
 * Decompiled with CFR 0.152.
 */
package util.image.processing;

import java.util.HashMap;
import java.util.Vector;
import processing.core.PImage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistogramData {
    public static HashMap<Integer, Double> getColorFrequencies(PImage img) {
        HashMap<Integer, Double> result = new HashMap<Integer, Double>();
        double unit = 1.0 / (double)(img.width * img.height);
        for (int x = 0; x < img.width; ++x) {
            for (int y = 0; y < img.height; ++y) {
                int colorCode = img.get(x, y);
                if (!result.containsKey(colorCode)) {
                    result.put(colorCode, unit);
                    continue;
                }
                double currFrequency = result.get(colorCode);
                result.put(colorCode, currFrequency + unit);
            }
        }
        return result;
    }

    public static Vector<Integer> getColors(PImage img) {
        Vector<Integer> result = new Vector<Integer>();
        for (int x = 0; x < img.width; ++x) {
            for (int y = 0; y < img.height; ++y) {
                int colorCode = img.get(x, y);
                if (result.contains(colorCode)) continue;
                result.add(colorCode);
            }
        }
        return result;
    }
}

