/*
 * Decompiled with CFR 0.152.
 */
package util.image.processing;

import java.util.LinkedList;
import java.util.Vector;
import processing.core.PApplet;
import processing.core.PImage;
import util.math2d.Matrix2D;
import util.math2d.Point2D;
import util.statics.LogManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageProcessing {
    PApplet p;

    public ImageProcessing(PApplet p) {
        this.p = p;
    }

    public PImage getThresholdAbove(PImage base, int minColor) {
        PImage result = this.p.createImage(base.width, base.height, 1);
        for (int x = 0; x < base.width; ++x) {
            for (int y = 0; y < base.height; ++y) {
                int baseColor = base.get(x, y);
                if (this.p.red(baseColor) >= this.p.red(minColor) && this.p.green(baseColor) >= this.p.green(minColor) && this.p.blue(baseColor) >= this.p.blue(minColor)) {
                    result.set(x, y, this.p.color(255));
                    continue;
                }
                result.set(x, y, this.p.color(0));
            }
        }
        return result;
    }

    public PImage getThresholdBelow(PImage base, int maxColor) {
        PImage result = this.p.createImage(base.width, base.height, 1);
        for (int x = 0; x < base.width; ++x) {
            for (int y = 0; y < base.height; ++y) {
                int baseColor = base.get(x, y);
                if (this.p.red(baseColor) <= this.p.red(maxColor) && this.p.green(baseColor) <= this.p.green(maxColor) && this.p.blue(baseColor) <= this.p.blue(maxColor)) {
                    result.set(x, y, this.p.color(255));
                    continue;
                }
                result.set(x, y, this.p.color(0));
            }
        }
        return result;
    }

    public PImage getThresholdBetween(PImage base, int minColor, int maxColor) {
        PImage result = this.p.createImage(base.width, base.height, 1);
        for (int x = 0; x < base.width; ++x) {
            for (int y = 0; y < base.height; ++y) {
                int baseColor = base.get(x, y);
                if (this.p.red(baseColor) <= this.p.red(maxColor) && this.p.green(baseColor) <= this.p.green(maxColor) && this.p.blue(baseColor) <= this.p.blue(maxColor) && this.p.red(baseColor) >= this.p.red(minColor) && this.p.green(baseColor) >= this.p.green(minColor) && this.p.blue(baseColor) >= this.p.blue(minColor)) {
                    result.set(x, y, this.p.color(255));
                    continue;
                }
                result.set(x, y, this.p.color(0));
            }
        }
        return result;
    }

    public PImage getTransparentImage(PImage base, int alphaColor) {
        return this.getTransparentImage(base, Matrix2D.invert(this.getBinaryImage(base, alphaColor)));
    }

    public PImage getTransparentImage(PImage base, boolean[][] transparency) {
        if (transparency.length != base.width && transparency[0].length != base.height) {
            return null;
        }
        PImage result = this.p.createImage(base.width, base.height, 2);
        for (int x = 0; x < base.width; ++x) {
            for (int y = 0; y < base.height; ++y) {
                int baseColor = base.get(x, y);
                if (transparency[x][y]) {
                    result.set(x, y, this.p.color(0, 0, 0, 0));
                    continue;
                }
                result.set(x, y, baseColor);
            }
        }
        return result;
    }

    public boolean[][] getBinaryImage(PImage base) {
        return this.getBinaryImage(base, this.p.color(255), this.p.color(0));
    }

    public boolean[][] getBinaryImage(PImage base, int colorOn, int colorOff) {
        boolean[][] result = new boolean[base.width][base.height];
        for (int x = 0; x < base.width; ++x) {
            for (int y = 0; y < base.height; ++y) {
                int baseColor = base.get(x, y);
                if (baseColor == colorOn) {
                    result[x][y] = true;
                    continue;
                }
                if (baseColor == colorOff) {
                    result[x][y] = false;
                    continue;
                }
                LogManager.writeError("Error", this, "invalid image format");
            }
        }
        return result;
    }

    public boolean[][] getBinaryImage(PImage base, int alphaColor) {
        boolean[][] result = new boolean[base.width][base.height];
        for (int x = 0; x < base.width; ++x) {
            for (int y = 0; y < base.height; ++y) {
                int baseColor = base.get(x, y);
                result[x][y] = baseColor != alphaColor;
            }
        }
        return result;
    }

    public PImage getBinaryImage(boolean[][] base) {
        return this.getBinaryImage(base, this.p.color(255), this.p.color(0));
    }

    public PImage getBinaryImage(boolean[][] base, int colorOn, int colorOff) {
        PImage result = this.p.createImage(base.length, base[0].length, 1);
        for (int x = 0; x < base.length; ++x) {
            for (int y = 0; y < base[0].length; ++y) {
                int color = base[x][y] ? colorOn : colorOff;
                result.set(x, y, color);
            }
        }
        return result;
    }

    public PImage getImageDifference(PImage base, PImage other, boolean useAlpha) {
        if (other.pixels.length != base.pixels.length) {
            LogManager.writeError("Error", this, "image size mismatch");
            return null;
        }
        PImage result = this.p.createImage(base.width, base.height, 1);
        for (int x = 0; x < base.width; ++x) {
            for (int y = 0; y < base.height; ++y) {
                int baseColor = base.get(x, y);
                int otherColor = other.get(x, y);
                float redDiff = Math.abs(this.p.red(baseColor) - this.p.red(otherColor));
                float greenDiff = Math.abs(this.p.green(baseColor) - this.p.green(otherColor));
                float blueDiff = Math.abs(this.p.blue(baseColor) - this.p.blue(otherColor));
                float alphaDiff = Math.abs(this.p.alpha(baseColor) - this.p.alpha(otherColor));
                if (useAlpha) {
                    result.set(x, y, this.p.color(redDiff, greenDiff, blueDiff, alphaDiff));
                    continue;
                }
                result.set(x, y, this.p.color(redDiff, greenDiff, blueDiff));
            }
        }
        return result;
    }

    public int getAverageColor(PImage img) {
        float red = 0.0f;
        float green = 0.0f;
        float blue = 0.0f;
        float alpha = 0.0f;
        for (int x = 0; x < img.width; ++x) {
            for (int y = 0; y < img.height; ++y) {
                int colorCode = img.get(x, y);
                red += this.p.red(colorCode);
                green += this.p.green(colorCode);
                blue += this.p.blue(colorCode);
                alpha += this.p.alpha(colorCode);
            }
        }
        int imgSize = img.width * img.height;
        return this.p.color(red / (float)imgSize, green / (float)imgSize, blue / (float)imgSize, alpha / (float)imgSize);
    }

    public Vector<PImage> getSegments(PImage base, int mode) {
        Vector<PImage> result = new Vector<PImage>();
        boolean[][] binaryImg = this.getBinaryImage(base);
        Point2D firstNonEmpty = ImageProcessing.getFirstNonEmpty(binaryImg);
        while (firstNonEmpty != null) {
            boolean[][] currSegment = new boolean[base.width][base.height];
            ImageProcessing.floodEraseFrom(binaryImg, firstNonEmpty, mode, currSegment);
            result.add(this.getBinaryImage(currSegment));
            firstNonEmpty = ImageProcessing.getFirstNonEmpty(binaryImg);
        }
        return result;
    }

    public static Vector<boolean[][]> getSegments(boolean[][] base, int mode) {
        Vector<boolean[][]> result = new Vector<boolean[][]>();
        boolean[][] binaryImg = Matrix2D.copy(base);
        Point2D firstNonEmpty = ImageProcessing.getFirstNonEmpty(binaryImg);
        while (firstNonEmpty != null) {
            boolean[][] currSegment = new boolean[base.length][base[0].length];
            ImageProcessing.floodEraseFrom(binaryImg, firstNonEmpty, mode, currSegment);
            result.add(currSegment);
            firstNonEmpty = ImageProcessing.getFirstNonEmpty(binaryImg);
        }
        return result;
    }

    public static boolean[][] getInnerBorder(boolean[][] pixels) {
        boolean[][] result = new boolean[pixels.length][pixels[0].length];
        for (int x = 0; x < pixels.length; ++x) {
            boolean topMostAdded = false;
            boolean bottomMostAdded = false;
            for (int y = 0; y < pixels[x].length; ++y) {
                boolean edgeLeft = x > 0 && !pixels[x - 1][y] && pixels[x][y] || x == 0 && pixels[x][y];
                boolean edgeRight = x < pixels.length - 1 && pixels[x][y] && !pixels[x + 1][y] || x == pixels.length - 1 && pixels[x][y];
                boolean edgeTop = y > 0 && !pixels[x][y - 1] && pixels[x][y] || y == 0 && pixels[x][y];
                boolean edgeBottom = y < pixels[x].length - 1 && pixels[x][y] && !pixels[x][y + 1] || y == pixels[x].length - 1 && pixels[x][y];
                result[x][y] = edgeBottom || edgeTop || edgeRight || edgeLeft;
            }
        }
        return result;
    }

    public static boolean[][] getOuterBorder(boolean[][] pixels) {
        boolean[][] result = new boolean[pixels.length][pixels[0].length];
        for (int x = 0; x < pixels.length; ++x) {
            boolean topMostAdded = false;
            boolean bottomMostAdded = false;
            for (int y = 0; y < pixels[x].length; ++y) {
                boolean edgeLeft = x < pixels.length - 1 && pixels[x + 1][y] && !pixels[x][y];
                boolean edgeRight = x > 0 && !pixels[x][y] && pixels[x - 1][y];
                boolean edgeTop = y > 0 && pixels[x][y - 1] && !pixels[x][y];
                boolean edgeBottom = y < pixels[x].length - 1 && !pixels[x][y] && pixels[x][y + 1];
                result[x][y] = edgeBottom || edgeTop || edgeRight || edgeLeft;
            }
        }
        return result;
    }

    protected static void floodEraseFrom(boolean[][] pixels, Point2D startingPixel, int mode, boolean[][] targetPixels) {
        int x = (int)startingPixel.x;
        int y = (int)startingPixel.y;
        if (pixels[x][y]) {
            LinkedList<Point2D> queue = new LinkedList<Point2D>();
            queue.add(new Point2D(x, y));
            while (!queue.isEmpty()) {
                Point2D point = (Point2D)queue.remove();
                if (!(point.x >= 0.0) || !(point.y >= 0.0) || !(point.x < (double)pixels.length) || !(point.y < (double)pixels[0].length) || !pixels[(int)point.x][(int)point.y]) continue;
                pixels[(int)point.x][(int)point.y] = false;
                targetPixels[(int)point.x][(int)point.y] = true;
                if (mode == 0) {
                    queue.add(new Point2D(point.x + 1.0, point.y));
                    queue.add(new Point2D(point.x - 1.0, point.y));
                    queue.add(new Point2D(point.x, point.y + 1.0));
                    queue.add(new Point2D(point.x, point.y - 1.0));
                    continue;
                }
                if (mode == 1) {
                    queue.add(new Point2D(point.x + 1.0, point.y + 1.0));
                    queue.add(new Point2D(point.x + 1.0, point.y));
                    queue.add(new Point2D(point.x + 1.0, point.y - 1.0));
                    queue.add(new Point2D(point.x - 1.0, point.y + 1.0));
                    queue.add(new Point2D(point.x - 1.0, point.y));
                    queue.add(new Point2D(point.x - 1.0, point.y - 1.0));
                    queue.add(new Point2D(point.x, point.y + 1.0));
                    queue.add(new Point2D(point.x, point.y - 1.0));
                    continue;
                }
                LogManager.writeError("Error", null, "wrong flood erase mode");
            }
        }
    }

    public static boolean[][] getFloodFilledArea(boolean[][] pixels, int startingX, int startingY, int mode) {
        return ImageProcessing.getFloodFilledArea(pixels, new Point2D(startingX, startingY), mode);
    }

    public static boolean[][] getFloodFilledArea(boolean[][] pixels, Point2D startingPixel, int mode) {
        boolean[][] temp = Matrix2D.copy(pixels);
        boolean[][] result = new boolean[pixels.length][pixels[0].length];
        ImageProcessing.floodEraseFrom(temp, startingPixel, mode, result);
        return result;
    }

    protected static Point2D getFirstNonEmpty(boolean[][] pixels) {
        for (int x = 0; x < pixels.length; ++x) {
            for (int y = 0; y < pixels[0].length; ++y) {
                if (!pixels[x][y]) continue;
                return new Point2D(x, y);
            }
        }
        return null;
    }

    public float[][] getGrayscaleImage(PImage base) {
        float[][] result = new float[base.width][base.height];
        for (int x = 0; x < base.width; ++x) {
            for (int y = 0; y < base.height; ++y) {
                int baseColor = base.get(x, y);
                result[x][y] = Math.min(1.0f, this.p.hue(baseColor) / 255.0f);
            }
        }
        return result;
    }

    public PImage getGrayscaleImage(float[][] base) {
        PImage result = this.p.createImage(base.length, base[0].length, 1);
        for (int x = 0; x < base.length; ++x) {
            for (int y = 0; y < base[0].length; ++y) {
                int color = this.p.color(base[x][y]);
                result.set(x, y, color);
            }
        }
        return result;
    }
}

