/*
 * Decompiled with CFR 0.152.
 */
package util.image.processing;

import processing.core.PApplet;

public class Thresholding {
    PApplet p;

    public Thresholding(PApplet p) {
        this.p = p;
    }

    public boolean[][] getArrayOfColor(int[][] pixels, int r, int g, int b) {
        if (pixels.length == 0) {
            return null;
        }
        boolean[][] result = new boolean[pixels.length][pixels[0].length];
        for (int x = 0; x < pixels.length; ++x) {
            for (int y = 0; y < pixels[x].length; ++y) {
                result[x][y] = pixels[x][y] == this.p.color(r, g, b);
            }
        }
        return result;
    }

    public boolean[][] getArrayBelowColor(int[][] pixels, int r, int g, int b) {
        if (pixels.length == 0) {
            return null;
        }
        boolean[][] result = new boolean[pixels.length][pixels[0].length];
        for (int x = 0; x < pixels.length; ++x) {
            for (int y = 0; y < pixels[x].length; ++y) {
                result[x][y] = this.p.red(pixels[x][y]) < (float)r && this.p.green(pixels[x][y]) < (float)g && this.p.blue(pixels[x][y]) < (float)b;
            }
        }
        return result;
    }

    public boolean[][] getArrayAboveColor(int[][] pixels, int r, int g, int b) {
        if (pixels.length == 0) {
            return null;
        }
        boolean[][] result = new boolean[pixels.length][pixels[0].length];
        for (int x = 0; x < pixels.length; ++x) {
            for (int y = 0; y < pixels[x].length; ++y) {
                result[x][y] = this.p.red(pixels[x][y]) > (float)r && this.p.green(pixels[x][y]) > (float)g && this.p.blue(pixels[x][y]) > (float)b;
            }
        }
        return result;
    }

    public boolean[][] getArrayBetweenColors(int[][] pixels, int r1, int g1, int b1, int r2, int g2, int b2) {
        if (pixels.length == 0) {
            return null;
        }
        boolean[][] result = new boolean[pixels.length][pixels[0].length];
        for (int x = 0; x < pixels.length; ++x) {
            for (int y = 0; y < pixels[x].length; ++y) {
                result[x][y] = this.p.red(pixels[x][y]) >= (float)r1 && this.p.green(pixels[x][y]) >= (float)g1 && this.p.blue(pixels[x][y]) >= (float)b1 && this.p.red(pixels[x][y]) < (float)r2 && this.p.green(pixels[x][y]) < (float)g2 && this.p.blue(pixels[x][y]) < (float)b2;
            }
        }
        return result;
    }

    public static boolean[][] getArrayOfValue(float[][] pixels, float value) {
        if (pixels.length == 0) {
            return null;
        }
        boolean[][] result = new boolean[pixels.length][pixels[0].length];
        for (int x = 0; x < pixels.length; ++x) {
            for (int y = 0; y < pixels[x].length; ++y) {
                result[x][y] = pixels[x][y] == value;
            }
        }
        return result;
    }

    public static boolean[][] getArrayBelowValue(float[][] pixels, float value) {
        if (pixels.length == 0) {
            return null;
        }
        boolean[][] result = new boolean[pixels.length][pixels[0].length];
        for (int x = 0; x < pixels.length; ++x) {
            for (int y = 0; y < pixels[x].length; ++y) {
                result[x][y] = pixels[x][y] < value;
            }
        }
        return result;
    }

    public static boolean[][] getArrayAboveValue(float[][] pixels, float value) {
        if (pixels.length == 0) {
            return null;
        }
        boolean[][] result = new boolean[pixels.length][pixels[0].length];
        for (int x = 0; x < pixels.length; ++x) {
            for (int y = 0; y < pixels[x].length; ++y) {
                result[x][y] = pixels[x][y] > value;
            }
        }
        return result;
    }

    public static boolean[][] getArrayBetweenValues(float[][] pixels, float val1, float val2) {
        if (pixels.length == 0) {
            return null;
        }
        boolean[][] result = new boolean[pixels.length][pixels[0].length];
        for (int x = 0; x < pixels.length; ++x) {
            for (int y = 0; y < pixels[x].length; ++y) {
                result[x][y] = pixels[x][y] >= val1 && pixels[x][y] < val2;
            }
        }
        return result;
    }

    public boolean[] getArrayOfColor(int[] pixels, int r, int g, int b) {
        if (pixels.length == 0) {
            return null;
        }
        boolean[] result = new boolean[pixels.length];
        for (int i = 0; i < pixels.length; ++i) {
            result[i] = pixels[i] == this.p.color(r, g, b);
        }
        return result;
    }

    public boolean[] getArrayBelowColor(int[] pixels, int r, int g, int b) {
        if (pixels.length == 0) {
            return null;
        }
        boolean[] result = new boolean[pixels.length];
        for (int i = 0; i < pixels.length; ++i) {
            result[i] = this.p.red(pixels[i]) < (float)r && this.p.green(pixels[i]) < (float)g && this.p.blue(pixels[i]) < (float)b;
        }
        return result;
    }

    public boolean[] getArrayAboveColor(int[] pixels, int r, int g, int b) {
        if (pixels.length == 0) {
            return null;
        }
        boolean[] result = new boolean[pixels.length];
        for (int i = 0; i < pixels.length; ++i) {
            result[i] = this.p.red(pixels[i]) > (float)r && this.p.green(pixels[i]) > (float)g && this.p.blue(pixels[i]) > (float)b;
        }
        return result;
    }

    public boolean[] getArrayBetweenColors(int[] pixels, int r1, int g1, int b1, int r2, int g2, int b2) {
        if (pixels.length == 0) {
            return null;
        }
        boolean[] result = new boolean[pixels.length];
        for (int i = 0; i < pixels.length; ++i) {
            result[i] = this.p.red(pixels[i]) >= (float)r1 && this.p.green(pixels[i]) >= (float)g1 && this.p.blue(pixels[i]) >= (float)b1 && this.p.red(pixels[i]) < (float)r2 && this.p.green(pixels[i]) < (float)g2 && this.p.blue(pixels[i]) < (float)b2;
        }
        return result;
    }

    public static boolean[] getArrayOfValue(float[] pixels, float value) {
        if (pixels.length == 0) {
            return null;
        }
        boolean[] result = new boolean[pixels.length];
        for (int i = 0; i < pixels.length; ++i) {
            result[i] = pixels[i] == value;
        }
        return result;
    }

    public static boolean[] getArrayBelowValue(float[] pixels, float value) {
        if (pixels.length == 0) {
            return null;
        }
        boolean[] result = new boolean[pixels.length];
        for (int i = 0; i < pixels.length; ++i) {
            result[i] = pixels[i] < value;
        }
        return result;
    }

    public static boolean[] getArrayAboveValue(float[] pixels, float value) {
        if (pixels.length == 0) {
            return null;
        }
        boolean[] result = new boolean[pixels.length];
        for (int i = 0; i < pixels.length; ++i) {
            result[i] = pixels[i] > value;
        }
        return result;
    }

    public static boolean[] getArrayBetweenValues(float[] pixels, float val1, float val2) {
        if (pixels.length == 0) {
            return null;
        }
        boolean[] result = new boolean[pixels.length];
        for (int i = 0; i < pixels.length; ++i) {
            result[i] = pixels[i] >= val1 && pixels[i] < val2;
        }
        return result;
    }
}

