/*
 * Decompiled with CFR 0.152.
 */
package util.logs;

import java.text.SimpleDateFormat;
import java.util.Date;
import util.logs.Writer;

public class HTMLWriter
extends Writer {
    public HTMLWriter(String filename) {
        super(filename);
        try {
            this.writer.write("<HTML>\n");
            this.writer.write("<BODY>\n");
            this.writer.write("<TABLE BORDER=\"1\">\n");
            this.writer.write("</TABLE BORDER>\n");
            this.writer.write("</BODY>\n");
            this.writer.write("</HTML>\n");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public HTMLWriter(String filename, boolean append) {
        super(filename, append);
    }

    public void write(String text) {
        String htmlText = "<TR><TD>" + text + "</TD></TR>";
        super.write(htmlText);
    }

    public void writeError(Object callingObject, String text) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        Date date = new Date();
        String timestamp = dateFormat.format(date);
        String className = "";
        if (callingObject != null) {
            className = callingObject.getClass().getName();
        }
        String htmlText = "<TR><TD>" + timestamp + "</TD><TH>" + className + "</TD><TH>" + text + "</TD></TR>";
        super.write(htmlText);
    }
}

