/*
 * Decompiled with CFR 0.152.
 */
package util.logs;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Writer {
    String filename;
    String extension;
    BufferedWriter writer;

    public Writer(String filename) {
        this(filename, false);
    }

    public Writer(String filename, boolean append) {
        try {
            new File(filename).getParentFile().mkdirs();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        try {
            this.writer = new BufferedWriter(new FileWriter(filename, append));
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        this.filename = filename;
        this.extension = "";
        String[] allExtensions = filename.split(".");
        if (allExtensions.length > 0) {
            this.extension = allExtensions[allExtensions.length - 1];
        }
    }

    public void write(String text) {
        try {
            this.writer.append(text + "\n");
            this.writer.flush();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }

    public void writeError(Object callingObject, String text) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        Date date = new Date();
        String timestamp = dateFormat.format(date);
        String className = "";
        if (callingObject != null) {
            className = callingObject.getClass().getName();
        }
        String printoutText = timestamp + " " + className + " " + text;
        this.write(printoutText);
        System.out.println(printoutText);
    }

    public void close() {
        try {
            this.writer.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }
}

