/*
 * Decompiled with CFR 0.152.
 */
package util.math2d;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.Vector;
import util.math2d.Point2D;

public class FloodErase2D {
    Vector<SeperateSegment2D> segments = new Vector();
    int largestSegment = -1;

    public FloodErase2D(boolean[][] pixels, FloodDir directions) {
        this.runAlgorithm(pixels, directions);
    }

    protected void runAlgorithm(boolean[][] pixels, FloodDir directions) {
        Point2D firstNonEmpty = this.getFirstNonEmpty(pixels);
        while (firstNonEmpty != null) {
            SeperateSegment2D currSegment = new SeperateSegment2D(pixels.length, pixels[0].length);
            this.floodEraseFrom(pixels, firstNonEmpty, directions, currSegment);
            if (this.largestSegment < currSegment.getArea()) {
                this.largestSegment = this.segments.size();
            }
            this.segments.add(currSegment);
            firstNonEmpty = this.getFirstNonEmpty(pixels);
        }
    }

    public int getNumberOfSegments() {
        return this.segments.size();
    }

    public int getAreaOfLargestSegment() {
        if (this.largestSegment == -1 || this.segments.isEmpty()) {
            return 0;
        }
        return this.segments.get(this.largestSegment).getArea();
    }

    public int getAreaOfSmallerSegments() {
        if (this.largestSegment == -1 || this.segments.isEmpty()) {
            return 0;
        }
        int result = 0;
        for (int i = 0; i < this.segments.size(); ++i) {
            if (i == this.largestSegment) continue;
            result += this.segments.get(this.largestSegment).getArea();
        }
        return result;
    }

    public int getAreaOfSegment(int index) {
        if (index < 0 || index >= this.segments.size()) {
            System.out.println("segment index out of bounds");
        }
        return this.segments.get(index).getArea();
    }

    public boolean[][] getSegment(int index) {
        if (index < 0 || index >= this.segments.size()) {
            System.out.println("segment index out of bounds");
            return null;
        }
        return this.segments.get(index).getPixels();
    }

    protected void floodEraseFrom(boolean[][] pixels, Point2D startingPixel, FloodDir directions, SeperateSegment2D segment) {
        this.floodEraseFrom(pixels, (int)startingPixel.x, (int)startingPixel.y, directions, segment);
    }

    protected void floodEraseFrom(boolean[][] pixels, int start_x, int start_y, FloodDir directions, SeperateSegment2D segment) {
        int x = start_x;
        int y = start_y;
        if (pixels[x][y]) {
            LinkedList<Point2D> queue = new LinkedList<Point2D>();
            queue.add(new Point2D(x, y));
            boolean pixelCount = false;
            while (!queue.isEmpty()) {
                Point2D point = (Point2D)queue.remove();
                if (!(point.x >= 0.0) || !(point.y >= 0.0) || !(point.x < (double)pixels.length) || !(point.y < (double)pixels[0].length) || !pixels[(int)point.x][(int)point.y]) continue;
                pixels[(int)point.x][(int)point.y] = false;
                segment.addToArea();
                segment.assignPixel((int)point.x, (int)point.y, true);
                if (directions == FloodDir.HORIZONTAL) {
                    queue.add(new Point2D(point.x + 1.0, point.y));
                    queue.add(new Point2D(point.x - 1.0, point.y));
                    queue.add(new Point2D(point.x, point.y + 1.0));
                    queue.add(new Point2D(point.x, point.y - 1.0));
                    continue;
                }
                if (directions != FloodDir.DIAGONAL) continue;
                queue.add(new Point2D(point.x + 1.0, point.y + 1.0));
                queue.add(new Point2D(point.x + 1.0, point.y));
                queue.add(new Point2D(point.x + 1.0, point.y - 1.0));
                queue.add(new Point2D(point.x - 1.0, point.y + 1.0));
                queue.add(new Point2D(point.x - 1.0, point.y));
                queue.add(new Point2D(point.x - 1.0, point.y - 1.0));
                queue.add(new Point2D(point.x, point.y + 1.0));
                queue.add(new Point2D(point.x, point.y - 1.0));
            }
        }
    }

    public static boolean[][] floodCoverage(boolean[][] pixels, int start_x, int start_y, FloodDir directions) {
        boolean[][] result = new boolean[pixels.length][pixels[0].length];
        for (int x = 0; x < result.length; ++x) {
            for (int y = 0; y < result[x].length; ++y) {
                result[x][y] = false;
            }
        }
        if (!pixels[start_x][start_y]) {
            return result;
        }
        boolean[][] pixelsCopy = new boolean[pixels.length][pixels[0].length];
        for (int x = 0; x < pixels.length; ++x) {
            pixelsCopy[x] = Arrays.copyOf(pixels[x], pixels[x].length);
        }
        LinkedList<Point2D> queue = new LinkedList<Point2D>();
        queue.add(new Point2D(start_x, start_y));
        boolean pixelCount = false;
        while (!queue.isEmpty()) {
            Point2D point = (Point2D)queue.remove();
            if (!(point.x >= 0.0) || !(point.y >= 0.0) || !(point.x < (double)pixelsCopy.length) || !(point.y < (double)pixelsCopy[0].length) || !pixelsCopy[(int)point.x][(int)point.y]) continue;
            pixelsCopy[(int)point.x][(int)point.y] = false;
            result[(int)point.x][(int)point.y] = true;
            if (directions == FloodDir.HORIZONTAL) {
                queue.add(new Point2D(point.x + 1.0, point.y));
                queue.add(new Point2D(point.x - 1.0, point.y));
                queue.add(new Point2D(point.x, point.y + 1.0));
                queue.add(new Point2D(point.x, point.y - 1.0));
                continue;
            }
            if (directions != FloodDir.DIAGONAL) continue;
            queue.add(new Point2D(point.x + 1.0, point.y + 1.0));
            queue.add(new Point2D(point.x + 1.0, point.y));
            queue.add(new Point2D(point.x + 1.0, point.y - 1.0));
            queue.add(new Point2D(point.x - 1.0, point.y + 1.0));
            queue.add(new Point2D(point.x - 1.0, point.y));
            queue.add(new Point2D(point.x - 1.0, point.y - 1.0));
            queue.add(new Point2D(point.x, point.y + 1.0));
            queue.add(new Point2D(point.x, point.y - 1.0));
        }
        return result;
    }

    protected Point2D getFirstNonEmpty(boolean[][] pixels) {
        for (int x = 0; x < pixels.length; ++x) {
            for (int y = 0; y < pixels[0].length; ++y) {
                if (!pixels[x][y]) continue;
                return new Point2D(x, y);
            }
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FloodDir {
        DIAGONAL,
        HORIZONTAL;

    }

    class SeperateSegment2D {
        boolean[][] pixels;
        int area = 0;

        public SeperateSegment2D(int sizeX, int sizeY) {
            this.pixels = new boolean[sizeX][sizeY];
            for (int x = 0; x < this.pixels.length; ++x) {
                for (int y = 0; y < this.pixels[0].length; ++y) {
                    this.pixels[x][y] = false;
                }
            }
        }

        public void assignPixel(int x, int y, boolean value) {
            this.pixels[x][y] = value;
        }

        public boolean[][] getPixels() {
            return this.pixels;
        }

        public void addToArea() {
            ++this.area;
        }

        public void addToArea(int value) {
            this.area += value;
        }

        public int getArea() {
            return this.area;
        }
    }
}

