/*
 * Decompiled with CFR 0.152.
 */
package util.math2d;

import java.util.Vector;
import util.math2d.Point2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Matrix2D {
    public static boolean[][] transpose(boolean[][] base) {
        if (base == null) {
            return null;
        }
        boolean[][] result = new boolean[base[0].length][base.length];
        for (int x = 0; x < base.length; ++x) {
            for (int y = 0; y < base[0].length; ++y) {
                result[y][x] = base[x][y];
            }
        }
        return result;
    }

    public static boolean[][] reflectHorizontal(boolean[][] base) {
        if (base == null) {
            return null;
        }
        boolean[][] result = new boolean[base.length][base[0].length];
        for (int x = 0; x < base.length; ++x) {
            for (int y = 0; y < base[0].length; ++y) {
                result[x][y] = base[base.length - 1 - x][y];
            }
        }
        return result;
    }

    public static boolean[][] reflectVertical(boolean[][] base) {
        if (base == null) {
            return null;
        }
        boolean[][] result = new boolean[base.length][base[0].length];
        for (int x = 0; x < base.length; ++x) {
            for (int y = 0; y < base[0].length; ++y) {
                result[x][y] = base[x][base[0].length - 1 - y];
            }
        }
        return result;
    }

    public static boolean[][] union(boolean[][] base, boolean[][] addition) {
        if (base == null || addition == null || base.length != addition.length || base[0].length != addition[0].length) {
            return null;
        }
        boolean[][] result = new boolean[base.length][base[0].length];
        for (int x = 0; x < base.length; ++x) {
            for (int y = 0; y < base[0].length; ++y) {
                result[x][y] = base[x][y] || addition[x][y];
            }
        }
        return result;
    }

    public static boolean[][] intersection(boolean[][] base, boolean[][] addition) {
        if (base == null || addition == null || base.length != addition.length || base[0].length != addition[0].length) {
            return null;
        }
        boolean[][] result = new boolean[base.length][base[0].length];
        for (int x = 0; x < base.length; ++x) {
            for (int y = 0; y < base[0].length; ++y) {
                result[x][y] = base[x][y] && addition[x][y];
            }
        }
        return result;
    }

    public static boolean[][] xor(boolean[][] base, boolean[][] addition) {
        if (base == null || addition == null || base.length != addition.length || base[0].length != addition[0].length) {
            return null;
        }
        boolean[][] result = new boolean[base.length][base[0].length];
        for (int x = 0; x < base.length; ++x) {
            for (int y = 0; y < base[0].length; ++y) {
                result[x][y] = base[x][y] && !addition[x][y] || !base[x][y] && addition[x][y];
            }
        }
        return result;
    }

    public static boolean[][] invert(boolean[][] base) {
        if (base == null) {
            return null;
        }
        boolean[][] result = new boolean[base.length][base[0].length];
        for (int x = 0; x < base.length; ++x) {
            for (int y = 0; y < base[0].length; ++y) {
                result[x][y] = !base[x][y];
            }
        }
        return result;
    }

    public static int[][] add(int[][] base, int[][] subtracted) {
        if (base == null) {
            return null;
        }
        int[][] result = new int[base.length][base[0].length];
        for (int x = 0; x < base.length; ++x) {
            for (int y = 0; y < base[0].length; ++y) {
                result[x][y] = base[x][y] + subtracted[x][y];
            }
        }
        return result;
    }

    public static float[][] add(float[][] base, float[][] subtracted) {
        if (base == null) {
            return null;
        }
        float[][] result = new float[base.length][base[0].length];
        for (int x = 0; x < base.length; ++x) {
            for (int y = 0; y < base[0].length; ++y) {
                result[x][y] = base[x][y] + subtracted[x][y];
            }
        }
        return result;
    }

    public static double[][] add(double[][] base, double[][] subtracted) {
        if (base == null) {
            return null;
        }
        double[][] result = new double[base.length][base[0].length];
        for (int x = 0; x < base.length; ++x) {
            for (int y = 0; y < base[0].length; ++y) {
                result[x][y] = base[x][y] + subtracted[x][y];
            }
        }
        return result;
    }

    public static int[][] add(int[][] base, int value) {
        if (base == null) {
            return null;
        }
        int[][] result = new int[base.length][base[0].length];
        for (int x = 0; x < base.length; ++x) {
            for (int y = 0; y < base[0].length; ++y) {
                result[x][y] = base[x][y] + value;
            }
        }
        return result;
    }

    public static float[][] add(float[][] base, float value) {
        if (base == null) {
            return null;
        }
        float[][] result = new float[base.length][base[0].length];
        for (int x = 0; x < base.length; ++x) {
            for (int y = 0; y < base[0].length; ++y) {
                result[x][y] = base[x][y] + value;
            }
        }
        return result;
    }

    public static double[][] add(double[][] base, double value) {
        if (base == null) {
            return null;
        }
        double[][] result = new double[base.length][base[0].length];
        for (int x = 0; x < base.length; ++x) {
            for (int y = 0; y < base[0].length; ++y) {
                result[x][y] = base[x][y] + value;
            }
        }
        return result;
    }

    public static boolean[][] subtract(boolean[][] base, boolean[][] subtracted) {
        if (base == null) {
            return null;
        }
        boolean[][] result = new boolean[base.length][base[0].length];
        for (int x = 0; x < base.length; ++x) {
            for (int y = 0; y < base[0].length; ++y) {
                if (subtracted[x][y]) continue;
                result[x][y] = base[x][y];
            }
        }
        return result;
    }

    public static int[][] subtract(int[][] base, int[][] subtracted) {
        if (base == null) {
            return null;
        }
        int[][] result = new int[base.length][base[0].length];
        for (int x = 0; x < base.length; ++x) {
            for (int y = 0; y < base[0].length; ++y) {
                result[x][y] = base[x][y] - subtracted[x][y];
            }
        }
        return result;
    }

    public static float[][] subtract(float[][] base, float[][] subtracted) {
        if (base == null) {
            return null;
        }
        float[][] result = new float[base.length][base[0].length];
        for (int x = 0; x < base.length; ++x) {
            for (int y = 0; y < base[0].length; ++y) {
                result[x][y] = base[x][y] - subtracted[x][y];
            }
        }
        return result;
    }

    public static double[][] subtract(double[][] base, double[][] subtracted) {
        if (base == null) {
            return null;
        }
        double[][] result = new double[base.length][base[0].length];
        for (int x = 0; x < base.length; ++x) {
            for (int y = 0; y < base[0].length; ++y) {
                result[x][y] = base[x][y] - subtracted[x][y];
            }
        }
        return result;
    }

    public static int[][] subtract(int[][] base, int value) {
        if (base == null) {
            return null;
        }
        int[][] result = new int[base.length][base[0].length];
        for (int x = 0; x < base.length; ++x) {
            for (int y = 0; y < base[0].length; ++y) {
                result[x][y] = base[x][y] - value;
            }
        }
        return result;
    }

    public static float[][] subtract(float[][] base, float value) {
        if (base == null) {
            return null;
        }
        float[][] result = new float[base.length][base[0].length];
        for (int x = 0; x < base.length; ++x) {
            for (int y = 0; y < base[0].length; ++y) {
                result[x][y] = base[x][y] - value;
            }
        }
        return result;
    }

    public static double[][] subtract(double[][] base, double value) {
        if (base == null) {
            return null;
        }
        double[][] result = new double[base.length][base[0].length];
        for (int x = 0; x < base.length; ++x) {
            for (int y = 0; y < base[0].length; ++y) {
                result[x][y] = base[x][y] - value;
            }
        }
        return result;
    }

    public static int[][] absDifference(int[][] base, int[][] subtracted) {
        if (base == null) {
            return null;
        }
        int[][] result = new int[base.length][base[0].length];
        for (int x = 0; x < base.length; ++x) {
            for (int y = 0; y < base[0].length; ++y) {
                result[x][y] = Math.abs(base[x][y] - subtracted[x][y]);
            }
        }
        return result;
    }

    public static float[][] absDifference(float[][] base, float[][] subtracted) {
        if (base == null) {
            return null;
        }
        float[][] result = new float[base.length][base[0].length];
        for (int x = 0; x < base.length; ++x) {
            for (int y = 0; y < base[0].length; ++y) {
                result[x][y] = Math.abs(base[x][y] - subtracted[x][y]);
            }
        }
        return result;
    }

    public static double[][] absDifference(double[][] base, double[][] subtracted) {
        if (base == null) {
            return null;
        }
        double[][] result = new double[base.length][base[0].length];
        for (int x = 0; x < base.length; ++x) {
            for (int y = 0; y < base[0].length; ++y) {
                result[x][y] = Math.abs(base[x][y] - subtracted[x][y]);
            }
        }
        return result;
    }

    public static boolean[][] transformPointList(Vector<Point2D> base, int sizeX, int sizeY) {
        if (base == null) {
            return null;
        }
        boolean[][] result = new boolean[sizeX][sizeY];
        for (int x = 0; x < result.length; ++x) {
            for (int y = 0; y < result[0].length; ++y) {
                result[x][y] = false;
            }
        }
        for (int i = 0; i < base.size(); ++i) {
            result[(int)base.get((int)i).x][(int)base.get((int)i).y] = true;
        }
        return result;
    }

    public static Vector<Point2D> transformPointList(boolean[][] base) {
        if (base == null) {
            return null;
        }
        Vector<Point2D> result = new Vector<Point2D>();
        for (int x = 0; x < base.length; ++x) {
            for (int y = 0; y < base[0].length; ++y) {
                if (!base[x][y]) continue;
                result.add(new Point2D(x, y));
            }
        }
        return result;
    }

    public static int[][] max(int[][] base, int maxVal) {
        if (base == null) {
            return null;
        }
        int[][] result = new int[base.length][base[0].length];
        for (int x = 0; x < base.length; ++x) {
            for (int y = 0; y < base[0].length; ++y) {
                result[x][y] = Math.max(base[x][y], maxVal);
            }
        }
        return result;
    }

    public static float[][] max(float[][] base, float maxVal) {
        if (base == null) {
            return null;
        }
        float[][] result = new float[base.length][base[0].length];
        for (int x = 0; x < base.length; ++x) {
            for (int y = 0; y < base[0].length; ++y) {
                result[x][y] = Math.max(base[x][y], maxVal);
            }
        }
        return result;
    }

    public static double[][] max(double[][] base, double maxVal) {
        if (base == null) {
            return null;
        }
        double[][] result = new double[base.length][base[0].length];
        for (int x = 0; x < base.length; ++x) {
            for (int y = 0; y < base[0].length; ++y) {
                result[x][y] = Math.max(base[x][y], maxVal);
            }
        }
        return result;
    }

    public static int maxValue(int[][] base) {
        if (base == null) {
            return Integer.MIN_VALUE;
        }
        int result = Integer.MIN_VALUE;
        for (int x = 0; x < base.length; ++x) {
            for (int y = 0; y < base[0].length; ++y) {
                if (base[x][y] <= result) continue;
                result = base[x][y];
            }
        }
        return result;
    }

    public static float maxValue(float[][] base) {
        if (base == null) {
            return Float.NEGATIVE_INFINITY;
        }
        float result = Float.NEGATIVE_INFINITY;
        for (int x = 0; x < base.length; ++x) {
            for (int y = 0; y < base[0].length; ++y) {
                if (!(base[x][y] > result)) continue;
                result = base[x][y];
            }
        }
        return result;
    }

    public static double maxValue(double[][] base) {
        if (base == null) {
            return Double.NEGATIVE_INFINITY;
        }
        double result = Double.NEGATIVE_INFINITY;
        for (int x = 0; x < base.length; ++x) {
            for (int y = 0; y < base[0].length; ++y) {
                if (!(base[x][y] > result)) continue;
                result = base[x][y];
            }
        }
        return result;
    }

    public static int[][] min(int[][] base, int minVal) {
        if (base == null) {
            return null;
        }
        int[][] result = new int[base.length][base[0].length];
        for (int x = 0; x < base.length; ++x) {
            for (int y = 0; y < base[0].length; ++y) {
                result[x][y] = Math.min(base[x][y], minVal);
            }
        }
        return result;
    }

    public static float[][] min(float[][] base, float minVal) {
        if (base == null) {
            return null;
        }
        float[][] result = new float[base.length][base[0].length];
        for (int x = 0; x < base.length; ++x) {
            for (int y = 0; y < base[0].length; ++y) {
                result[x][y] = Math.min(base[x][y], minVal);
            }
        }
        return result;
    }

    public static double[][] min(double[][] base, double minVal) {
        if (base == null) {
            return null;
        }
        double[][] result = new double[base.length][base[0].length];
        for (int x = 0; x < base.length; ++x) {
            for (int y = 0; y < base[0].length; ++y) {
                result[x][y] = Math.min(base[x][y], minVal);
            }
        }
        return result;
    }

    public static int minValue(int[][] base) {
        if (base == null) {
            return Integer.MAX_VALUE;
        }
        int result = Integer.MAX_VALUE;
        for (int x = 0; x < base.length; ++x) {
            for (int y = 0; y < base[0].length; ++y) {
                if (base[x][y] >= result) continue;
                result = base[x][y];
            }
        }
        return result;
    }

    public static float minValue(float[][] base) {
        if (base == null) {
            return Float.POSITIVE_INFINITY;
        }
        float result = Float.POSITIVE_INFINITY;
        for (int x = 0; x < base.length; ++x) {
            for (int y = 0; y < base[0].length; ++y) {
                if (!(base[x][y] < result)) continue;
                result = base[x][y];
            }
        }
        return result;
    }

    public static double minValue(double[][] base) {
        if (base == null) {
            return Double.POSITIVE_INFINITY;
        }
        double result = Double.POSITIVE_INFINITY;
        for (int x = 0; x < base.length; ++x) {
            for (int y = 0; y < base[0].length; ++y) {
                if (!(base[x][y] < result)) continue;
                result = base[x][y];
            }
        }
        return result;
    }

    public static int[][] abs(int[][] base) {
        if (base == null) {
            return null;
        }
        int[][] result = new int[base.length][base[0].length];
        for (int x = 0; x < base.length; ++x) {
            for (int y = 0; y < base[0].length; ++y) {
                result[x][y] = Math.abs(base[x][y]);
            }
        }
        return result;
    }

    public static float[][] abs(float[][] base) {
        if (base == null) {
            return null;
        }
        float[][] result = new float[base.length][base[0].length];
        for (int x = 0; x < base.length; ++x) {
            for (int y = 0; y < base[0].length; ++y) {
                result[x][y] = Math.abs(base[x][y]);
            }
        }
        return result;
    }

    public static double[][] abs(double[][] base) {
        if (base == null) {
            return null;
        }
        double[][] result = new double[base.length][base[0].length];
        for (int x = 0; x < base.length; ++x) {
            for (int y = 0; y < base[0].length; ++y) {
                result[x][y] = Math.abs(base[x][y]);
            }
        }
        return result;
    }

    public static float[][] normalize(float[][] base) {
        if (base == null) {
            return null;
        }
        float minVal = Matrix2D.minValue(base);
        float maxVal = Matrix2D.maxValue(base);
        float range = maxVal - minVal;
        float[][] result = new float[base.length][base[0].length];
        for (int x = 0; x < base.length; ++x) {
            for (int y = 0; y < base[0].length; ++y) {
                result[x][y] = range == 0.0f ? 0.0f : (base[x][y] - minVal) / range;
            }
        }
        return result;
    }

    public static double[][] normalize(double[][] base) {
        if (base == null) {
            return null;
        }
        double minVal = Matrix2D.minValue(base);
        double maxVal = Matrix2D.maxValue(base);
        double range = maxVal - minVal;
        double[][] result = new double[base.length][base[0].length];
        for (int x = 0; x < base.length; ++x) {
            for (int y = 0; y < base[0].length; ++y) {
                result[x][y] = range == 0.0 ? 0.0 : (base[x][y] - minVal) / range;
            }
        }
        return result;
    }

    public static float[][] normalize(float[][] base, float zeroValue, float oneValue) {
        if (base == null) {
            return null;
        }
        float range = oneValue - zeroValue;
        float[][] result = new float[base.length][base[0].length];
        for (int x = 0; x < base.length; ++x) {
            for (int y = 0; y < base[0].length; ++y) {
                if (range == 0.0f) {
                    result[x][y] = 0.0f;
                    continue;
                }
                result[x][y] = (base[x][y] - zeroValue) / range;
                result[x][y] = Math.min(1.0f, Math.max(result[x][y], 0.0f));
            }
        }
        return result;
    }

    public static double[][] normalize(double[][] base, double zeroValue, double oneValue) {
        if (base == null) {
            return null;
        }
        double range = oneValue - zeroValue;
        double[][] result = new double[base.length][base[0].length];
        for (int x = 0; x < base.length; ++x) {
            for (int y = 0; y < base[0].length; ++y) {
                if (range == 0.0) {
                    result[x][y] = 0.0;
                    continue;
                }
                result[x][y] = (base[x][y] - zeroValue) / range;
                result[x][y] = Math.min(1.0, Math.max(result[x][y], 0.0));
            }
        }
        return result;
    }

    public static int[][] multiply(int[][] base, double value) {
        if (base == null) {
            return null;
        }
        int minVal = Matrix2D.minValue(base);
        int maxVal = Matrix2D.maxValue(base);
        int range = maxVal - minVal;
        int[][] result = new int[base.length][base[0].length];
        for (int x = 0; x < base.length; ++x) {
            for (int y = 0; y < base[0].length; ++y) {
                result[x][y] = (int)Math.round(value * (double)base[x][y]);
            }
        }
        return result;
    }

    public static float[][] multiply(float[][] base, double value) {
        if (base == null) {
            return null;
        }
        float minVal = Matrix2D.minValue(base);
        float maxVal = Matrix2D.maxValue(base);
        float range = maxVal - minVal;
        float[][] result = new float[base.length][base[0].length];
        for (int x = 0; x < base.length; ++x) {
            for (int y = 0; y < base[0].length; ++y) {
                result[x][y] = (float)value * base[x][y];
            }
        }
        return result;
    }

    public static double[][] multiply(double[][] base, double value) {
        if (base == null) {
            return null;
        }
        double minVal = Matrix2D.minValue(base);
        double maxVal = Matrix2D.maxValue(base);
        double range = maxVal - minVal;
        double[][] result = new double[base.length][base[0].length];
        for (int x = 0; x < base.length; ++x) {
            for (int y = 0; y < base[0].length; ++y) {
                result[x][y] = value * base[x][y];
            }
        }
        return result;
    }

    public static int count(boolean[][] base) {
        if (base == null) {
            return 0;
        }
        int result = 0;
        for (int x = 0; x < base.length; ++x) {
            for (int y = 0; y < base[0].length; ++y) {
                if (!base[x][y]) continue;
                ++result;
            }
        }
        return result;
    }

    public static int count(int[][] base) {
        if (base == null) {
            return 0;
        }
        int result = 0;
        for (int x = 0; x < base.length; ++x) {
            for (int y = 0; y < base[0].length; ++y) {
                result += base[x][y];
            }
        }
        return result;
    }

    public static float count(float[][] base) {
        if (base == null) {
            return 0.0f;
        }
        float result = 0.0f;
        for (int x = 0; x < base.length; ++x) {
            for (int y = 0; y < base[0].length; ++y) {
                result += base[x][y];
            }
        }
        return result;
    }

    public static double count(double[][] base) {
        if (base == null) {
            return 0.0;
        }
        double result = 0.0;
        for (int x = 0; x < base.length; ++x) {
            for (int y = 0; y < base[0].length; ++y) {
                result += base[x][y];
            }
        }
        return result;
    }

    public static boolean[][] copy(boolean[][] base) {
        if (base == null) {
            return null;
        }
        boolean[][] result = new boolean[base.length][base[0].length];
        for (int x = 0; x < base.length; ++x) {
            for (int y = 0; y < base[0].length; ++y) {
                result[x][y] = base[x][y];
            }
        }
        return result;
    }

    public static int[][] copy(int[][] base) {
        if (base == null) {
            return null;
        }
        int[][] result = new int[base.length][base[0].length];
        for (int x = 0; x < base.length; ++x) {
            for (int y = 0; y < base[0].length; ++y) {
                result[x][y] = base[x][y];
            }
        }
        return result;
    }

    public static float[][] copy(float[][] base) {
        if (base == null) {
            return null;
        }
        float[][] result = new float[base.length][base[0].length];
        for (int x = 0; x < base.length; ++x) {
            for (int y = 0; y < base[0].length; ++y) {
                result[x][y] = base[x][y];
            }
        }
        return result;
    }

    public static double[][] copy(double[][] base) {
        if (base == null) {
            return null;
        }
        double[][] result = new double[base.length][base[0].length];
        for (int x = 0; x < base.length; ++x) {
            for (int y = 0; y < base[0].length; ++y) {
                result[x][y] = base[x][y];
            }
        }
        return result;
    }

    public static int[][] makeInteger(int sizeX, int sizeY, int value) {
        int[][] result = new int[sizeX][sizeY];
        for (int x = 0; x < result.length; ++x) {
            for (int y = 0; y < result[0].length; ++y) {
                result[x][y] = value;
            }
        }
        return result;
    }

    public static int[][] makeInteger(boolean[][] base, int onValue, int offValue) {
        if (base == null) {
            return null;
        }
        int[][] result = new int[base.length][base[0].length];
        for (int x = 0; x < base.length; ++x) {
            for (int y = 0; y < base[0].length; ++y) {
                result[x][y] = base[x][y] ? onValue : offValue;
            }
        }
        return result;
    }

    public static float[][] makeFloat(int sizeX, int sizeY, float value) {
        float[][] result = new float[sizeX][sizeY];
        for (int x = 0; x < result.length; ++x) {
            for (int y = 0; y < result[0].length; ++y) {
                result[x][y] = value;
            }
        }
        return result;
    }

    public static float[][] makeFloat(boolean[][] base, float onValue, float offValue) {
        if (base == null) {
            return null;
        }
        float[][] result = new float[base.length][base[0].length];
        for (int x = 0; x < base.length; ++x) {
            for (int y = 0; y < base[0].length; ++y) {
                result[x][y] = base[x][y] ? onValue : offValue;
            }
        }
        return result;
    }

    public static double[][] makeDouble(int sizeX, int sizeY, double value) {
        double[][] result = new double[sizeX][sizeY];
        for (int x = 0; x < result.length; ++x) {
            for (int y = 0; y < result[0].length; ++y) {
                result[x][y] = value;
            }
        }
        return result;
    }

    public static double[][] makeDouble(boolean[][] base, double onValue, double offValue) {
        if (base == null) {
            return null;
        }
        double[][] result = new double[base.length][base[0].length];
        for (int x = 0; x < base.length; ++x) {
            for (int y = 0; y < base[0].length; ++y) {
                result[x][y] = base[x][y] ? onValue : offValue;
            }
        }
        return result;
    }

    public static int[][] filter(int[][] base, boolean[][] filter, int offValue) {
        if (base == null) {
            return null;
        }
        int[][] result = new int[base.length][base[0].length];
        for (int x = 0; x < base.length; ++x) {
            for (int y = 0; y < base[0].length; ++y) {
                result[x][y] = filter[x][y] ? base[x][y] : offValue;
            }
        }
        return result;
    }

    public static float[][] filter(float[][] base, boolean[][] filter, float offValue) {
        if (base == null) {
            return null;
        }
        float[][] result = new float[base.length][base[0].length];
        for (int x = 0; x < base.length; ++x) {
            for (int y = 0; y < base[0].length; ++y) {
                result[x][y] = filter[x][y] ? base[x][y] : offValue;
            }
        }
        return result;
    }

    public static double[][] filter(double[][] base, boolean[][] filter, double offValue) {
        if (base == null) {
            return null;
        }
        double[][] result = new double[base.length][base[0].length];
        for (int x = 0; x < base.length; ++x) {
            for (int y = 0; y < base[0].length; ++y) {
                result[x][y] = filter[x][y] ? base[x][y] : offValue;
            }
        }
        return result;
    }

    public static int[][] negative(int[][] base) {
        int[][] result = new int[base.length][base[0].length];
        for (int x = 0; x < base.length; ++x) {
            for (int y = 0; y < base[0].length; ++y) {
                result[x][y] = -base[x][y];
            }
        }
        return result;
    }

    public static float[][] negative(float[][] base) {
        float[][] result = new float[base.length][base[0].length];
        for (int x = 0; x < base.length; ++x) {
            for (int y = 0; y < base[0].length; ++y) {
                result[x][y] = -base[x][y];
            }
        }
        return result;
    }

    public static double[][] negative(double[][] base) {
        double[][] result = new double[base.length][base[0].length];
        for (int x = 0; x < base.length; ++x) {
            for (int y = 0; y < base[0].length; ++y) {
                result[x][y] = -base[x][y];
            }
        }
        return result;
    }

    public static boolean[][] initialize(int sizeX, int sizeY, boolean initialValue) {
        boolean[][] result = new boolean[sizeX][sizeY];
        for (int x = 0; x < sizeX; ++x) {
            for (int y = 0; y < sizeY; ++y) {
                result[x][y] = initialValue;
            }
        }
        return result;
    }

    public static int[][] initialize(int sizeX, int sizeY, int initialValue) {
        int[][] result = new int[sizeX][sizeY];
        for (int x = 0; x < sizeX; ++x) {
            for (int y = 0; y < sizeY; ++y) {
                result[x][y] = initialValue;
            }
        }
        return result;
    }

    public static float[][] initialize(int sizeX, int sizeY, float initialValue) {
        float[][] result = new float[sizeX][sizeY];
        for (int x = 0; x < sizeX; ++x) {
            for (int y = 0; y < sizeY; ++y) {
                result[x][y] = initialValue;
            }
        }
        return result;
    }

    public static double[][] initialize(int sizeX, int sizeY, double initialValue) {
        double[][] result = new double[sizeX][sizeY];
        for (int x = 0; x < sizeX; ++x) {
            for (int y = 0; y < sizeY; ++y) {
                result[x][y] = initialValue;
            }
        }
        return result;
    }

    public static String print(boolean[][] base, char on, char off) {
        if (base == null) {
            return null;
        }
        String result = "";
        for (int y = 0; y < base[0].length; ++y) {
            for (int x = 0; x < base.length; ++x) {
                result = base[x][y] ? result + on : result + off;
            }
            result = result + "\n";
        }
        return result;
    }

    public static String print(boolean[][] base) {
        if (base == null) {
            return null;
        }
        String result = "";
        for (int y = 0; y < base[0].length; ++y) {
            for (int x = 0; x < base.length; ++x) {
                result = base[x][y] ? result + "#" : result + " ";
            }
            result = result + "\n";
        }
        return result;
    }

    public static String print(int[][] base) {
        if (base == null) {
            return null;
        }
        String result = "";
        for (int x = 0; x < base.length; ++x) {
            for (int y = 0; y < base[0].length; ++y) {
                result = result + "" + base[x][y] + ", \t";
            }
            result = result + "\n";
        }
        return result;
    }

    public static String print(float[][] base) {
        if (base == null) {
            return null;
        }
        String result = "";
        for (int x = 0; x < base.length; ++x) {
            for (int y = 0; y < base[0].length; ++y) {
                result = result + "" + base[x][y] + ", \t";
            }
            result = result + "\n";
        }
        return result;
    }

    public static String print(double[][] base) {
        if (base == null) {
            return null;
        }
        String result = "";
        for (int x = 0; x < base.length; ++x) {
            for (int y = 0; y < base[0].length; ++y) {
                result = result + "" + base[x][y] + ", \t";
            }
            result = result + "\n";
        }
        return result;
    }
}

