/*
 * Decompiled with CFR 0.152.
 */
package util.math2d;

import util.math2d.Point2D;
import util.statics.LogManager;

public class Vector2D {
    Point2D start;
    Point2D end;
    double distance;

    public Vector2D(Point2D start, Point2D end) {
        this.start = start;
        this.end = end;
        this.distance = Vector2D.euclidianDistance(start, end);
    }

    public Vector2D(double startX, double startY, double endX, double endY) {
        this.start = new Point2D(startX, startY);
        this.end = new Point2D(endX, endY);
        this.distance = Vector2D.euclidianDistance(this.start, this.end);
    }

    public Vector2D(Vector2D copy) {
        this.start = new Point2D(copy.start.x, copy.start.y);
        this.end = new Point2D(copy.end.x, copy.end.y);
        this.distance = copy.distance;
    }

    public Point2D getStartCopy() {
        return new Point2D(this.start.x, this.start.y);
    }

    public Point2D getEndCopy() {
        return new Point2D(this.end.x, this.end.y);
    }

    public void normalize() {
        double diff_x = this.end.x - this.start.x;
        double diff_y = this.end.y - this.start.y;
        if (diff_x == 0.0 && diff_y == 0.0) {
            LogManager.writeError("Error", this, "this vector can't be normalized");
        }
        if (diff_x == 0.0) {
            diff_y = diff_y > 0.0 ? 1.0 : -1.0;
            this.end.y = this.start.y + diff_y;
        } else if (diff_y == 0.0) {
            diff_x = diff_x > 0.0 ? 1.0 : -1.0;
            this.end.x = this.start.x + diff_x;
        } else {
            double dist = (float)Math.sqrt(diff_x * diff_x + diff_y * diff_y);
            this.end.x = this.start.x + (diff_x /= dist);
            this.end.y = this.start.y + (diff_y /= dist);
        }
    }

    public static Vector2D normalize(Vector2D vec) {
        Vector2D result = new Vector2D(vec);
        result.normalize();
        return result;
    }

    public static double dotProduct(Vector2D vec1, Vector2D vec2) {
        return (vec1.end.x - vec1.start.x) * (vec2.end.x - vec2.start.x) + (vec1.end.y - vec1.start.y) * (vec2.end.y - vec2.start.y);
    }

    public static double euclidianDistance(Point2D start, Point2D end) {
        if (start == null || end == null) {
            LogManager.writeError("Error", null, "invalid start or end point");
            return 0.0;
        }
        double diff_x = end.x - start.x;
        double diff_y = end.y - start.y;
        return Math.sqrt(diff_x * diff_x + diff_y * diff_y);
    }

    public static double manhattanDistance(Point2D start, Point2D end) {
        if (start == null || end == null) {
            LogManager.writeError("Error", null, "invalid start or end point");
            return 0.0;
        }
        double diff_x = end.x - start.x;
        double diff_y = end.y - start.y;
        return Math.abs(diff_x) + Math.abs(diff_y);
    }

    public static double gradient(Point2D start, Point2D end) {
        if (start == null || end == null) {
            LogManager.writeError("Error", null, "invalid start or end point");
            return 0.0;
        }
        double diff_x = end.x - start.x;
        double diff_y = end.y - start.y;
        return diff_y / diff_x;
    }

    public static double normal(Point2D start, Point2D end) {
        if (start == null || end == null) {
            LogManager.writeError("Error", null, "invalid start or end point");
            return 0.0;
        }
        double diff_x = end.x - start.x;
        double diff_y = end.y - start.y;
        return -diff_x / diff_y;
    }

    public static Point2D add(Point2D point1, Point2D point2) {
        if (point1 == null || point2 == null) {
            LogManager.writeError("Error", null, "invalid start or end point");
            return null;
        }
        double result_x = point1.x + point2.x;
        double result_y = point1.y + point2.y;
        return new Point2D(result_x, result_y);
    }

    public static Point2D subtract(Point2D point1, Point2D point2) {
        if (point1 == null || point2 == null) {
            LogManager.writeError("Error", null, "invalid start or end point");
            return null;
        }
        double result_x = point1.x - point2.x;
        double result_y = point1.y - point2.y;
        return new Point2D(result_x, result_y);
    }

    public static Point2D interpolate(Point2D point1, Point2D point2, float ratio1vs2) {
        if (point1 == null || point2 == null) {
            LogManager.writeError("Error", null, "invalid start or end point");
            return null;
        }
        double result_x = point1.x * (double)ratio1vs2 + point2.x * (double)(1.0f - ratio1vs2);
        double result_y = point1.y * (double)ratio1vs2 + point2.y * (double)(1.0f - ratio1vs2);
        return new Point2D(result_x, result_y);
    }

    public static boolean isOnSegment(Vector2D vec, Point2D point) {
        return Vector2D.isOnSegment(vec.start, vec.end, point);
    }

    public static boolean isOnSegment(Point2D vecStart, Point2D vecEnd, Point2D point) {
        return Vector2D.isOnLine(vecStart, vecEnd, point) && point.x <= Math.max(vecStart.x, vecEnd.x) && point.x >= Math.min(vecStart.x, vecEnd.x) && point.y <= Math.max(vecStart.y, vecEnd.y) && point.y >= Math.min(vecStart.y, vecEnd.y);
    }

    public static boolean isOnLine(Vector2D vec, Point2D point) {
        return Vector2D.isOnLine(vec.start, vec.end, point);
    }

    public static boolean isOnLine(Point2D vecStart, Point2D vecEnd, Point2D point) {
        double d = Vector2D.det(Vector2D.subtract(point, vecStart), Vector2D.subtract(point, vecEnd));
        return d < 1.0E-6;
    }

    public static Point2D intersect(Vector2D vec1, Vector2D vec2) {
        return Vector2D.intersect(vec1.start, vec1.end, vec2.start, vec2.end);
    }

    public static Point2D intersect(Point2D vec1start, Point2D vec1end, Point2D vec2start, Point2D vec2end) {
        Point2D result = Vector2D.lineIntersect(vec1start, vec1end, vec2start, vec2end);
        if (result != null && Vector2D.isOnSegment(vec1start, vec1end, result)) {
            return result;
        }
        return null;
    }

    public static Point2D lineIntersect(Vector2D vec1, Vector2D vec2) {
        return Vector2D.lineIntersect(vec1.start, vec1.end, vec2.start, vec2.end);
    }

    public static Point2D lineIntersect(Point2D vec1start, Point2D vec1end, Point2D vec2start, Point2D vec2end) {
        Point2D d2;
        double det1 = Vector2D.det(vec1start, vec1end);
        double det2 = Vector2D.det(vec2start, vec2end);
        Point2D d1 = Vector2D.subtract(vec1start, vec1end);
        double det1to2 = Vector2D.det(d1, d2 = Vector2D.subtract(vec2start, vec2end));
        if (det1to2 == 0.0) {
            return null;
        }
        double x = Vector2D.det(det1, d1.x, det2, d2.x) / det1to2;
        double y = Vector2D.det(det1, d1.y, det2, d2.y) / det1to2;
        return new Point2D(x, y);
    }

    public static Point2D segmentIntersect(Vector2D vec1, Vector2D vec2) {
        return Vector2D.segmentIntersect(vec1.start, vec1.end, vec2.start, vec2.end);
    }

    public static Point2D segmentIntersect(Point2D vec1start, Point2D vec1end, Point2D vec2start, Point2D vec2end) {
        Point2D d2;
        double det1 = Vector2D.det(vec1start, vec1end);
        double det2 = Vector2D.det(vec2start, vec2end);
        Point2D d1 = Vector2D.subtract(vec1start, vec1end);
        double det1to2 = Vector2D.det(d1, d2 = Vector2D.subtract(vec2start, vec2end));
        if (det1to2 == 0.0) {
            return null;
        }
        Point2D d1to2 = Vector2D.subtract(vec2start, vec1start);
        double t = (d1to2.x * d2.y - d1to2.y * d2.x) / det1to2;
        if (t < 0.0 || t > 1.0) {
            return null;
        }
        double u = (d1to2.x * d1.y - d1to2.y * d1.y) / det1to2;
        if (u < 0.0 || u > 1.0) {
            return null;
        }
        double x = Vector2D.det(det1, d1.x, det2, d2.x) / det1to2;
        double y = Vector2D.det(det1, d1.y, det2, d2.y) / det1to2;
        return new Point2D(x, y);
    }

    protected static double det(double a, double b, double c, double d) {
        return a * d - b * c;
    }

    protected static double det(Point2D p1, Point2D p2) {
        return p1.x * p2.y - p1.y * p2.x;
    }

    protected static double det(Vector2D vec) {
        return vec.start.x * vec.end.y - vec.start.y * vec.end.x;
    }

    public static void main(String[] args) {
        Vector2D v1 = new Vector2D(3.0, 1.0, 0.0, 0.0);
        Vector2D v2 = new Vector2D(0.5, 0.0, 1.0, 3.0);
        Point2D inter = Vector2D.intersect(v1, v2);
        if (inter == null) {
            System.out.println("no intersection");
        } else {
            System.out.println(inter.x + "," + inter.y);
        }
    }
}

