/*
 * Decompiled with CFR 0.152.
 */
package util.math3d;

public class Matrix3D {
    public static boolean[][][] switchXZ(boolean[][][] base) {
        if (base == null || base.length == 0) {
            return null;
        }
        boolean[][][] result = new boolean[base[0][0].length][base.length][base[0].length];
        for (int x = 0; x < base.length; ++x) {
            for (int y = 0; y < base[0].length; ++y) {
                for (int z = 0; z < base[0][0].length; ++z) {
                    result[z][x][y] = base[x][y][z];
                }
            }
        }
        return result;
    }

    public static boolean[][][] switchXY(boolean[][][] base) {
        if (base == null || base.length == 0) {
            return null;
        }
        boolean[][][] result = new boolean[base[0].length][base.length][base[0][0].length];
        for (int x = 0; x < base.length; ++x) {
            for (int y = 0; y < base[0].length; ++y) {
                for (int z = 0; z < base[0][0].length; ++z) {
                    result[y][x][z] = base[x][y][z];
                }
            }
        }
        return result;
    }

    public static boolean[][][] switchYZ(boolean[][][] base) {
        if (base == null || base.length == 0) {
            return null;
        }
        boolean[][][] result = new boolean[base.length][base[0][0].length][base[0].length];
        for (int x = 0; x < base.length; ++x) {
            for (int y = 0; y < base[0].length; ++y) {
                for (int z = 0; z < base[0][0].length; ++z) {
                    result[x][z][y] = base[x][y][z];
                }
            }
        }
        return result;
    }

    public static boolean[][][] rotateLeftMatrix(boolean[][][] base) {
        if (base == null || base.length == 0) {
            return null;
        }
        boolean[][][] result = new boolean[base[0].length][base.length][base[0][0].length];
        for (int x = 0; x < base.length; ++x) {
            for (int y = 0; y < base[0].length; ++y) {
                for (int z = 0; z < base[0][0].length; ++z) {
                    result[y][x][z] = base[x][y][z];
                }
            }
        }
        return result;
    }

    public static boolean[][][] rotateBackMatrix(boolean[][][] base) {
        if (base == null || base.length == 0) {
            return null;
        }
        boolean[][][] result = new boolean[base.length][base[0].length][base[0][0].length];
        for (int x = 0; x < base.length; ++x) {
            for (int y = 0; y < base[0].length; ++y) {
                for (int z = 0; z < base[0][0].length; ++z) {
                    result[x][y][z] = base[x][base[0].length - 1 - y][z];
                }
            }
        }
        return result;
    }

    public static boolean[][][] rotateRightMatrix(boolean[][][] base) {
        if (base == null || base.length == 0) {
            return null;
        }
        boolean[][][] result = new boolean[base[0].length][base.length][base[0][0].length];
        for (int x = 0; x < base.length; ++x) {
            for (int y = 0; y < base[0].length; ++y) {
                for (int z = 0; z < base[0][0].length; ++z) {
                    result[y][x][z] = base[x][base[0].length - 1 - y][z];
                }
            }
        }
        return result;
    }

    public static boolean[][][] rotateBottomMatrix(boolean[][][] base) {
        if (base == null || base.length == 0) {
            return null;
        }
        boolean[][][] result = new boolean[base.length][base[0].length][base[0][0].length];
        for (int x = 0; x < base.length; ++x) {
            for (int y = 0; y < base[0].length; ++y) {
                for (int z = 0; z < base[0][0].length; ++z) {
                    result[x][y][z] = base[x][y][base[0][0].length - 1 - z];
                }
            }
        }
        return result;
    }

    public static boolean[][] getSliceZ(boolean[][][] base, int z) {
        boolean[][] result = new boolean[base.length][base[0].length];
        if (z < 0 || z >= base[0][0].length) {
            return result;
        }
        for (int x = 0; x < base.length; ++x) {
            for (int y = 0; y < base[0].length; ++y) {
                result[x][y] = base[x][y][z];
            }
        }
        return result;
    }

    public static boolean[][] getSliceY(boolean[][][] base, int y) {
        boolean[][] result = new boolean[base.length][base[0][0].length];
        if (y < 0 || y >= base[0].length) {
            return result;
        }
        for (int x = 0; x < base.length; ++x) {
            for (int z = 0; z < base[0][0].length; ++z) {
                result[x][z] = base[x][y][z];
            }
        }
        return result;
    }

    public static boolean[][] getSliceX(boolean[][][] base, int x) {
        boolean[][] result = new boolean[base[0].length][base[0][0].length];
        if (x < 0 || x >= base.length) {
            return result;
        }
        for (int y = 0; y < base[0].length; ++y) {
            for (int z = 0; z < base[0][0].length; ++z) {
                result[y][z] = base[x][y][z];
            }
        }
        return result;
    }
}

