/*
 * Decompiled with CFR 0.152.
 */
package util.statics;

import util.collections.ParameterCollection;
import util.statics.LogManager;
import util.statics.RandomNumberManager;

public class ActivationManager {
    static final String[] activationFnNames = new String[]{"CURVE_ASCENDING", "CURVE_PERIODIC", "CURVE_SYMMETRIC", "LINE_ASCENDING", "LINE_PERIODIC", "LINE_SYMMETRIC", "PULSE_ASCENDING", "PULSE_PERIODIC", "PULSE_SYMMETRIC"};
    static final String[] randomTypeNames = new String[]{"ALL", "CURVE", "LINE", "PULSE", "CURVE+LINE", "ASCENDING", "PERIODIC", "SYMMETRIC"};

    public static int getNumber() {
        return activationFnNames.length;
    }

    public static float getSigmoid(float input) {
        return ActivationManager.getSigmoid(input);
    }

    public static double getSigmoid(double input) {
        return 1.0 / (1.0 + Math.exp(-input));
    }

    public static float getOutput(float input, int funcIndex) {
        return (float)ActivationManager.getOutput((double)input, funcIndex);
    }

    public static double getOutput(double input, int funcIndex) {
        if (funcIndex < 0 || funcIndex >= activationFnNames.length) {
            LogManager.writeError("Error", null, "activation " + funcIndex + " not found.");
        }
        if (funcIndex == 0) {
            return 1.0 / (1.0 + Math.exp(-input));
        }
        if (funcIndex == 1) {
            return 0.5 + 0.5 * Math.sin(input * Math.PI / 2.0);
        }
        if (funcIndex == 2) {
            return Math.exp(-input * input / 6.0);
        }
        if (funcIndex == 3) {
            return 0.5 + Math.min(Math.max(input, -3.0), 3.0) / 6.0;
        }
        if (funcIndex == 4) {
            if ((int)Math.floor(input + 1.0) % 4 < 2) {
                return (input + 1.0) / 2.0 - Math.floor((input + 1.0) / 2.0);
            }
            return 1.0 - (input + 1.0) / 2.0 - Math.floor((input + 1.0) / 2.0);
        }
        if (funcIndex == 5) {
            if (input < 0.0) {
                return Math.max(0.0, 1.0 + input / 4.0);
            }
            return Math.max(0.0, 1.0 - input / 4.0);
        }
        if (funcIndex == 6) {
            if (input <= 0.0) {
                return 0.0;
            }
            return 1.0;
        }
        if (funcIndex == 7) {
            if ((int)Math.floor(input / 2.0) % 2 == 0) {
                return 1.0;
            }
            return 0.0;
        }
        if (funcIndex == 8) {
            input = Math.abs(input) < 2.0 ? 1.0 : 0.0;
        }
        return 0.0;
    }

    public static float getOutput(float input, int funcIndex, float minValue, float maxValue) {
        float result = ActivationManager.getOutput(input, funcIndex);
        float valueRange = maxValue - minValue;
        if (valueRange <= 0.0f) {
            LogManager.writeError("Error", null, "maxValue not larger than minValue");
            return 0.0f;
        }
        result = minValue + result * valueRange;
        return result;
    }

    public static String getName(int funcIndex) {
        if (funcIndex < 0 || funcIndex >= activationFnNames.length) {
            LogManager.writeError("Error", null, "activation " + funcIndex + " not found.");
            return "ERROR";
        }
        return activationFnNames[funcIndex];
    }

    public static int getIndex(String name) {
        for (int i = 0; i < activationFnNames.length; ++i) {
            if (!name.equalsIgnoreCase(activationFnNames[i])) continue;
            return i;
        }
        return -1;
    }

    public static String getRandomTypeName(int index) {
        if (index < 0 || index >= activationFnNames.length) {
            LogManager.writeError("Error", null, "activation " + index + " not found.");
            return "ERROR";
        }
        return randomTypeNames[index];
    }

    public static int getRandomTypeIndex(String name) {
        for (int i = 0; i < randomTypeNames.length; ++i) {
            if (!name.equalsIgnoreCase(randomTypeNames[i])) continue;
            return i;
        }
        return -1;
    }

    public static int resolveActivationFunction(ParameterCollection params) {
        int specificActivationFn;
        int minRandomIndex = -4;
        if (params.contains("standardNeuralNetwork") && params.getBoolean("standardNeuralNetwork")) {
            return ActivationManager.getIndex("CURVE_ASCENDING");
        }
        if (params.contains("specificActivationFn") && (specificActivationFn = ActivationManager.getIndex(params.getString("specificActivationFn"))) >= 0 && specificActivationFn < activationFnNames.length) {
            return specificActivationFn;
        }
        if (params.contains("randomActivationType")) {
            String randomType = params.getString("randomActivationType");
            if (randomType.equalsIgnoreCase("ALL")) {
                return RandomNumberManager.getRandomInt(0, activationFnNames.length);
            }
            if (randomType.equalsIgnoreCase("CURVE")) {
                return RandomNumberManager.getRandomInt(0, 3);
            }
            if (randomType.equalsIgnoreCase("LINE")) {
                return RandomNumberManager.getRandomInt(3, 6);
            }
            if (randomType.equalsIgnoreCase("PULSE")) {
                return RandomNumberManager.getRandomInt(7, 9);
            }
            if (randomType.equalsIgnoreCase("CURVE+LINE")) {
                return RandomNumberManager.getRandomInt(0, 6);
            }
            if (randomType.equalsIgnoreCase("ASCENDING")) {
                return 3 * RandomNumberManager.getRandomInt(0, 3);
            }
            if (randomType.equalsIgnoreCase("PERIODIC")) {
                return 1 + 3 * RandomNumberManager.getRandomInt(0, 3);
            }
            if (randomType.equalsIgnoreCase("SYMMETRIC")) {
                return 2 + 3 * RandomNumberManager.getRandomInt(0, 3);
            }
        }
        return RandomNumberManager.getRandomInt(0, activationFnNames.length);
    }
}

