/*
 * Decompiled with CFR 0.152.
 */
package util.statics;

import java.util.HashMap;
import util.logs.HTMLWriter;
import util.logs.Writer;

public class LogManager {
    static HashMap<String, Writer> counters = new HashMap();

    public static void reset() {
        counters.clear();
    }

    public static boolean addLogfile(String id, String filename) {
        return LogManager.addLogfile(id, filename, false);
    }

    public static boolean addLogfile(String id, String filename, boolean append) {
        if (counters.containsKey(id)) {
            return false;
        }
        if (filename.endsWith(".html")) {
            counters.put(id, new HTMLWriter(filename, append));
        } else {
            counters.put(id, new Writer(filename, append));
        }
        return true;
    }

    public static void write(String id, String text) {
        if (!counters.containsKey(id)) {
            return;
        }
        Writer w = counters.get(id);
        if (w instanceof HTMLWriter) {
            HTMLWriter h = (HTMLWriter)w;
            h.write(text);
        } else {
            w.write(text);
        }
    }

    public static void writeError(String id, Object callingObject, String text) {
        String className = callingObject != null ? callingObject.getClass().getName() : "";
        System.out.println(className + ": " + text);
        if (!counters.containsKey(id)) {
            return;
        }
        Writer w = counters.get(id);
        if (w instanceof HTMLWriter) {
            HTMLWriter h = (HTMLWriter)w;
            h.writeError(callingObject, text);
        } else {
            w.writeError(callingObject, text);
        }
    }
}

