/*
 * Decompiled with CFR 0.152.
 */
package util.statics;

import java.util.Collections;
import java.util.Vector;

public class StatisticUtils {
    public static double standardDeviation(double[] data) {
        double mean = StatisticUtils.average(data);
        double sum = 0.0;
        int n = 0;
        for (int i = 0; i < data.length; ++i) {
            if (Double.isNaN(data[i]) || Double.isInfinite(data[i])) continue;
            double v = data[i] - mean;
            sum += v * v;
            ++n;
        }
        if (n < 2) {
            return Double.NaN;
        }
        return Math.sqrt(sum / (double)(n - 1));
    }

    public static float standardDeviation(float[] data) {
        float mean = StatisticUtils.average(data);
        float sum = 0.0f;
        int n = 0;
        for (int i = 0; i < data.length; ++i) {
            if (Float.isNaN(data[i]) || Float.isInfinite(data[i])) continue;
            float v = data[i] - mean;
            sum += v * v;
            ++n;
        }
        if (n < 2) {
            return Float.NaN;
        }
        return (float)Math.sqrt((double)sum / (double)(n - 1));
    }

    public static double average(double[] data) {
        double result = 0.0;
        int n = 0;
        for (int i = 0; i < data.length; ++i) {
            if (Double.isNaN(data[i]) || Double.isInfinite(data[i])) continue;
            result += data[i];
            ++n;
        }
        if (n == 0) {
            return Double.NaN;
        }
        return result / (double)n;
    }

    public static float average(float[] data) {
        float result = 0.0f;
        int n = 0;
        for (int i = 0; i < data.length; ++i) {
            if (Float.isNaN(data[i]) || Float.isInfinite(data[i])) continue;
            result += data[i];
            ++n;
        }
        if (n == 0) {
            return Float.NaN;
        }
        return result / (float)n;
    }

    public static double median(double[] data) {
        Vector<Double> result = new Vector<Double>();
        int n = 0;
        for (int i = 0; i < data.length; ++i) {
            if (Double.isNaN(data[i]) || Double.isInfinite(data[i])) continue;
            result.add(data[i]);
            ++n;
        }
        if (n == 0) {
            return Double.NaN;
        }
        Collections.sort(result);
        return (Double)result.get((result.size() - 1) / 2);
    }

    public static float median(float[] data) {
        Vector<Float> result = new Vector<Float>();
        int n = 0;
        for (int i = 0; i < data.length; ++i) {
            if (Double.isNaN(data[i]) || Double.isInfinite(data[i])) continue;
            result.add(Float.valueOf(data[i]));
            ++n;
        }
        if (n == 0) {
            return Float.NaN;
        }
        Collections.sort(result);
        return ((Float)result.get((result.size() - 1) / 2)).floatValue();
    }

    public static double maximum(double[] data) {
        int n = 0;
        double result = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < data.length; ++i) {
            if (Double.isNaN(data[i]) || Double.isInfinite(data[i])) continue;
            if (data[i] > result) {
                result = data[i];
            }
            ++n;
        }
        if (n == 0) {
            return Double.NaN;
        }
        return result;
    }

    public static float maximum(float[] data) {
        int n = 0;
        float result = Float.NEGATIVE_INFINITY;
        for (int i = 0; i < data.length; ++i) {
            if (Float.isNaN(data[i]) || Float.isInfinite(data[i])) continue;
            if (data[i] > result) {
                result = data[i];
            }
            ++n;
        }
        if (n == 0) {
            return Float.NaN;
        }
        return result;
    }

    public static double minimum(double[] data) {
        int n = 0;
        double result = Double.POSITIVE_INFINITY;
        for (int i = 0; i < data.length; ++i) {
            if (Double.isNaN(data[i]) || Double.isInfinite(data[i])) continue;
            if (data[i] < result) {
                result = data[i];
            }
            ++n;
        }
        if (n == 0) {
            return Double.NaN;
        }
        return result;
    }

    public static float minimum(float[] data) {
        int n = 0;
        float result = Float.POSITIVE_INFINITY;
        for (int i = 0; i < data.length; ++i) {
            if (Float.isNaN(data[i]) || Float.isInfinite(data[i])) continue;
            if (data[i] < result) {
                result = data[i];
            }
            ++n;
        }
        if (n == 0) {
            return Float.NaN;
        }
        return result;
    }

    public static double[] normalize(double[] data) {
        double max = StatisticUtils.maximum(data);
        double min = StatisticUtils.minimum(data);
        double range = max - min;
        double[] result = new double[data.length];
        for (int i = 0; i < data.length; ++i) {
            if (Double.isNaN(data[i]) || Double.isInfinite(data[i])) continue;
            result[i] = range > 0.0 ? (data[i] - min) / range : 0.0;
        }
        return result;
    }

    public static float[] normalize(float[] data) {
        float max = StatisticUtils.maximum(data);
        float min = StatisticUtils.minimum(data);
        float range = max - min;
        float[] result = new float[data.length];
        for (int i = 0; i < data.length; ++i) {
            result[i] = range > 0.0f ? (data[i] - min) / range : 0.0f;
        }
        return result;
    }
}

