/*
 * Decompiled with CFR 0.152.
 */
package util.statics;

import java.io.File;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import util.statics.LogManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLUtils {
    public static Document loadDocument(String filename) {
        File file = new File(filename);
        if (!file.exists()) {
            LogManager.writeError("Error", null, "file " + filename + " does not exist.");
            return null;
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = null;
        Document doc = null;
        try {
            db = dbf.newDocumentBuilder();
            doc = db.parse(file);
        }
        catch (Exception e) {
            LogManager.writeError("Error", null, "error parsing file " + filename + ".");
            return null;
        }
        doc.getDocumentElement().normalize();
        return doc;
    }

    public static Document loadDocument(String filename, String sanityRoot) {
        Document doc = XMLUtils.loadDocument(filename);
        if (doc != null && !doc.getDocumentElement().getNodeName().endsWith(sanityRoot)) {
            LogManager.writeError("Error", null, "invalid XML root");
            return null;
        }
        return doc;
    }

    public static Element getDirectChild(Element parent, String name) {
        for (Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof Element) || !name.equals(child.getNodeName())) continue;
            return (Element)child;
        }
        return null;
    }

    public static Vector<Element> getDirectChildren(Element parent, String name) {
        Vector<Element> result = new Vector<Element>();
        for (Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof Element) || !name.equals(child.getNodeName())) continue;
            result.add((Element)child);
        }
        return result;
    }
}

