/*
 * Decompiled with CFR 0.152.
 */
package applet;

import applet.SQLWriter;
import java.util.HashMap;
import java.util.Vector;
import processing.core.PImage;
import renderer.Render2D;
import strategymap.DetailConverter;
import strategymap.StrategySketch;
import strategymap.genetic.StrategySketchGene;
import strategymap.genetic.StrategySketchGeneConverter;
import strategymap.visualization.MapVisualizer;
import ui.BaseApplet;
import ui.components.UIButton;
import ui.components.UIImage;
import ui.components.UILabel;
import ui.components.UIToggleButtonGroup;
import ui.screens.Screen;
import util.collections.ParameterCollection;

public class Screen_DetailedView
extends Screen {
    final int imgSizeX = 512;
    final int imgSizeY = 512;
    public final int cellularSizeX = 10;
    public final int cellularSizeY = 10;
    int gridSizeX;
    int gridSizeY;
    StrategySketch sketch;
    HashMap<String, DetailConverter> converters;
    Vector<PImage> detailedViews;
    SQLWriter writer;

    public Screen_DetailedView(BaseApplet p, StrategySketch sketch) {
        super(p);
        this.sketch = sketch;
        this.writer = new SQLWriter("http://itu.dk/~anli/datauploads/sentientsketchbook");
        this.converters = new HashMap();
        this.converters.put("classic", new DetailConverter(sketch, 10, 10));
        this.converters.put("waterworks", new DetailConverter(this.createWaterWorksSketch(), 10, 10));
        this.remakeDetailedViews();
        this.initialize();
    }

    protected void initialize() {
        this.gridSizeX = 512 / this.sketch.getMapSizeX();
        this.gridSizeY = 512 / this.sketch.getMapSizeY();
        UIImage img = new UIImage(this.p, this.detailedViews.get(0), 0, 0);
        img.setPosition(img.getWidth() / 2 + 10, img.getHeight() / 2 + 90);
        this.addComponent("Canvas", img);
        int offset = 40;
        this.addComponent("Title", new UILabel(this.p, "Strategy Game Map Detailed View", this.p.width / 2, offset + 20, "Huge"));
        this.addComponent("ViewMode_Label", new UILabel(this.p, "Viewing Modes", img.getPositionX() + img.getWidth() / 2 + 57, offset + 205, "Large"));
        UIToggleButtonGroup t = new UIToggleButtonGroup(this.p, img.getPositionX() + img.getWidth() / 2 + 50, offset + 225, 90, 20);
        t.setAllowUnselected(false);
        t.addButton("Simple");
        t.addButtonNextLine("Heightmap");
        t.addButtonNextLine("Waterworks");
        t.addButtonNextLine("Dungeon");
        t.setSelectedIndex(0);
        this.addComponent("ViewingMode_Group", t);
        this.addComponent("Reset_Button", new UIButton(this.p, "Regenerate", img.getPositionX() + img.getWidth() / 2 + 57, offset + 155, "Large"));
        this.addComponent("Back_Button", new UIButton(this.p, "Back", img.getPositionX() - img.getWidth() / 2 + 50, img.getPositionY() + img.getHeight() / 2 + 40, "Large"));
        this.addComponent("ExportMap_Button", new UIButton(this.p, "Export Map", img.getPositionX() + img.getWidth() / 2 + 200, 400, "Large"));
        this.addComponent("ExportGene_Button", new UIButton(this.p, "Export Gene", img.getPositionX() + img.getWidth() / 2 + 300, 400, "Large"));
    }

    @Override
    public void mouseClicked() {
        super.mouseClicked();
        UIButton b = null;
        b = (UIButton)this.getComponent("Back_Button");
        if (b != null && b.getState() == UIButton.State.PRESSED) {
            this.p.swapPreviousScreen();
        }
        if ((b = (UIButton)this.getComponent("Reset_Button")) != null && b.getState() == UIButton.State.PRESSED) {
            this.remakeDetailedViews();
            this.showMap();
        }
        if ((b = (UIButton)this.getComponent("ExportMap_Button")) != null && b.getState() == UIButton.State.PRESSED) {
            UIToggleButtonGroup t = (UIToggleButtonGroup)this.getComponent("ViewingMode_Group");
            StrategySketchGene baseGene = StrategySketchGeneConverter.getGene(this.sketch, new ParameterCollection());
            this.writer.logAction("Export as " + t.getSelectedCaption());
            this.writer.logExportedGene(baseGene.toXML());
        }
        if ((b = (UIButton)this.getComponent("ExportGene_Button")) != null && b.getState() == UIButton.State.PRESSED) {
            StrategySketchGene baseGene = StrategySketchGeneConverter.getGene(this.sketch, new ParameterCollection());
            this.writer.logAction("Export gene");
            this.writer.logExportedGene(baseGene.toXML());
        }
        this.showMap();
    }

    @Override
    public void update() {
        this.remakeDetailedViews();
        this.showMap();
    }

    public void remakeDetailedViews() {
        this.detailedViews = new Vector();
        this.converters.get("classic").reset(this.sketch);
        this.converters.get("classic").generateMap();
        Render2D renderer = MapVisualizer.renderThumbnail(this.p, this.converters.get("classic").getMap(), 512, 512);
        this.detailedViews.add(renderer.getImage());
        renderer = MapVisualizer.renderHeightmap(this.p, this.converters.get("classic"), 512, 512);
        this.detailedViews.add(renderer.getImage());
        this.converters.get("waterworks").reset(this.createWaterWorksSketch());
        this.converters.get("waterworks").generateMap();
        renderer = MapVisualizer.renderWaterworks(this.p, this.sketch, this.converters.get("waterworks"), 512, 512);
        this.detailedViews.add(renderer.getImage());
        renderer = MapVisualizer.renderDungeon(this.p, this.sketch, 512, 512);
        this.detailedViews.add(renderer.getImage());
    }

    protected void showMap() {
        UIToggleButtonGroup t = (UIToggleButtonGroup)this.getComponent("ViewingMode_Group");
        PImage mapImage = this.detailedViews.get(t.getSelectedIndex());
        UIImage c = (UIImage)this.getComponent("Canvas");
        c.setImage(mapImage, true);
    }

    protected StrategySketch createWaterWorksSketch() {
        int i;
        StrategySketch wwSketch = new StrategySketch(this.sketch.getMapSizeX(), this.sketch.getMapSizeY());
        for (i = 0; i < this.sketch.getBaseLength(); ++i) {
            wwSketch.addBase((int)this.sketch.getBase((int)i).x, (int)this.sketch.getBase((int)i).y);
        }
        for (i = 0; i < this.sketch.getResourceLength(); ++i) {
            wwSketch.addResource((int)this.sketch.getResource((int)i).x, (int)this.sketch.getResource((int)i).y);
        }
        boolean[][] impassable = this.sketch.getImpassableArray();
        boolean[][] chokePoints = this.sketch.getPaths().getChokePoints();
        boolean[][] deadEnds = this.sketch.getPaths().getDeadEnds();
        for (int x = 0; x < this.sketch.getMapSizeX(); ++x) {
            for (int y = 0; y < this.sketch.getMapSizeY(); ++y) {
                if (impassable[x][y]) {
                    wwSketch.setImpassable(x, y);
                }
                if (!chokePoints[x][y] || this.sketch.isBase(x, y) || this.sketch.isResource(x, y) || deadEnds[x][y]) continue;
                wwSketch.setImpassable(x, y);
            }
        }
        return wwSketch;
    }
}

