/*
 * Decompiled with CFR 0.152.
 */
package common;

import ai.pathfinder.Node;
import ai.pathfinder.Pathfinder;
import java.util.ArrayList;
import java.util.Vector;
import util.math2d.Point2D;
import util.math2d.Vector2D;

public class PathLibrary {
    public static Pathfinder init(boolean[][] map) {
        Pathfinder result = new Pathfinder();
        boolean spacing = true;
        result.setCuboidNodes(map.length, map[0].length, (float)spacing);
        for (Object temp : result.nodes) {
            Node n = (Node)temp;
            n.walkable = !map[(int)n.x][(int)n.y];
        }
        result.radialDisconnectUnwalkables();
        return result;
    }

    public static Node findNode(int x, int y, Pathfinder pf) {
        for (Object temp : pf.nodes) {
            Node n = (Node)temp;
            if (n.x != (float)x || n.y != (float)y) continue;
            return n;
        }
        return null;
    }

    public static ArrayList getPath(Point2D p1, Point2D p2, boolean[][] map) {
        return PathLibrary.getPath((int)p1.x, (int)p1.y, (int)p2.x, (int)p2.y, map);
    }

    public static ArrayList getPath(int x1, int y1, int x2, int y2, boolean[][] map) {
        Pathfinder pf = PathLibrary.init(map);
        Node start = PathLibrary.findNode(x1, y1, pf);
        Node end = PathLibrary.findNode(x2, y2, pf);
        ArrayList result = pf.aStar(PathLibrary.findNode(x1, y1, pf), PathLibrary.findNode(x2, y2, pf));
        if (PathLibrary.hasStart(result, x2, y2) && PathLibrary.hasEnd(result, x1, y1)) {
            return result;
        }
        return null;
    }

    public static boolean hasStart(ArrayList path, int x, int y) {
        if (path != null) {
            Node temp = (Node)path.get(0);
            if (temp.x == (float)x && temp.y == (float)y) {
                return true;
            }
        }
        return false;
    }

    public static boolean hasNode(ArrayList path, int x, int y) {
        if (path != null) {
            for (int i = 0; i < path.size(); ++i) {
                Node temp = (Node)path.get(i);
                if (temp.x != (float)x || temp.y != (float)y) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasEnd(ArrayList path, int x, int y) {
        if (path != null) {
            Node temp = (Node)path.get(path.size() - 1);
            if (temp.x == (float)x && temp.y == (float)y) {
                return true;
            }
        }
        return false;
    }

    public static Vector<Point2D> transformPath(ArrayList path) {
        Vector<Point2D> result = new Vector<Point2D>();
        for (int i = 0; i < path.size(); ++i) {
            Node n = (Node)path.get(i);
            result.add(new Point2D(n.x, n.y));
        }
        return result;
    }

    public static ArrayList transformPath(Vector<Point2D> path) {
        ArrayList<Node> result = new ArrayList<Node>();
        for (int i = 0; i < path.size(); ++i) {
            Point2D n = path.get(i);
            result.add(new Node((float)n.x, (float)n.y));
        }
        return result;
    }

    public static Point2D transformNode(Node n) {
        return new Point2D(n.x, n.y);
    }

    public static Node transformNode(Point2D n) {
        return new Node((float)n.x, (float)n.y);
    }

    public static float calculateDistance(ArrayList path) {
        if (path.size() < 2) {
            return 0.0f;
        }
        float result = 0.0f;
        for (int i = 1; i < path.size(); ++i) {
            Node curr = (Node)path.get(i);
            Node prev = (Node)path.get(i - 1);
            result = (float)((double)result + Vector2D.euclidianDistance(new Point2D(curr.x, curr.y), new Point2D(prev.x, prev.y)));
        }
        return result;
    }

    public static boolean[][] transformPath(ArrayList base, int sizeX, int sizeY) {
        return PathLibrary.transformPath(PathLibrary.transformPath(base), sizeX, sizeY);
    }

    public static boolean[][] transformPath(Vector<Point2D> base, int sizeX, int sizeY) {
        if (base == null || base.size() == 0) {
            return null;
        }
        boolean[][] result = new boolean[sizeX][sizeY];
        for (int x = 0; x < result.length; ++x) {
            for (int y = 0; y < result[0].length; ++y) {
                result[x][y] = false;
            }
        }
        for (int i = 0; i < base.size(); ++i) {
            int x = (int)base.get((int)i).x;
            int y = (int)base.get((int)i).y;
            if (i < base.size() - 1 && (double)x != base.get((int)(i + 1)).x && (double)y != base.get((int)(i + 1)).y) {
                result[(int)base.get((int)(i + 1)).x][y] = true;
                result[x][(int)base.get((int)(i + 1)).y] = true;
            }
            result[x][y] = true;
        }
        return result;
    }

    public static String print(Vector<Point2D> path) {
        String result = "";
        for (int i = 0; i < path.size(); ++i) {
            result = result + "(" + path.get((int)i).x + "," + path.get((int)i).y + ")";
            if (i >= path.size() - 1) continue;
            result = result + "->";
        }
        return result;
    }

    public static String print(ArrayList path) {
        String result = "";
        for (int i = 0; i < path.size(); ++i) {
            Node n = (Node)path.get(i);
            result = result + "(" + n.x + "," + n.y + ")";
            if (i >= path.size() - 1) continue;
            result = result + "->";
        }
        return result;
    }
}

