/*
 * Decompiled with CFR 0.152.
 */
package dungeon;

import dungeon.Dungeon;

public class DetailConverter {
    Dungeon detailedView;
    Dungeon sketch;
    int gridSizeX;
    int gridSizeY;
    final float connectionWidth = 0.2f;
    final float baseWidth = 0.2f;
    final float resourceRatio = 0.3f;

    public DetailConverter(Dungeon sketch, int gridSizeX, int gridSizeY) {
        this.gridSizeX = gridSizeX;
        this.gridSizeY = gridSizeY;
        this.reset(sketch);
    }

    public void reset(Dungeon sketch) {
        if (this.sketch != sketch) {
            this.setSketch(sketch);
        }
        this.detailedView = new Dungeon(sketch.getMapSizeX() * this.gridSizeX, sketch.getMapSizeY() * this.gridSizeY);
    }

    public Dungeon getMap() {
        return this.detailedView;
    }

    public void setSketch(Dungeon sketch) {
        this.sketch = sketch;
    }

    public int getGridSizeX() {
        return this.gridSizeX;
    }

    public int getGridSizeY() {
        return this.gridSizeY;
    }

    public void makeFixedWidthRooms() {
        for (int x = 0; x < this.sketch.getMapSizeX(); ++x) {
            for (int y = 0; y < this.sketch.getMapSizeY(); ++y) {
                for (int i = 0; i < this.gridSizeX; ++i) {
                    for (int j = 0; j < this.gridSizeY; ++j) {
                        if (!this.sketch.isPassable(x, y)) {
                            this.detailedView.setImpassable(x * this.gridSizeX + i, y * this.gridSizeY + j);
                            continue;
                        }
                        if (i == 0 || i == this.gridSizeX - 1 || j == 0 || j == this.gridSizeY - 1) {
                            this.detailedView.setImpassable(x * this.gridSizeX + i, y * this.gridSizeY + j);
                            if (i == this.gridSizeX / 2 && j == 0 && this.sketch.isPassable(x, y - 1)) {
                                this.detailedView.setPassable(x * this.gridSizeX + i, y * this.gridSizeY + j);
                            }
                            if (i == this.gridSizeX / 2 && j == this.gridSizeY - 1 && this.sketch.isPassable(x, y + 1)) {
                                this.detailedView.setPassable(x * this.gridSizeX + i, y * this.gridSizeY + j);
                            }
                            if (i == 0 && j == this.gridSizeY / 2 && this.sketch.isPassable(x - 1, y)) {
                                this.detailedView.setPassable(x * this.gridSizeX + i, y * this.gridSizeY + j);
                            }
                            if (i != this.gridSizeX - 1 || j != this.gridSizeY / 2 || !this.sketch.isPassable(x + 1, y)) continue;
                            this.detailedView.setPassable(x * this.gridSizeX + i, y * this.gridSizeY + j);
                            continue;
                        }
                        if (this.sketch.isMonster(x, y) && i == this.gridSizeX / 2 && j == this.gridSizeY / 2) {
                            this.detailedView.addMonster(x * this.gridSizeX + i, y * this.gridSizeY + j);
                            continue;
                        }
                        if (this.sketch.isReward(x, y) && i == this.gridSizeX / 2 && j == this.gridSizeY / 2) {
                            this.detailedView.addReward(x * this.gridSizeX + i, y * this.gridSizeY + j);
                            continue;
                        }
                        if (this.sketch.isExit(x, y) && i == this.gridSizeX / 2 && j == this.gridSizeY / 2) {
                            this.detailedView.addExit(x * this.gridSizeX + i, y * this.gridSizeY + j);
                            continue;
                        }
                        this.detailedView.setPassable(x * this.gridSizeX + i, y * this.gridSizeY + j);
                    }
                }
            }
        }
    }
}

