/*
 * Decompiled with CFR 0.152.
 */
package dungeon;

import dungeon.DungeonMetrics;
import dungeon.DungeonPaths;
import java.util.Vector;
import util.math2d.Point2D;
import util.statics.LogManager;
import util.statics.RandomNumberManager;

public class Dungeon {
    int mapSizeX;
    int mapSizeY;
    boolean[][] impassable;
    Vector<Point2D> exits;
    Vector<Point2D> monsters;
    Vector<Point2D> rewards;
    DungeonPaths paths;
    DungeonMetrics metrics;

    public Dungeon(int sizeX, int sizeY) {
        this.mapSizeX = sizeX;
        this.mapSizeY = sizeY;
        this.clearImpassable();
        this.exits = new Vector();
        this.monsters = new Vector();
        this.rewards = new Vector();
        this.paths = new DungeonPaths(this);
        this.metrics = new DungeonMetrics(this);
    }

    public Dungeon(Dungeon copy) {
        int i;
        this.mapSizeX = copy.mapSizeX;
        this.mapSizeY = copy.mapSizeX;
        this.clearImpassable();
        for (int x = 0; x < this.impassable.length; ++x) {
            for (int y = 0; y < this.impassable[x].length; ++y) {
                this.impassable[x][y] = copy.impassable[x][y];
            }
        }
        this.monsters = new Vector();
        for (i = 0; i < copy.monsters.size(); ++i) {
            this.monsters.add(new Point2D(copy.monsters.get(i)));
        }
        this.rewards = new Vector();
        for (i = 0; i < copy.rewards.size(); ++i) {
            this.rewards.add(new Point2D(copy.rewards.get(i)));
        }
        this.exits = new Vector();
        for (i = 0; i < copy.exits.size(); ++i) {
            this.exits.add(new Point2D(copy.exits.get(i)));
        }
        this.paths = new DungeonPaths(this);
        this.metrics = new DungeonMetrics(this);
        this.finalizeSketch();
    }

    public int getMapSizeX() {
        return this.mapSizeX;
    }

    public int getMapSizeY() {
        return this.mapSizeY;
    }

    public DungeonPaths getPaths() {
        return this.paths;
    }

    public DungeonMetrics getMetrics() {
        return this.metrics;
    }

    public int getTileDifference(Dungeon other) {
        if (other.mapSizeX != this.mapSizeX || other.mapSizeY != this.mapSizeY) {
            LogManager.writeError("Error", this, "Comparing differnet-sized sketches");
            return Integer.MAX_VALUE;
        }
        int result = 0;
        boolean[][] exitArray = this.getExitArray();
        boolean[][] monsterArray = this.getMonsterArray();
        boolean[][] rewardArray = this.getRewardArray();
        boolean[][] otherExitArray = other.getExitArray();
        boolean[][] otherMonsterArray = other.getMonsterArray();
        boolean[][] otherRewardArray = other.getRewardArray();
        for (int x = 0; x < this.impassable.length; ++x) {
            for (int y = 0; y < this.impassable[x].length; ++y) {
                if (this.impassable[x][y] == other.impassable[x][y] && exitArray[x][y] == otherExitArray[x][y] && rewardArray[x][y] == otherRewardArray[x][y] && monsterArray[x][y] == otherMonsterArray[x][y]) continue;
                ++result;
            }
        }
        return result;
    }

    public void clearImpassable() {
        this.impassable = new boolean[this.mapSizeX][this.mapSizeY];
        for (int x = 0; x < this.impassable.length; ++x) {
            for (int y = 0; y < this.impassable[0].length; ++y) {
                this.impassable[x][y] = false;
            }
        }
    }

    public boolean addMonster(int x, int y) {
        if (this.isWithinBounds(x, y) && !this.impassable[x][y] && this.getRewardIndex(x, y) == -1 && this.getMonsterIndex(x, y) == -1 && this.getExitIndex(x, y) == -1) {
            this.monsters.add(new Point2D(x, y));
            return true;
        }
        return false;
    }

    public boolean removeMonster(int x, int y) {
        int index = this.getMonsterIndex(x, y);
        if (index != -1) {
            this.monsters.remove(index);
            return true;
        }
        return false;
    }

    public int getMonsterIndex(int x, int y) {
        for (int i = 0; i < this.monsters.size(); ++i) {
            if (this.monsters.get((int)i).x != (double)x || this.monsters.get((int)i).y != (double)y) continue;
            return i;
        }
        return -1;
    }

    public boolean addReward(int x, int y) {
        if (this.isWithinBounds(x, y) && !this.impassable[x][y] && this.getRewardIndex(x, y) == -1 && this.getMonsterIndex(x, y) == -1 && this.getExitIndex(x, y) == -1) {
            this.rewards.add(new Point2D(x, y));
            return true;
        }
        return false;
    }

    public boolean removeReward(int x, int y) {
        int index = this.getRewardIndex(x, y);
        if (index != -1) {
            this.rewards.remove(index);
            return true;
        }
        return false;
    }

    public int getRewardIndex(int x, int y) {
        for (int i = 0; i < this.rewards.size(); ++i) {
            if (this.rewards.get((int)i).x != (double)x || this.rewards.get((int)i).y != (double)y) continue;
            return i;
        }
        return -1;
    }

    public boolean addExit(int x, int y) {
        if (this.isWithinBounds(x, y) && !this.impassable[x][y] && this.getRewardIndex(x, y) == -1 && this.getMonsterIndex(x, y) == -1 && this.getExitIndex(x, y) == -1) {
            this.exits.add(new Point2D(x, y));
            return true;
        }
        return false;
    }

    public boolean removeExit(int x, int y) {
        int index = this.getExitIndex(x, y);
        if (index != -1) {
            this.exits.remove(index);
            return true;
        }
        return false;
    }

    public int getExitIndex(int x, int y) {
        for (int i = 0; i < this.exits.size(); ++i) {
            if (this.exits.get((int)i).x != (double)x || this.exits.get((int)i).y != (double)y) continue;
            return i;
        }
        return -1;
    }

    public void setPassable(int x, int y) {
        if (this.isWithinBounds(x, y)) {
            this.impassable[x][y] = false;
        }
    }

    public void setImpassable(int x, int y) {
        if (this.isWithinBounds(x, y)) {
            this.impassable[x][y] = true;
        }
    }

    public void setPassable(boolean[][] pattern, int centerX, int centerY) {
        for (int x = 0; x < pattern.length; ++x) {
            for (int y = 0; y < pattern[0].length; ++y) {
                int global_y;
                int global_x;
                if (!pattern[x][y] || !this.isWithinBounds(global_x = centerX - pattern.length / 2 + x * pattern.length, global_y = centerY - pattern[0].length / 2 + y * pattern[0].length)) continue;
                this.impassable[global_x][global_y] = false;
            }
        }
    }

    public void setImpassable(boolean[][] pattern, int centerX, int centerY) {
        for (int x = 0; x < pattern.length; ++x) {
            for (int y = 0; y < pattern[0].length; ++y) {
                int global_y;
                int global_x;
                if (!pattern[x][y] || !this.isWithinBounds(global_x = centerX - pattern.length / 2 + x, global_y = centerY - pattern[0].length / 2 + y)) continue;
                this.impassable[global_x][global_y] = true;
            }
        }
    }

    public void setImpassableChunk(int centerX, int centerY, int sizeX, int sizeY) {
        for (int x = centerX - sizeX / 2; x < centerX + sizeX / 2; ++x) {
            for (int y = centerY - sizeY / 2; y < centerY + sizeY / 2; ++y) {
                if (!this.isWithinBounds(x, y)) continue;
                this.impassable[x][y] = true;
            }
        }
    }

    public int getExitLength() {
        return this.exits.size();
    }

    public int getMonsterLength() {
        return this.monsters.size();
    }

    public int getRewardLength() {
        return this.rewards.size();
    }

    public Point2D getExit(int index) {
        return this.exits.get(index);
    }

    public Point2D getMonster(int index) {
        return this.monsters.get(index);
    }

    public Point2D getReward(int index) {
        return this.rewards.get(index);
    }

    public boolean isExit(int x, int y) {
        if (this.isWithinBounds(x, y)) {
            return this.inList(x, y, this.exits);
        }
        return false;
    }

    public boolean isMonster(int x, int y) {
        if (this.isWithinBounds(x, y)) {
            return this.inList(x, y, this.monsters);
        }
        return false;
    }

    public boolean isReward(int x, int y) {
        if (this.isWithinBounds(x, y)) {
            return this.inList(x, y, this.rewards);
        }
        return false;
    }

    public boolean inList(int x, int y, Vector<Point2D> list) {
        for (int i = 0; i < list.size(); ++i) {
            Point2D currPoint = list.get(i);
            if (x != (int)currPoint.x || y != (int)currPoint.y) continue;
            return true;
        }
        return false;
    }

    public boolean inList(Point2D point, Vector<Point2D> list) {
        for (int i = 0; i < list.size(); ++i) {
            Point2D currPoint = list.get(i);
            if ((int)point.x != (int)currPoint.x || (int)point.y != (int)currPoint.y) continue;
            return true;
        }
        return false;
    }

    public void finalizeSketch() {
        this.paths.init();
        this.paths.calculateAllPaths();
        this.paths.calculateNavigationInfo();
        this.paths.calculateEmptySpace();
        this.paths.calculateRewardSafety();
        this.paths.calculateSafetyMatrix();
        this.paths.calculateExplorationMatrix();
        this.metrics.update();
    }

    public boolean isPassable(int x, int y) {
        if (!this.isWithinBounds(x, y)) {
            return false;
        }
        return !this.impassable[x][y];
    }

    public boolean isWithinBounds(int x, int y) {
        return x >= 0 && x < this.mapSizeX && y >= 0 && y < this.mapSizeY;
    }

    public boolean isCorner(int x, int y) {
        if (x == 0 && y == 0) {
            return true;
        }
        if (x == 0 && y == this.mapSizeY - 1) {
            return true;
        }
        if (x == this.mapSizeX - 1 && y == 0) {
            return true;
        }
        return x == this.mapSizeX - 1 && y == this.mapSizeY - 1;
    }

    public boolean[][] getPassableArray() {
        boolean[][] result = new boolean[this.impassable.length][this.impassable[0].length];
        for (int x = 0; x < this.impassable.length; ++x) {
            for (int y = 0; y < this.impassable[0].length; ++y) {
                result[x][y] = !this.impassable[x][y];
            }
        }
        return result;
    }

    public boolean[][] getImpassableArray() {
        boolean[][] result = new boolean[this.impassable.length][this.impassable[0].length];
        for (int x = 0; x < this.impassable.length; ++x) {
            for (int y = 0; y < this.impassable[0].length; ++y) {
                result[x][y] = this.impassable[x][y];
            }
        }
        return result;
    }

    public boolean[][] getMonsterArray() {
        boolean[][] result = new boolean[this.impassable.length][this.impassable[0].length];
        for (int x = 0; x < this.impassable.length; ++x) {
            for (int y = 0; y < this.impassable[0].length; ++y) {
                result[x][y] = false;
            }
        }
        for (int i = 0; i < this.monsters.size(); ++i) {
            result[(int)this.monsters.get((int)i).x][(int)this.monsters.get((int)i).y] = true;
        }
        return result;
    }

    public boolean[][] getRewardArray() {
        boolean[][] result = new boolean[this.impassable.length][this.impassable[0].length];
        for (int x = 0; x < this.impassable.length; ++x) {
            for (int y = 0; y < this.impassable[0].length; ++y) {
                result[x][y] = false;
            }
        }
        for (int i = 0; i < this.rewards.size(); ++i) {
            result[(int)this.rewards.get((int)i).x][(int)this.rewards.get((int)i).y] = true;
        }
        return result;
    }

    public boolean[][] getExitArray() {
        boolean[][] result = new boolean[this.impassable.length][this.impassable[0].length];
        for (int x = 0; x < this.impassable.length; ++x) {
            for (int y = 0; y < this.impassable[0].length; ++y) {
                result[x][y] = false;
            }
        }
        for (int i = 0; i < this.exits.size(); ++i) {
            result[(int)this.exits.get((int)i).x][(int)this.exits.get((int)i).y] = true;
        }
        return result;
    }

    public boolean[][] getArray(Vector<Point2D> points) {
        boolean[][] result = new boolean[this.impassable.length][this.impassable[0].length];
        for (int x = 0; x < this.impassable.length; ++x) {
            for (int y = 0; y < this.impassable[0].length; ++y) {
                result[x][y] = false;
            }
        }
        for (int i = 0; i < points.size(); ++i) {
            result[(int)points.get((int)i).x][(int)points.get((int)i).y] = true;
        }
        return result;
    }

    public void randomize(int exitCount, int monsterCount, int rewardCount) {
        int y;
        int x;
        int i;
        this.exits.clear();
        for (i = 0; i < exitCount; ++i) {
            x = RandomNumberManager.getRandomInt(0, this.mapSizeX);
            y = RandomNumberManager.getRandomInt(0, this.mapSizeY);
            this.addExit(x, y);
        }
        this.monsters.clear();
        for (i = 0; i < monsterCount; ++i) {
            x = RandomNumberManager.getRandomInt(0, this.mapSizeX);
            y = RandomNumberManager.getRandomInt(0, this.mapSizeY);
            this.addMonster(x, y);
        }
        this.rewards.clear();
        for (i = 0; i < monsterCount; ++i) {
            x = RandomNumberManager.getRandomInt(0, this.mapSizeX);
            y = RandomNumberManager.getRandomInt(0, this.mapSizeY);
            this.addReward(x, y);
        }
    }

    public void randomizeChunks(int chunkCount) {
        this.clearImpassable();
        for (int i = 0; i < chunkCount; ++i) {
            int x = RandomNumberManager.getRandomInt(0, this.mapSizeX);
            int y = RandomNumberManager.getRandomInt(0, this.mapSizeY);
            this.impassable[x][y] = true;
        }
    }

    public String toASCII() {
        String result = "";
        for (int y = 0; y < this.mapSizeY; ++y) {
            for (int x = 0; x < this.mapSizeX; ++x) {
                result = this.impassable[x][y] ? result + "#" : (this.isExit(x, y) ? result + "E" : (this.isMonster(x, y) ? result + "m" : (this.isReward(x, y) ? result + "r" : result + ".")));
            }
            result = result + ";";
        }
        return result;
    }
}

