/*
 * Decompiled with CFR 0.152.
 */
package dungeon;

import common.PathLibrary;
import dungeon.Dungeon;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;
import util.math2d.Matrix2D;

public class DungeonMetrics {
    Dungeon parent;
    int exits;
    int monsters;
    int rewards;
    int used_space;
    int max_base_distance;
    int avg_base_distance;
    int min_base_distance;
    int choke_points;
    int dead_ends;
    int open_areas;

    public DungeonMetrics(Dungeon parent) {
        this.parent = parent;
        this.reset();
    }

    public void reset() {
    }

    public void update() {
        this.exits = this.parent.getExitLength();
        this.monsters = this.parent.getMonsterLength();
        this.rewards = this.parent.getRewardLength();
        this.used_space = 100 - 100 * Matrix2D.count(this.parent.getPaths().getUnusedSpaces()) / (this.parent.getMapSizeX() * this.parent.getMapSizeY());
        Vector<ArrayList> allPaths = this.parent.getPaths().getExitPaths();
        if (allPaths.size() > 0) {
            float[] pathLengths = new float[allPaths.size()];
            float avgPathLength = 0.0f;
            for (int i = 0; i < allPaths.size(); ++i) {
                pathLengths[i] = PathLibrary.calculateDistance(allPaths.get(i));
                avgPathLength += pathLengths[i];
            }
            Arrays.sort(pathLengths);
            this.max_base_distance = (int)pathLengths[pathLengths.length - 1];
            this.avg_base_distance = (int)(avgPathLength /= (float)allPaths.size());
            this.min_base_distance = (int)pathLengths[0];
        } else {
            this.max_base_distance = 0;
            this.avg_base_distance = 0;
            this.min_base_distance = 0;
        }
        this.choke_points = Matrix2D.count(this.parent.getPaths().getChokePoints());
        this.dead_ends = Matrix2D.count(this.parent.getPaths().getDeadEnds());
        this.open_areas = Matrix2D.count(this.parent.getPaths().getOpenAreas());
    }

    public int getExits() {
        return this.exits;
    }

    public int getMonsters() {
        return this.monsters;
    }

    public int getRewards() {
        return this.rewards;
    }

    public int getUsedSpace() {
        return this.used_space;
    }

    public int getMaxBaseDistance() {
        return this.max_base_distance;
    }

    public int getAvgBaseDistance() {
        return this.avg_base_distance;
    }

    public int getMinBaseDistance() {
        return this.min_base_distance;
    }

    public int getChokePoints() {
        return this.choke_points;
    }

    public int getDeadEnds() {
        return this.dead_ends;
    }

    public int getOpenAreas() {
        return this.open_areas;
    }

    public int[] getDataArray() {
        int[] result = new int[]{this.exits, this.monsters, this.rewards, this.used_space, this.max_base_distance, this.avg_base_distance, this.min_base_distance, this.choke_points, this.dead_ends, this.open_areas};
        return result;
    }
}

