/*
 * Decompiled with CFR 0.152.
 */
package dungeon;

import ai.pathfinder.Connector;
import ai.pathfinder.Node;
import ai.pathfinder.Pathfinder;
import common.PathLibrary;
import dungeon.Dungeon;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Vector;
import util.math2d.Matrix2D;
import util.math2d.Point2D;
import util.statics.LogManager;

public class DungeonPaths {
    Dungeon parent;
    Pathfinder astar;
    Vector<ArrayList> exitPaths;
    Vector<ArrayList> exit_monsterPaths;
    Vector<ArrayList> monster_rewardPaths;
    Vector<ArrayList> exitPathChokePoints;
    Vector<ArrayList> exit_rewardPaths;
    boolean[][] chokePoints;
    boolean[][] deadEnds;
    boolean[][] openAreas;
    int[][] branchingFactor;
    float averageBranchingFactor;
    boolean[][] unusedSpaces;
    Vector<float[]> rewardSafety;
    float[][][] safetyMatrix;
    float[][][] explorationMatrix;

    public DungeonPaths(Dungeon parent) {
        this.parent = parent;
    }

    public void init() {
        this.astar = new Pathfinder();
        boolean spacing = true;
        this.astar.corners = false;
        this.astar.setCuboidNodes(this.parent.getMapSizeX(), this.parent.getMapSizeY(), (float)spacing);
        for (Object temp : this.astar.nodes) {
            Node n = (Node)temp;
            n.walkable = this.parent.isPassable((int)n.x, (int)n.y);
        }
        this.astar.radialDisconnectUnwalkables();
    }

    public Node findNode(int x, int y) {
        for (Object temp : this.astar.nodes) {
            Node n = (Node)temp;
            if (n.x != (float)x || n.y != (float)y) continue;
            return n;
        }
        return null;
    }

    public void calculateAllPaths() {
        ArrayList path;
        int j;
        int i;
        if (this.astar == null) {
            this.init();
        }
        this.exitPaths = new Vector();
        for (i = 0; i < this.parent.exits.size(); ++i) {
            for (j = i + 1; j < this.parent.exits.size(); ++j) {
                path = this.getPath(this.parent.exits.get(j), this.parent.exits.get(i));
                if (path == null) continue;
                this.exitPaths.add(path);
            }
        }
        this.exit_monsterPaths = new Vector();
        for (i = 0; i < this.parent.exits.size(); ++i) {
            for (j = 0; j < this.parent.monsters.size(); ++j) {
                path = this.getPath(this.parent.monsters.get(j), this.parent.exits.get(i));
                if (path == null) continue;
                this.exit_monsterPaths.add(path);
            }
        }
        this.exit_rewardPaths = new Vector();
        for (i = 0; i < this.parent.exits.size(); ++i) {
            for (j = 0; j < this.parent.rewards.size(); ++j) {
                path = this.getPath(this.parent.rewards.get(j), this.parent.exits.get(i));
                if (path == null) continue;
                this.exit_rewardPaths.add(path);
            }
        }
        this.monster_rewardPaths = new Vector();
        for (i = 0; i < this.parent.monsters.size(); ++i) {
            for (j = 0; j < this.parent.rewards.size(); ++j) {
                path = this.getPath(this.parent.rewards.get(j), this.parent.monsters.get(i));
                if (path == null) continue;
                this.monster_rewardPaths.add(path);
            }
        }
    }

    public void calculateEmptySpace() {
        Vector<Point2D> points;
        int i;
        if (this.astar == null) {
            this.init();
        }
        if (this.exitPaths == null || this.exit_monsterPaths == null || this.monster_rewardPaths == null) {
            this.calculateAllPaths();
        }
        this.unusedSpaces = Matrix2D.invert(this.parent.getImpassableArray());
        this.unusedSpaces = Matrix2D.intersection(this.unusedSpaces, Matrix2D.invert(this.parent.getExitArray()));
        this.unusedSpaces = Matrix2D.intersection(this.unusedSpaces, Matrix2D.invert(this.parent.getMonsterArray()));
        this.unusedSpaces = Matrix2D.intersection(this.unusedSpaces, Matrix2D.invert(this.parent.getRewardArray()));
        for (i = 0; i < this.exitPaths.size(); ++i) {
            points = PathLibrary.transformPath(this.exitPaths.get(i));
            this.unusedSpaces = Matrix2D.intersection(this.unusedSpaces, Matrix2D.invert(PathLibrary.transformPath(points, this.unusedSpaces.length, this.unusedSpaces[0].length)));
        }
        for (i = 0; i < this.exit_monsterPaths.size(); ++i) {
            points = PathLibrary.transformPath(this.exit_monsterPaths.get(i));
            this.unusedSpaces = Matrix2D.intersection(this.unusedSpaces, Matrix2D.invert(PathLibrary.transformPath(points, this.unusedSpaces.length, this.unusedSpaces[0].length)));
        }
        for (i = 0; i < this.monster_rewardPaths.size(); ++i) {
            points = PathLibrary.transformPath(this.monster_rewardPaths.get(i));
            this.unusedSpaces = Matrix2D.intersection(this.unusedSpaces, Matrix2D.invert(PathLibrary.transformPath(points, this.unusedSpaces.length, this.unusedSpaces[0].length)));
        }
    }

    public void calculateNavigationInfo() {
        if (this.astar == null) {
            this.init();
        }
        this.chokePoints = new boolean[this.parent.getMapSizeX()][this.parent.getMapSizeY()];
        this.deadEnds = new boolean[this.parent.getMapSizeX()][this.parent.getMapSizeY()];
        this.openAreas = new boolean[this.parent.getMapSizeX()][this.parent.getMapSizeY()];
        this.branchingFactor = new int[this.parent.getMapSizeX()][this.parent.getMapSizeY()];
        this.averageBranchingFactor = 0.0f;
        int totalWalkable = 0;
        for (int x = 0; x < this.chokePoints.length; ++x) {
            for (int y = 0; y < this.chokePoints[0].length; ++y) {
                this.chokePoints[x][y] = false;
                this.deadEnds[x][y] = false;
                this.openAreas[x][y] = false;
            }
        }
        for (int i = 0; i < this.astar.nodes.size(); ++i) {
            Node n = (Node)this.astar.nodes.get(i);
            if (!n.walkable) continue;
            boolean j = false;
            ++totalWalkable;
            this.branchingFactor[(int)n.x][(int)n.y] = n.links.size();
            this.averageBranchingFactor += (float)n.links.size();
            if (n.links.size() == 1) {
                this.deadEnds[(int)n.x][(int)n.y] = true;
            }
            if (n.links.size() == 2) {
                this.chokePoints[(int)n.x][(int)n.y] = true;
            }
            if (n.links.size() != 4) continue;
            this.openAreas[(int)n.x][(int)n.y] = true;
        }
        this.averageBranchingFactor /= (float)totalWalkable;
    }

    public Vector<Point2D> calculateChokePoints(ArrayList path) {
        Vector<Point2D> result = new Vector<Point2D>();
        if (this.chokePoints == null) {
            this.calculateNavigationInfo();
        }
        for (int i = 1; i < path.size() - 1; ++i) {
            Node n = (Node)path.get(i);
            if (!this.isChokePoint((int)n.x, (int)n.y)) continue;
            result.add(new Point2D(n.x, n.y));
        }
        return result;
    }

    public boolean isChokePoint(int x, int y) {
        if (this.chokePoints == null) {
            this.calculateNavigationInfo();
        }
        if (x < 0 || y < 0 || x >= this.chokePoints.length || y >= this.chokePoints[0].length) {
            LogManager.writeError("Error", this, "Point out of bounds");
            return false;
        }
        return this.chokePoints[x][y];
    }

    protected float[] calculateRewardDistanceRatio(int rewardIndex) {
        int i;
        if (rewardIndex < 0 || rewardIndex >= this.parent.rewards.size()) {
            LogManager.writeError("Error", this, "Resource index out of bounds");
            return null;
        }
        if (this.monster_rewardPaths == null) {
            this.calculateAllPaths();
        }
        float[] result = new float[this.parent.monsters.size()];
        float[] dist = new float[this.parent.monsters.size()];
        for (i = 0; i < this.parent.monsters.size(); ++i) {
            dist[i] = -1.0f;
            ArrayList path = this.getRewardPathFromMonster(rewardIndex, i);
            if (path == null) continue;
            dist[i] = PathLibrary.calculateDistance(path);
        }
        for (i = 0; i < result.length; ++i) {
            if (dist[i] == -1.0f) {
                result[i] = -1.0f;
                continue;
            }
            result[i] = 1.0f;
            for (int j = 0; j < result.length; ++j) {
                if (i == j || result[j] == -1.0f) continue;
                result[i] = Math.min(result[i], Math.max(0.0f, (dist[j] - dist[i]) / (dist[i] + dist[j])));
            }
        }
        return result;
    }

    protected float[] calculateExitDistanceRatio(Point2D point) {
        return this.calculateExitDistanceRatio((int)point.x, (int)point.y);
    }

    protected float[] calculateExitDistanceRatio(int x, int y) {
        int i;
        float[] result = new float[this.parent.exits.size()];
        if (!this.parent.isPassable(x, y)) {
            return result;
        }
        float[] dist = new float[this.parent.exits.size()];
        for (i = 0; i < this.parent.exits.size(); ++i) {
            dist[i] = -1.0f;
            ArrayList path = this.getPath(this.parent.exits.get(i), x, y);
            if (!PathLibrary.hasStart(path, x, y) && !PathLibrary.hasEnd(path, x, y)) continue;
            dist[i] = PathLibrary.calculateDistance(path);
        }
        for (i = 0; i < result.length; ++i) {
            if (dist[i] == -1.0f) {
                result[i] = -1.0f;
                continue;
            }
            result[i] = 1.0f;
            for (int j = 0; j < result.length; ++j) {
                if (i == j || result[j] == -1.0f) continue;
                result[i] = Math.min(result[i], Math.max(0.0f, (dist[j] - dist[i]) / (dist[i] + dist[j])));
            }
        }
        return result;
    }

    protected float[] calculateMonsterDistanceRatio(Point2D point) {
        return this.calculateMonsterDistanceRatio((int)point.x, (int)point.y);
    }

    protected float[] calculateMonsterDistanceRatio(int x, int y) {
        int i;
        float[] result = new float[this.parent.monsters.size()];
        if (!this.parent.isPassable(x, y)) {
            return result;
        }
        float[] dist = new float[this.parent.monsters.size()];
        for (i = 0; i < this.parent.monsters.size(); ++i) {
            dist[i] = -1.0f;
            ArrayList path = this.getPath(this.parent.monsters.get(i), x, y);
            if (!PathLibrary.hasStart(path, x, y) && !PathLibrary.hasEnd(path, x, y)) continue;
            dist[i] = PathLibrary.calculateDistance(path);
        }
        for (i = 0; i < result.length; ++i) {
            if (dist[i] == -1.0f) {
                result[i] = -1.0f;
                continue;
            }
            result[i] = 1.0f;
            for (int j = 0; j < result.length; ++j) {
                if (i == j || result[j] == -1.0f) continue;
                result[i] = Math.min(result[i], Math.max(0.0f, (dist[j] - dist[i]) / (dist[i] + dist[j])));
            }
        }
        return result;
    }

    protected float[] calculateExitMonsterDistanceRatio(Point2D point) {
        return this.calculateExitMonsterDistanceRatio((int)point.x, (int)point.y);
    }

    protected float[] calculateExitMonsterDistanceRatio(int x, int y) {
        int i;
        float[] result = new float[this.parent.exits.size() + this.parent.monsters.size()];
        if (!this.parent.isPassable(x, y)) {
            return result;
        }
        float[] dist = new float[this.parent.exits.size() + this.parent.monsters.size()];
        for (i = 0; i < this.parent.exits.size() + this.parent.monsters.size(); ++i) {
            ArrayList path;
            dist[i] = -1.0f;
            ArrayList arrayList = path = i < this.parent.exits.size() ? this.getPath(this.parent.exits.get(i), x, y) : this.getPath(this.parent.monsters.get(i - this.parent.exits.size()), x, y);
            if (!PathLibrary.hasStart(path, x, y) && !PathLibrary.hasEnd(path, x, y)) continue;
            dist[i] = PathLibrary.calculateDistance(path);
        }
        for (i = 0; i < result.length; ++i) {
            if (dist[i] == -1.0f) {
                result[i] = -1.0f;
                continue;
            }
            result[i] = 1.0f;
            for (int j = 0; j < result.length; ++j) {
                if (i == j || result[j] == -1.0f) continue;
                result[i] = Math.min(result[i], Math.max(0.0f, (dist[j] - dist[i]) / (dist[i] + dist[j])));
            }
        }
        return result;
    }

    public void calculateSafetyMatrix() {
        this.safetyMatrix = new float[this.parent.getMapSizeX()][this.parent.getMapSizeY()][this.parent.exits.size()];
        for (int x = 0; x < this.parent.getMapSizeX(); ++x) {
            for (int y = 0; y < this.parent.getMapSizeY(); ++y) {
                this.safetyMatrix[x][y] = this.calculateExitMonsterDistanceRatio(x, y);
            }
        }
    }

    public float[][] getSafetyMatrix(int baseIndex) {
        if (this.safetyMatrix == null) {
            this.calculateSafetyMatrix();
        }
        float[][] result = new float[this.parent.getMapSizeX()][this.parent.getMapSizeY()];
        for (int x = 0; x < this.parent.getMapSizeX(); ++x) {
            for (int y = 0; y < this.parent.getMapSizeY(); ++y) {
                result[x][y] = this.safetyMatrix[x][y][baseIndex];
            }
        }
        return result;
    }

    public float getSafety(int x, int y, int baseIndex) {
        if (this.safetyMatrix == null) {
            this.calculateSafetyMatrix();
        }
        return this.safetyMatrix[x][y][baseIndex];
    }

    public float[] getSafety(int x, int y) {
        if (this.safetyMatrix == null) {
            this.calculateSafetyMatrix();
        }
        return Arrays.copyOf(this.safetyMatrix[x][y], this.safetyMatrix[x][y].length);
    }

    public void calculateRewardSafety() {
        this.rewardSafety = new Vector();
        for (int j = 0; j < this.parent.getRewardLength(); ++j) {
            this.rewardSafety.add(this.calculateRewardDistanceRatio(j));
        }
    }

    public float[] getRewardSafety(int rewardIndex) {
        if (this.rewardSafety == null) {
            this.calculateRewardSafety();
        }
        return this.rewardSafety.get(rewardIndex);
    }

    protected float[][] exploreTo(boolean[][] pixels, Point2D startingPixel, Point2D endingPixel) {
        int x = (int)startingPixel.x;
        int y = (int)startingPixel.y;
        float[][] result = new float[pixels.length][pixels[0].length];
        if (pixels[x][y]) {
            LinkedList<Point2D> queue = new LinkedList<Point2D>();
            queue.add(new Point2D(x, y));
            while (!queue.isEmpty() && result[(int)endingPixel.x][(int)endingPixel.y] != 1.0f) {
                Point2D point = (Point2D)queue.remove();
                if (!(point.x >= 0.0) || !(point.y >= 0.0) || !(point.x < (double)pixels.length) || !(point.y < (double)pixels[0].length) || !pixels[(int)point.x][(int)point.y]) continue;
                pixels[(int)point.x][(int)point.y] = false;
                result[(int)point.x][(int)point.y] = 1.0f;
                if (Math.abs(point.x - (double)(pixels.length / 2)) > Math.abs(point.y - (double)(pixels[0].length / 2))) {
                    if (point.x < (double)(pixels.length / 2)) {
                        queue.add(new Point2D(point.x + 1.0, point.y));
                    } else {
                        queue.add(new Point2D(point.x - 1.0, point.y));
                    }
                    if (point.y < (double)(pixels[0].length / 2)) {
                        queue.add(new Point2D(point.x, point.y + 1.0));
                        queue.add(new Point2D(point.x, point.y - 1.0));
                    } else {
                        queue.add(new Point2D(point.x, point.y - 1.0));
                        queue.add(new Point2D(point.x, point.y + 1.0));
                    }
                    if (point.x < (double)(pixels.length / 2)) {
                        queue.add(new Point2D(point.x - 1.0, point.y));
                        continue;
                    }
                    queue.add(new Point2D(point.x + 1.0, point.y));
                    continue;
                }
                if (point.y < (double)(pixels[0].length / 2)) {
                    queue.add(new Point2D(point.x, point.y + 1.0));
                } else {
                    queue.add(new Point2D(point.x, point.y - 1.0));
                }
                if (point.x < (double)(pixels.length / 2)) {
                    queue.add(new Point2D(point.x + 1.0, point.y));
                    queue.add(new Point2D(point.x - 1.0, point.y));
                } else {
                    queue.add(new Point2D(point.x - 1.0, point.y));
                    queue.add(new Point2D(point.x + 1.0, point.y));
                }
                if (point.y < (double)(pixels[0].length / 2)) {
                    queue.add(new Point2D(point.x, point.y - 1.0));
                    continue;
                }
                queue.add(new Point2D(point.x, point.y + 1.0));
            }
        }
        return result;
    }

    public void calculateExplorationMatrix() {
        this.explorationMatrix = new float[this.parent.getMapSizeX()][this.parent.getMapSizeY()][this.parent.exits.size()];
        float increment = 1.0f / (float)(this.parent.getExitLength() - 1);
        for (int i = 0; i < this.parent.getExitLength(); ++i) {
            for (int j = 0; j < this.parent.getExitLength(); ++j) {
                if (i == j) continue;
                float[][] temp = this.exploreTo(Matrix2D.invert(this.parent.impassable), this.parent.getExit(i), this.parent.getExit(j));
                for (int x = 0; x < temp.length; ++x) {
                    for (int y = 0; y < temp[0].length; ++y) {
                        float[] fArray = this.explorationMatrix[x][y];
                        int n = i;
                        fArray[n] = fArray[n] + temp[x][y] * increment;
                    }
                }
            }
        }
    }

    public float[][] getExplorationMatrix(int baseIndex) {
        if (this.explorationMatrix == null) {
            this.calculateExplorationMatrix();
        }
        float[][] result = new float[this.parent.getMapSizeX()][this.parent.getMapSizeY()];
        for (int x = 0; x < this.parent.getMapSizeX(); ++x) {
            for (int y = 0; y < this.parent.getMapSizeY(); ++y) {
                result[x][y] = this.explorationMatrix[x][y][baseIndex];
            }
        }
        return result;
    }

    public float[][][] calculateCustomExplorationMatrix(Vector<Point2D> refPoints) {
        float[][][] result = new float[refPoints.size()][this.parent.getMapSizeX()][this.parent.getMapSizeY()];
        float increment = 1.0f / (float)(refPoints.size() - 1);
        for (int i = 0; i < refPoints.size(); ++i) {
            for (int j = 0; j < refPoints.size(); ++j) {
                if (i == j) continue;
                float[][] temp = this.exploreTo(Matrix2D.invert(this.parent.impassable), refPoints.get(i), refPoints.get(j));
                for (int x = 0; x < temp.length; ++x) {
                    for (int y = 0; y < temp[0].length; ++y) {
                        float[] fArray = result[i][x];
                        int n = y;
                        fArray[n] = fArray[n] + temp[x][y] * increment;
                    }
                }
            }
        }
        return result;
    }

    public Vector<ArrayList> getMonster_rewardPaths() {
        return this.monster_rewardPaths;
    }

    public Vector<ArrayList> getExit_monsterPaths() {
        return this.exit_monsterPaths;
    }

    public Vector<ArrayList> getExitPaths() {
        return this.exitPaths;
    }

    public int getMonster_rewardPathLength() {
        return this.monster_rewardPaths.size();
    }

    public int getExit_monsterPathLength() {
        return this.exit_monsterPaths.size();
    }

    public int getExitPathLength() {
        return this.exitPaths.size();
    }

    public boolean[][] getChokePoints() {
        if (this.chokePoints == null) {
            this.calculateNavigationInfo();
        }
        return Matrix2D.copy(this.chokePoints);
    }

    public boolean[][] getDeadEnds() {
        if (this.deadEnds == null) {
            this.calculateNavigationInfo();
        }
        return Matrix2D.copy(this.deadEnds);
    }

    public boolean[][] getOpenAreas() {
        if (this.openAreas == null) {
            this.calculateNavigationInfo();
        }
        return Matrix2D.copy(this.openAreas);
    }

    public int[][] getBranchingFactor() {
        if (this.branchingFactor == null) {
            this.calculateNavigationInfo();
        }
        return Matrix2D.copy(this.branchingFactor);
    }

    public boolean[][] getUnusedSpaces() {
        if (this.unusedSpaces == null) {
            this.calculateEmptySpace();
        }
        return Matrix2D.copy(this.unusedSpaces);
    }

    public float getAverageBranchingFactor() {
        if (this.branchingFactor == null) {
            this.calculateNavigationInfo();
        }
        return this.averageBranchingFactor;
    }

    public float getBestAverageBranchingFactor() {
        if (this.astar == null) {
            this.init();
        }
        int allTiles = this.parent.getMapSizeX() * this.parent.getMapSizeY();
        int middleTiles = (this.parent.getMapSizeX() - 2) * (this.parent.getMapSizeY() - 2);
        int cornerTiles = 4;
        int edgeTiles = allTiles - middleTiles - cornerTiles;
        float result = this.astar.corners ? (float)(middleTiles * 8 + cornerTiles * 3 + edgeTiles * 5) : (float)(middleTiles * 4 + cornerTiles * 2 + edgeTiles * 3);
        return result / (float)allTiles;
    }

    public Pathfinder getAStar() {
        return this.astar;
    }

    public Vector<ArrayList> getRewardsPathsFromMonster(int monsterIndex) {
        Vector<ArrayList> result = new Vector<ArrayList>();
        if (monsterIndex < 0 || monsterIndex >= this.parent.monsters.size()) {
            LogManager.writeError("Error", this, "Base index out of bounds");
            return result;
        }
        int monsterX = (int)this.parent.monsters.get((int)monsterIndex).x;
        int monsterY = (int)this.parent.monsters.get((int)monsterIndex).y;
        for (int i = 0; i < this.monster_rewardPaths.size(); ++i) {
            if (!PathLibrary.hasStart(this.monster_rewardPaths.get(i), monsterX, monsterY) && !PathLibrary.hasEnd(this.monster_rewardPaths.get(i), monsterX, monsterY)) continue;
            result.add(this.monster_rewardPaths.get(i));
        }
        return result;
    }

    public Vector<ArrayList> getRewardsPathsFromReward(int rewardIndex) {
        Vector<ArrayList> result = new Vector<ArrayList>();
        if (rewardIndex < 0 || rewardIndex >= this.parent.rewards.size()) {
            LogManager.writeError("Error", this, "Resource index out of bounds");
            return result;
        }
        int rewardX = (int)this.parent.rewards.get((int)rewardIndex).x;
        int rewardY = (int)this.parent.rewards.get((int)rewardIndex).y;
        for (int i = 0; i < this.monster_rewardPaths.size(); ++i) {
            if (!PathLibrary.hasStart(this.monster_rewardPaths.get(i), rewardX, rewardY) && !PathLibrary.hasEnd(this.monster_rewardPaths.get(i), rewardX, rewardY)) continue;
            result.add(this.monster_rewardPaths.get(i));
        }
        return result;
    }

    public ArrayList getRewardPathFromMonster(int rewardIndex, int monsterIndex) {
        if (monsterIndex < 0 || monsterIndex >= this.parent.monsters.size()) {
            LogManager.writeError("Error", this, "Monster index out of bounds");
            return null;
        }
        if (rewardIndex < 0 || rewardIndex >= this.parent.rewards.size()) {
            LogManager.writeError("Error", this, "Reward index out of bounds");
            return null;
        }
        int monsterX = (int)this.parent.monsters.get((int)monsterIndex).x;
        int monsterY = (int)this.parent.monsters.get((int)monsterIndex).y;
        int rewardX = (int)this.parent.rewards.get((int)rewardIndex).x;
        int rewardY = (int)this.parent.rewards.get((int)rewardIndex).y;
        for (int i = 0; i < this.monster_rewardPaths.size(); ++i) {
            if (PathLibrary.hasStart(this.monster_rewardPaths.get(i), monsterX, monsterY) && PathLibrary.hasEnd(this.monster_rewardPaths.get(i), rewardX, rewardY)) {
                return this.monster_rewardPaths.get(i);
            }
            if (!PathLibrary.hasStart(this.monster_rewardPaths.get(i), rewardX, rewardY) || !PathLibrary.hasEnd(this.monster_rewardPaths.get(i), monsterX, monsterY)) continue;
            return this.monster_rewardPaths.get(i);
        }
        return null;
    }

    public ArrayList getRewardPathFromExit(int rewardIndex, int exitIndex) {
        if (exitIndex < 0 || exitIndex >= this.parent.monsters.size()) {
            LogManager.writeError("Error", this, "Monster index out of bounds");
            return null;
        }
        if (rewardIndex < 0 || rewardIndex >= this.parent.rewards.size()) {
            LogManager.writeError("Error", this, "Reward index out of bounds");
            return null;
        }
        int monsterX = (int)this.parent.exits.get((int)exitIndex).x;
        int monsterY = (int)this.parent.exits.get((int)exitIndex).y;
        int rewardX = (int)this.parent.rewards.get((int)rewardIndex).x;
        int rewardY = (int)this.parent.rewards.get((int)rewardIndex).y;
        for (int i = 0; i < this.exit_rewardPaths.size(); ++i) {
            if (PathLibrary.hasStart(this.exit_rewardPaths.get(i), monsterX, monsterY) && PathLibrary.hasEnd(this.exit_rewardPaths.get(i), rewardX, rewardY)) {
                return this.exit_rewardPaths.get(i);
            }
            if (!PathLibrary.hasStart(this.exit_rewardPaths.get(i), rewardX, rewardY) || !PathLibrary.hasEnd(this.exit_rewardPaths.get(i), monsterX, monsterY)) continue;
            return this.exit_rewardPaths.get(i);
        }
        return null;
    }

    public ArrayList getPath(Point2D p1, Point2D p2) {
        return this.getPath((int)p1.x, (int)p1.y, (int)p2.x, (int)p2.y);
    }

    public ArrayList getPath(Point2D p1, int x2, int y2) {
        return this.getPath((int)p1.x, (int)p1.y, x2, y2);
    }

    public ArrayList getPath(int x1, int y1, Point2D p2) {
        return this.getPath(x1, y1, (int)p2.x, (int)p2.y);
    }

    public ArrayList getPath(int x1, int y1, int x2, int y2) {
        ArrayList result = this.astar.aStar(this.findNode(x1, y1), this.findNode(x2, y2));
        if (PathLibrary.hasStart(result, x2, y2) && PathLibrary.hasEnd(result, x1, y1)) {
            return result;
        }
        return null;
    }

    public Vector<ArrayList> calculateDFSPaths(Point2D start, Point2D end) {
        Vector<ArrayList> result = new Vector<ArrayList>();
        if (this.astar == null) {
            this.init();
        }
        Node startNode = this.findNode((int)start.x, (int)start.y);
        Node endNode = this.findNode((int)end.x, (int)end.y);
        Vector<Node> marked = new Vector<Node>();
        LinkedList<Node> q = new LinkedList<Node>();
        ArrayList<Node> currPath = new ArrayList<Node>();
        currPath.add(startNode);
        q.addLast(startNode);
        marked.add(startNode);
        while (!q.isEmpty()) {
            Node temp = (Node)q.getLast();
            currPath.add(temp);
            if (temp.x == endNode.x && temp.y == endNode.y) {
                result.add(currPath);
                if (result.size() > 4) {
                    return result;
                }
                marked.clear();
                marked.add(startNode);
                q.clear();
                q.addLast(startNode);
                currPath = new ArrayList();
                currPath.add(startNode);
            }
            for (int i = 0; i < temp.links.size(); ++i) {
                Connector conn = (Connector)temp.links.get(i);
                Node neighb = conn.n;
                if (marked.contains(neighb)) continue;
                marked.add(neighb);
                q.add(neighb);
            }
        }
        return result;
    }
}

