/*
 * Decompiled with CFR 0.152.
 */
package dungeon.experiments;

import dungeon.Dungeon;
import dungeon.genetic.DungeonEmbryogeny;
import dungeon.genetic.DungeonGene;
import dungeon.genetic.DungeonGeneticAlgorithm;
import dungeon.genetic.fitness.FeasibleFitness;
import dungeon.genetic.fitness.InfeasibleFitness;
import dungeon.visualization.DungeonDetailVisualizer;
import dungeon.visualization.DungeonVisualizer;
import genetic.Embryogeny;
import genetic.FI2PopTrainer;
import genetic.Gene;
import genetic.GeneticAlgorithm;
import genetic.fitness.Fitness;
import genetic.fitness.WeightedFitness;
import genetic.logger.BestFitnessLogger;
import genetic.logger.SingleFitnessLogger;
import processing.core.PApplet;
import processing.core.PImage;
import util.collections.ParameterCollection;
import util.statics.LogManager;

public class OfflineFI2pop {
    final int totalRuns = 20;
    final int generations = 101;

    public void experiment(WeightedFitness sfn, Fitness ifn, int mapSizeX, int mapSizeY, ParameterCollection params, String name) {
        String file = name + "/" + sfn.getLabel() + "/";
        PApplet p = new PApplet();
        SingleFitnessLogger logger = new SingleFitnessLogger(101, 20, (Fitness)sfn);
        BestFitnessLogger bLogger = new BestFitnessLogger(101, 20, sfn);
        LogManager.addLogfile("Best_" + sfn.getLabel(), file + "/bestIndividuals.xml");
        LogManager.addLogfile("Times_" + sfn.getLabel(), file + "/times.csv");
        int[][] allFeasible = new int[101][20];
        int[][] allMatches = new int[101][20];
        int[][] bestDifference = new int[101][20];
        double[][] feasibleDiversity = new double[101][20];
        for (int r = 1; r <= 20; ++r) {
            long startTime = System.currentTimeMillis();
            DungeonEmbryogeny de = new DungeonEmbryogeny(mapSizeX, mapSizeY);
            DungeonGeneticAlgorithm ga = new DungeonGeneticAlgorithm(params);
            DungeonGeneticAlgorithm iga = new DungeonGeneticAlgorithm(params);
            ga.initializePopulation();
            iga.initializePopulation();
            FI2PopTrainer gTrainer = new FI2PopTrainer((Fitness)sfn, ifn, (Embryogeny)de, (GeneticAlgorithm)ga, (GeneticAlgorithm)iga, params);
            gTrainer.shufflePopulations();
            gTrainer.setLogID(file + r + "/log");
            gTrainer.evaluateParents();
            gTrainer.setLogID(file + r + "/log");
            LogManager.addLogfile("MapOutput" + sfn.getLabel() + "_" + r, file + r + "/geneticalgorithm_map.log");
            for (int i = 0; i < 101; ++i) {
                logger.storeGeneration(i, r, gTrainer.getFeasibleTrainer());
                bLogger.storeGeneration(i, r, gTrainer.getFeasibleTrainer());
                int matches = 0;
                int bestDiff = Integer.MAX_VALUE;
                double currDiversity = 0.0;
                for (int j = 0; j < gTrainer.getFeasibleTrainer().getPopulation().getPopulationSize(); ++j) {
                    Gene cg = gTrainer.getFeasibleTrainer().getPopulation().getGene(j);
                    int tc = 0;
                    int cf = 0;
                    for (int k = 0; k < gTrainer.getFeasibleTrainer().getPopulation().getPopulationSize(); ++k) {
                        cf = (int)((float)cf + gTrainer.getFeasibleTrainer().getPopulation().getGene(k).getDifference(cg));
                        ++tc;
                    }
                    currDiversity += (double)cf / (double)tc;
                }
                feasibleDiversity[i][r - 1] = currDiversity / (double)gTrainer.getFeasibleTrainer().getPopulation().getPopulationSize();
                allFeasible[i][r - 1] = gTrainer.getFeasibleTrainer().getPopulation().getPopulationSize();
                allMatches[i][r - 1] = matches;
                bestDifference[i][r - 1] = bestDiff;
                DungeonGene best = (DungeonGene)gTrainer.getBestFeasibleIndividual();
                if (best != null && i % 10 == 0) {
                    Dungeon im = de.createPhenotype(best.getGenotype());
                    PImage img = DungeonVisualizer.renderThumbnail(p, im, mapSizeX, mapSizeY).getImage();
                    img.save(file + r + "/bestIndividual" + i + ".png");
                    PImage dung_img = DungeonVisualizer.renderDungeon(p, im, mapSizeX * 20, mapSizeY * 20).getImage();
                    dung_img.save(file + r + "/bestIndividual" + i + "_dungeon.png");
                    PImage sprite_img = DungeonDetailVisualizer.renderDungeon(p, im, mapSizeX * 20, mapSizeY * 20).getImage();
                    sprite_img.save(file + r + "/bestIndividual" + i + "_sprite.png");
                    System.out.println(sfn.getLabel() + " (" + i + ") " + gTrainer.getFeasibleTrainer().getMaxFitness());
                }
                if (i >= 101) continue;
                gTrainer.train(1);
            }
            long elapsedTime = System.currentTimeMillis() - startTime;
            LogManager.write("Times_" + sfn.getLabel(), elapsedTime + "");
            logger.writeRun(r, file);
            bLogger.writeRun(r, file);
            if (gTrainer.getFeasibleTrainer().getBestIndividual() == null) continue;
            DungeonGene bestGene = (DungeonGene)gTrainer.getFeasibleTrainer().getBestIndividual();
            Dungeon bestSketch = (Dungeon)bestGene.getPhenotype();
            LogManager.write("Best_" + sfn.getLabel(), bestGene.toXML());
            PImage thumb = DungeonVisualizer.renderThumbnail(p, bestSketch, 80, 80).getImage();
            thumb.save(file + "/bestThumb" + r + ".png");
        }
        logger.writeAllProgress(file);
        bLogger.writeAllProgress(file);
        LogManager.addLogfile("FeasibleIndividuals" + sfn.getLabel(), file + "/feasibleIndividuals.csv");
        LogManager.addLogfile("FeasibleDiversity" + sfn.getLabel(), file + "/feasibleDiversity.csv");
        String output1 = "";
        String output2 = "";
        String output3 = "";
        String output4 = "";
        for (int i = 0; i < allFeasible.length; ++i) {
            for (int r = 0; r < allFeasible[i].length; ++r) {
                output1 = output1 + allFeasible[i][r] + ";";
                output2 = output2 + allMatches[i][r] + ";";
                output3 = output3 + bestDifference[i][r] + ";";
                output4 = output4 + feasibleDiversity[i][r] + ";";
            }
            LogManager.write("FeasibleIndividuals" + sfn.getLabel(), output1);
            LogManager.write("FeasibleDiversity" + sfn.getLabel(), output4);
            output1 = "";
            output2 = "";
            output3 = "";
            output4 = "";
        }
    }

    public static void set_experiment(String name, int mapSizeX, int mapSizeY, int minExits, int maxExits, int minMonsters, int maxMonsters, int minRewards, int maxRewards, int population) {
        LogManager.reset();
        OfflineFI2pop smg = new OfflineFI2pop();
        ParameterCollection params = new ParameterCollection();
        params.setParameter("population", population / 2);
        params.setParameter("maxGenerations", "500");
        params.setParameter("normalizeFitness", "1");
        params.setParameter("steadyPercentage", "1");
        params.setParameter("repair", "1");
        params.setParameter("enforceMinFeasiblePopulation", "0.5");
        params.setParameter("crossoverPoints", "2");
        params.setParameter("mapSizeX", "" + mapSizeX);
        params.setParameter("mapSizeY", "" + mapSizeY);
        params.setParameter("genotypeMinExits", "" + minExits);
        params.setParameter("genotypeMaxExits", "" + maxExits);
        params.setParameter("genotypeMinMonsters", "" + minMonsters);
        params.setParameter("genotypeMaxMonsters", "" + maxMonsters);
        params.setParameter("genotypeMinRewards", "" + minRewards);
        params.setParameter("genotypeMaxRewards", "" + maxRewards);
        params.setParameter("mutateAnyProbability", "1");
        params.setParameter("mutateOnlyProbability", "5");
        params.setParameter("mutateTile", "5");
        if (minExits == maxExits) {
            params.setParameter("mutateExit", "0");
        } else {
            params.setParameter("mutateExit", "1");
        }
        if (minMonsters == maxMonsters) {
            params.setParameter("mutateMonster", "0");
        } else {
            params.setParameter("mutateMonster", "2");
        }
        if (minRewards == maxRewards) {
            params.setParameter("mutateReward", "0");
        } else {
            params.setParameter("mutateReward", "2");
        }
        params.setParameter("mutateShift", "15");
        params.setParameter("mutateDiagonal", "0");
        params.setParameter("mutateTileMinNumber", "" + (int)(0.05 * (double)mapSizeX * (double)mapSizeY));
        params.setParameter("mutateTileMaxNumber", "" + (int)(0.2 * (double)mapSizeX * (double)mapSizeY));
        InfeasibleFitness ifn = new InfeasibleFitness(minExits, maxExits, minMonsters, maxMonsters, minRewards, maxRewards);
        smg.experiment(new FeasibleFitness(0.0, 0.0, 0.25, 0.25, 0.0, 0.0, 0.25, 0.25), (Fitness)ifn, mapSizeX, mapSizeY, params, name);
    }

    public static void main(String[] args) {
        OfflineFI2pop.set_experiment("experiment/fps/8x8", 8, 8, 2, 2, 3, 5, 3, 3, 100);
        OfflineFI2pop.set_experiment("experiment/fps/12x12", 12, 12, 2, 2, 4, 7, 4, 4, 100);
    }
}

