/*
 * Decompiled with CFR 0.152.
 */
package dungeon.genetic;

import dungeon.Dungeon;
import genetic.Embryogeny;

public class DungeonEmbryogeny
implements Embryogeny<boolean[], Dungeon> {
    int mapSizeX;
    int mapSizeY;
    static final int tileBits = 4;
    boolean[][][] frozenAreas;

    public DungeonEmbryogeny(int mapSizeX, int mapSizeY) {
        this.mapSizeX = mapSizeX;
        this.mapSizeY = mapSizeY;
        this.frozenAreas = null;
    }

    public void addToFrozenArea(int x, int y, boolean impassable, boolean base, boolean resource) {
        if (this.frozenAreas == null) {
            this.resetFrozenArea();
        }
        this.frozenAreas[x][y] = new boolean[]{impassable, base, resource};
    }

    public void resetFrozenArea() {
        this.frozenAreas = new boolean[this.mapSizeX][this.mapSizeY][];
        for (int x = 0; x < this.frozenAreas.length; ++x) {
            for (int y = 0; y < this.frozenAreas[0].length; ++y) {
                this.frozenAreas[x][y] = null;
            }
        }
    }

    public Dungeon createPhenotype(boolean[] genotype) {
        Dungeon result = new Dungeon(this.mapSizeX, this.mapSizeY);
        int tileLength = (int)Math.floor(genotype.length / 4);
        for (int i = 0; i < tileLength; ++i) {
            int x = i % this.mapSizeX;
            int y = (int)Math.floor(i / this.mapSizeX);
            if (this.frozenAreas == null || this.frozenAreas[x][y] == null) {
                if (genotype[4 * i]) {
                    result.setImpassable(x, y);
                }
                if (genotype[4 * i + 1]) {
                    result.addExit(x, y);
                }
                if (genotype[4 * i + 2]) {
                    result.addMonster(x, y);
                }
                if (!genotype[4 * i + 3]) continue;
                result.addReward(x, y);
                continue;
            }
            if (this.frozenAreas[x][y][0]) {
                result.setImpassable(x, y);
            }
            if (this.frozenAreas[x][y][1]) {
                result.addExit(x, y);
            }
            if (this.frozenAreas[x][y][2]) {
                result.addMonster(x, y);
            }
            if (!this.frozenAreas[x][y][3]) continue;
            result.addReward(x, y);
        }
        result.finalizeSketch();
        return result;
    }
}

