/*
 * Decompiled with CFR 0.152.
 */
package dungeon.genetic;

import genetic.Gene;
import java.util.Arrays;
import java.util.Vector;
import util.collections.ParameterCollection;
import util.statics.LogManager;
import util.statics.RandomNumberManager;

public class DungeonGene
extends Gene<boolean[]> {
    static final int tileBits = 4;
    int mapSizeX;
    int mapSizeY;

    public DungeonGene(int mapSizeX, int mapSizeY, ParameterCollection gaParams) {
        this.parameters = gaParams;
        this.phenotype = null;
        this.fitness = 0.0;
        this.mapSizeX = mapSizeX;
        this.mapSizeY = mapSizeY;
        this.genotype = new boolean[4 * mapSizeX * mapSizeY];
    }

    public DungeonGene(Gene copy) {
        if (!(copy instanceof DungeonGene)) {
            LogManager.writeError("Error", (Object)this, "combining genes of different types");
            return;
        }
        DungeonGene ba_copy = (DungeonGene)copy;
        this.parameters = ba_copy.parameters;
        this.phenotype = null;
        this.fitness = 0.0;
        this.mapSizeX = ba_copy.mapSizeX;
        this.mapSizeY = ba_copy.mapSizeY;
        this.genotype = new boolean[((boolean[])ba_copy.genotype).length];
        for (int i = 0; i < ((boolean[])this.genotype).length; ++i) {
            ((boolean[])this.genotype)[i] = ((boolean[])ba_copy.genotype)[i];
        }
    }

    public DungeonGene(boolean[] genotype, int mapSizeX, int mapSizeY, ParameterCollection gaParams) {
        this.parameters = gaParams;
        this.phenotype = null;
        this.fitness = 0.0;
        this.mapSizeX = mapSizeX;
        this.mapSizeY = mapSizeY;
        this.genotype = Arrays.copyOf(genotype, genotype.length);
    }

    public void randomize() {
        int exits = 0;
        int monsters = 0;
        int rewards = 0;
        for (int i = 0; i < ((boolean[])this.genotype).length; ++i) {
            if (i % 4 == 0) {
                ((boolean[])this.genotype)[i] = RandomNumberManager.getRandomBoolean();
                continue;
            }
            if (i % 4 == 1 && !((boolean[])this.genotype)[i - 1]) {
                ((boolean[])this.genotype)[i] = RandomNumberManager.getRandomBoolean();
                if (!((boolean[])this.genotype)[i]) continue;
                ++exits;
                continue;
            }
            if (i % 4 == 2 && !((boolean[])this.genotype)[i - 2] && !((boolean[])this.genotype)[i - 1]) {
                ((boolean[])this.genotype)[i] = RandomNumberManager.getRandomBoolean();
                if (!((boolean[])this.genotype)[i]) continue;
                ++monsters;
                continue;
            }
            if (i % 4 != 3 || ((boolean[])this.genotype)[i - 3] || ((boolean[])this.genotype)[i - 2] || ((boolean[])this.genotype)[i - 1]) continue;
            ((boolean[])this.genotype)[i] = RandomNumberManager.getRandomBoolean();
            if (!((boolean[])this.genotype)[i]) continue;
            ++rewards;
        }
        this.repairGenotype();
    }

    public static DungeonGene loadFromString(String xml, int mapSizeX, int mapSizeY, ParameterCollection gaParams) {
        String localXml = new String(xml);
        localXml.replace("<gene>", "");
        localXml.replace("<array>", "");
        localXml.replace("</array>", "");
        localXml.replace("</gene>", "");
        String[] allelesStr = localXml.split(";");
        boolean[] alleles = new boolean[allelesStr.length];
        for (int i = 0; i < alleles.length; ++i) {
            alleles[i] = Boolean.parseBoolean(allelesStr[i]);
        }
        return new DungeonGene(alleles, mapSizeX, mapSizeY, gaParams);
    }

    public DungeonGene clone() {
        return new DungeonGene(this);
    }

    public String toXML() {
        String result = "";
        result = result + "<gene>";
        result = result + "<array>";
        for (int i = 0; i < ((boolean[])this.genotype).length; ++i) {
            result = result + ((boolean[])this.genotype)[i];
            if (i >= ((boolean[])this.genotype).length - 1) continue;
            result = result + ";";
        }
        result = result + "</array>";
        result = result + "</gene>";
        return result;
    }

    public Vector<Gene> produceOffspring(Gene other) {
        Vector<Gene> result = new Vector<Gene>();
        if (!(other instanceof DungeonGene)) {
            LogManager.writeError("Error", (Object)this, "combining genes of different types");
            return result;
        }
        DungeonGene ba_other = (DungeonGene)other;
        boolean[] offspring1Array = new boolean[((boolean[])this.genotype).length];
        boolean[] offspring2Array = new boolean[((boolean[])this.genotype).length];
        if (((boolean[])this.genotype).length != ((boolean[])ba_other.genotype).length) {
            LogManager.writeError("Error", (Object)this, "recombining genes of different length");
            return null;
        }
        if (((boolean[])this.genotype).length == 0 || ((boolean[])ba_other.genotype).length == 0) {
            LogManager.writeError("Error", (Object)this, "one or more of the genes are empty");
            return null;
        }
        int crossoverPoints = 0;
        if (this.parameters.contains("crossoverPoints")) {
            crossoverPoints = this.parameters.getInteger("crossoverPoints");
        }
        if (crossoverPoints <= 0) {
            double chanceToCopyOther = 0.5;
            if (ba_other.getFitness() + this.fitness > 0.0) {
                chanceToCopyOther = ba_other.getFitness() / (ba_other.getFitness() + this.fitness);
            }
            for (int i = 0; i < offspring1Array.length; ++i) {
                if (RandomNumberManager.getRandomDouble() < chanceToCopyOther) {
                    offspring1Array[i] = ((boolean[])this.genotype)[i];
                    offspring2Array[i] = ((boolean[])ba_other.genotype)[i];
                    continue;
                }
                offspring1Array[i] = ((boolean[])ba_other.genotype)[i];
                offspring2Array[i] = ((boolean[])this.genotype)[i];
            }
        } else if (crossoverPoints > 0) {
            int[] crossoverLocations = new int[crossoverPoints];
            crossoverLocations[0] = RandomNumberManager.getRandomInt(1, (int)Math.floor(offspring1Array.length / 4) - crossoverPoints);
            for (int c = 1; c < crossoverPoints; ++c) {
                crossoverLocations[c] = RandomNumberManager.getRandomInt(crossoverLocations[c - 1], (int)Math.floor(offspring1Array.length / 4) - c);
            }
            int currCrossover = 0;
            for (int i = 0; i < offspring1Array.length; ++i) {
                if (currCrossover < crossoverLocations.length && i >= 4 * crossoverLocations[currCrossover]) {
                    ++currCrossover;
                }
                if (currCrossover % 2 == 0) {
                    offspring1Array[i] = ((boolean[])this.genotype)[i];
                    offspring2Array[i] = ((boolean[])ba_other.genotype)[i];
                    continue;
                }
                offspring1Array[i] = ((boolean[])ba_other.genotype)[i];
                offspring2Array[i] = ((boolean[])this.genotype)[i];
            }
        }
        DungeonGene offspring1 = new DungeonGene(offspring1Array, this.mapSizeX, this.mapSizeY, this.parameters);
        offspring1.repairGenotype();
        result.add(offspring1);
        DungeonGene offspring2 = new DungeonGene(offspring2Array, this.mapSizeX, this.mapSizeY, this.parameters);
        offspring2.repairGenotype();
        result.add(offspring2);
        return result;
    }

    int getIndex(int x, int y) {
        int index = x + y * this.mapSizeX;
        if (index < 0 || index * 4 >= ((boolean[])this.genotype).length || x >= this.mapSizeX || y >= this.mapSizeY) {
            LogManager.writeError("Error", (Object)this, "no index for x=" + x + ", y=" + y);
            return -1;
        }
        return index;
    }

    int getBit(int x, int y) {
        int index = this.getIndex(x, y);
        return index == -1 ? 0 : this.getBit(index);
    }

    int getBit(int index) {
        for (int b = 0; b < 4; ++b) {
            if (!((boolean[])this.genotype)[4 * index + b]) continue;
            return b;
        }
        return -1;
    }

    boolean isOccupied(int x, int y) {
        return this.getBit(x, y) != -1;
    }

    boolean isOccupied(int index) {
        return this.getBit(index) != -1;
    }

    boolean isImpassable(int index) {
        return this.getBit(index) == 0;
    }

    public DungeonGene mutate() {
        DungeonGene result = new DungeonGene((boolean[])this.genotype, this.mapSizeX, this.mapSizeY, this.parameters);
        int mutateTile = 0;
        int mutateExit = 0;
        int mutateMonster = 0;
        int mutateReward = 0;
        int mutateShift = 0;
        int mutateDiagonal = 0;
        int mutateTileMinNumber = 0;
        int mutateTileMaxNumber = 1;
        if (this.parameters.contains("mutateTile")) {
            mutateTile = this.parameters.getInteger("mutateTile");
        }
        if (this.parameters.contains("mutateExit")) {
            mutateExit = this.parameters.getInteger("mutateExit");
        }
        if (this.parameters.contains("mutateMonster")) {
            mutateMonster = this.parameters.getInteger("mutateMonster");
        }
        if (this.parameters.contains("mutateReward")) {
            mutateReward = this.parameters.getInteger("mutateReward");
        }
        if (this.parameters.contains("mutateShift")) {
            mutateShift = this.parameters.getInteger("mutateShift");
        }
        if (this.parameters.contains("mutateDiagonal")) {
            mutateDiagonal = this.parameters.getInteger("mutateDiagonal");
        }
        if (this.parameters.contains("mutateTileMinNumber")) {
            mutateTileMinNumber = this.parameters.getInteger("mutateTileMinNumber");
        }
        if (this.parameters.contains("mutateTileMaxNumber")) {
            mutateTileMaxNumber = this.parameters.getInteger("mutateTileMaxNumber");
        }
        int tileLength = (int)Math.floor(((boolean[])result.genotype).length / 4);
        if (RandomNumberManager.getRandomInt(0, 100) < mutateDiagonal) {
            for (int i = 0; i < tileLength / 2; ++i) {
                for (int b = 0; b < 4; ++b) {
                    boolean temp = ((boolean[])result.genotype)[4 * i + b];
                    ((boolean[])result.genotype)[4 * i + b] = ((boolean[])result.genotype)[((boolean[])result.genotype).length - 4 * (i + 1) + b];
                    ((boolean[])result.genotype)[((boolean[])result.genotype).length - 4 * (i + 1) + b] = temp;
                }
            }
        } else {
            int tries = 100000;
            Vector<Integer> mutatedIndexes = new Vector<Integer>();
            int bitsToMutate = RandomNumberManager.getRandomInt(mutateTileMinNumber, mutateTileMaxNumber);
            while (mutatedIndexes.size() < ((boolean[])result.genotype).length && mutatedIndexes.size() < bitsToMutate && tries > 0) {
                for (int i = 0; i < tileLength && mutatedIndexes.size() < bitsToMutate && mutatedIndexes.size() < ((boolean[])result.genotype).length && tries > 0; --tries, ++i) {
                    if (mutatedIndexes.contains(i)) continue;
                    if (RandomNumberManager.getRandomInt(0, 100) < mutateTile) {
                        if (this.isImpassable(i)) {
                            mutatedIndexes.add(i);
                            ((boolean[])result.genotype)[4 * i] = false;
                            for (int b = 1; b < 4; ++b) {
                                ((boolean[])result.genotype)[4 * i + b] = false;
                            }
                            continue;
                        }
                        if (this.isOccupied(i)) continue;
                        mutatedIndexes.add(i);
                        ((boolean[])result.genotype)[4 * i] = true;
                        for (int b = 1; b < 4; ++b) {
                            ((boolean[])result.genotype)[4 * i + b] = false;
                        }
                        continue;
                    }
                    if (RandomNumberManager.getRandomInt(0, 100) < mutateExit) {
                        if (this.isOccupied(i)) continue;
                        mutatedIndexes.add(i);
                        ((boolean[])result.genotype)[4 * i + 1] = true;
                        continue;
                    }
                    if (RandomNumberManager.getRandomInt(0, 100) < mutateMonster) {
                        if (this.isOccupied(i)) continue;
                        mutatedIndexes.add(i);
                        ((boolean[])result.genotype)[4 * i + 2] = true;
                        continue;
                    }
                    if (RandomNumberManager.getRandomInt(0, 100) < mutateReward) {
                        if (this.isOccupied(i)) continue;
                        mutatedIndexes.add(i);
                        ((boolean[])result.genotype)[4 * i + 3] = true;
                        continue;
                    }
                    if (RandomNumberManager.getRandomInt(0, 100) >= mutateShift) continue;
                    Vector<Integer> possibleDirections = new Vector<Integer>();
                    if (i % this.mapSizeX > 0) {
                        possibleDirections.add(-1);
                    }
                    if (i % this.mapSizeX < this.mapSizeX - 1) {
                        possibleDirections.add(1);
                    }
                    if (i > this.mapSizeX) {
                        possibleDirections.add(-this.mapSizeX);
                    }
                    if (i < tileLength - this.mapSizeX) {
                        possibleDirections.add(this.mapSizeX);
                    }
                    if (possibleDirections.isEmpty()) continue;
                    mutatedIndexes.add(i);
                    int direction = (Integer)possibleDirections.get(RandomNumberManager.getRandomInt(0, possibleDirections.size()));
                    for (int b = 0; b < 4; ++b) {
                        boolean temp = ((boolean[])result.genotype)[4 * i + b];
                        ((boolean[])result.genotype)[4 * i + b] = ((boolean[])result.genotype)[4 * (i + direction) + b];
                        ((boolean[])result.genotype)[4 * (i + direction) + b] = temp;
                    }
                }
            }
        }
        result.repairGenotype();
        return result;
    }

    public float getDifference(Gene other) {
        if (!(other instanceof DungeonGene)) {
            LogManager.writeError("Error", (Object)this, "comparing genes of different types");
            return 0.0f;
        }
        DungeonGene ba_other = (DungeonGene)other;
        if (((boolean[])this.genotype).length != ((boolean[])ba_other.genotype).length) {
            LogManager.writeError("Error", (Object)this, "comparing genes of different length");
            return 0.0f;
        }
        float result = 0.0f;
        for (int i = 0; i < ((boolean[])this.genotype).length; ++i) {
            if (((boolean[])this.genotype)[i] == ((boolean[])ba_other.genotype)[i]) continue;
            result += 1.0f;
        }
        return result;
    }

    public void repairGenotype() {
        this.repairGenotype(false);
    }

    public void repairGenotype(boolean initialValues) {
        if (!this.parameters.contains("repair") || this.parameters.getInteger("repair") == 0) {
            return;
        }
        boolean genotypeInteger = false;
        Vector<Integer> passable = new Vector<Integer>();
        for (int i = 0; i < ((boolean[])this.genotype).length; ++i) {
            if (i % 4 != 0 || ((boolean[])this.genotype)[i]) continue;
            passable.add(i / 4);
        }
        this.bindIndividual("Exits", 1, passable, initialValues);
        this.bindIndividual("Monsters", 2, passable, initialValues);
        this.bindIndividual("Rewards", 3, passable, initialValues);
    }

    void bindIndividual(String label, int bitOrder, Vector<Integer> passable, boolean initialValues) {
        Vector<Integer> items = new Vector<Integer>();
        for (int i = 0; i < ((boolean[])this.genotype).length; ++i) {
            if (i % 4 != bitOrder || !((boolean[])this.genotype)[i]) continue;
            items.add((i - bitOrder) / 4);
        }
        int genotypeMinValue = 0;
        int genotypeMaxValue = 0;
        if (initialValues && this.parameters.contains("genotypeMinInitial" + label)) {
            genotypeMinValue = this.parameters.getInteger("genotypeMinInitial" + label);
        }
        if (initialValues && this.parameters.contains("genotypeMaxInitial" + label)) {
            genotypeMaxValue = this.parameters.getInteger("genotypeMaxInitial" + label);
        }
        if (!(initialValues && this.parameters.contains("genotypeMinInitial" + label) || !this.parameters.contains("genotypeMin" + label))) {
            genotypeMinValue = this.parameters.getInteger("genotypeMin" + label);
        }
        if (!(initialValues && this.parameters.contains("genotypeMaxInitial" + label) || !this.parameters.contains("genotypeMax" + label))) {
            genotypeMaxValue = this.parameters.getInteger("genotypeMax" + label);
        }
        while (items.size() > genotypeMaxValue) {
            int roll = RandomNumberManager.getRandomInt(0, items.size());
            int rndTile = (Integer)items.get(roll);
            ((boolean[])this.genotype)[4 * rndTile + bitOrder] = false;
            items.removeElementAt(roll);
        }
        while (items.size() < genotypeMinValue) {
            int rndTile = RandomNumberManager.getRandomInt(0, (int)Math.floor((float)((boolean[])this.genotype).length / 4.0f));
            if (!passable.isEmpty()) {
                int roll = RandomNumberManager.getRandomInt(0, passable.size());
                rndTile = passable.get(roll);
                passable.removeElement(roll);
            }
            boolean occupied = false;
            for (int i = 1; i < 4; ++i) {
                occupied = occupied || ((boolean[])this.genotype)[4 * rndTile + i];
            }
            if (occupied) continue;
            ((boolean[])this.genotype)[4 * rndTile] = false;
            ((boolean[])this.genotype)[4 * rndTile + bitOrder] = true;
            items.add(rndTile);
        }
    }

    public boolean[] getGenotype() {
        boolean[] result = new boolean[((boolean[])this.genotype).length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = ((boolean[])this.genotype)[i];
        }
        return result;
    }
}

