/*
 * Decompiled with CFR 0.152.
 */
package dungeon.genetic;

import dungeon.Dungeon;
import dungeon.genetic.DungeonGene;
import util.collections.ParameterCollection;

public class DungeonGeneConverter {
    static final int tileBits = 4;

    public static DungeonGene getGene(Dungeon sketch, ParameterCollection gaParams) {
        int tileIndex;
        int i;
        boolean[] alleles = new boolean[4 * sketch.getMapSizeX() * sketch.getMapSizeY()];
        for (int x = 0; x < sketch.getMapSizeX(); ++x) {
            for (int y = 0; y < sketch.getMapSizeY(); ++y) {
                int tileIndex2 = (x + y * sketch.getMapSizeX()) * 4;
                alleles[tileIndex2] = !sketch.isPassable(x, y);
                for (int b = 1; b < 4; ++b) {
                    alleles[tileIndex2 + b] = false;
                }
            }
        }
        for (i = 0; i < sketch.getExitLength(); ++i) {
            tileIndex = ((int)sketch.getExit((int)i).x + (int)sketch.getExit((int)i).y * sketch.getMapSizeX()) * 4;
            alleles[tileIndex + 1] = true;
        }
        for (i = 0; i < sketch.getMonsterLength(); ++i) {
            tileIndex = ((int)sketch.getMonster((int)i).x + (int)sketch.getMonster((int)i).y * sketch.getMapSizeX()) * 4;
            alleles[tileIndex + 2] = true;
        }
        for (i = 0; i < sketch.getRewardLength(); ++i) {
            tileIndex = ((int)sketch.getReward((int)i).x + (int)sketch.getReward((int)i).y * sketch.getMapSizeX()) * 4;
            alleles[tileIndex + 3] = true;
        }
        return new DungeonGene(alleles, sketch.getMapSizeX(), sketch.getMapSizeY(), gaParams);
    }
}

