/*
 * Decompiled with CFR 0.152.
 */
package dungeon.genetic;

import dungeon.Dungeon;
import dungeon.genetic.DungeonEmbryogeny;
import dungeon.genetic.DungeonGene;
import dungeon.genetic.DungeonGeneConverter;
import dungeon.genetic.DungeonGeneticAlgorithm;
import dungeon.genetic.fitness.DungeonDifferenceFitness;
import dungeon.genetic.fitness.FeasibleFitness;
import dungeon.genetic.fitness.InfeasibleFitness;
import genetic.Embryogeny;
import genetic.FI2PopTrainer;
import genetic.GeneticAlgorithm;
import genetic.GeneticAlgorithmTrainer;
import genetic.GeneticAlgorithmTrainerGeneric;
import genetic.NoveltyTrainer;
import genetic.fitness.DifferenceFitness;
import genetic.fitness.Fitness;
import java.util.Vector;
import util.collections.ParameterCollection;

public class DungeonSuggestions {
    ParameterCollection gaParameters;
    Vector<Dungeon> suggestions = new Vector();
    Vector<String> suggestionLabels = new Vector();
    Vector<FI2PopTrainer> gaTrainers;
    Vector<Thread> gaThreads;
    int defaultMinExits;
    int defaultMaxExits;
    int defaultMinMonsters;
    int defaultMaxMonsters;
    int defaultMinRewards;
    int defaultMaxRewards;
    DungeonSuggestionsPreparation prep;
    Dungeon baseMap;
    Thread prepThread;

    public void initParameters(int mapSizeX, int mapSizeY, int minExits, int maxExits, int minMonsters, int maxMonsters, int minRewards, int maxRewards) {
        this.defaultMinExits = minExits;
        this.defaultMaxExits = maxExits;
        this.defaultMinMonsters = minMonsters;
        this.defaultMaxMonsters = maxMonsters;
        this.defaultMinRewards = minRewards;
        this.defaultMaxRewards = maxRewards;
        this.gaParameters = new ParameterCollection("./resources/parameters/dungeonSuggestions.xml");
        this.gaParameters.setParameter("mapSizeX", mapSizeX);
        this.gaParameters.setParameter("mapSizeY", mapSizeY);
        this.gaParameters.setParameter("genotypeMinMonsters", minMonsters);
        this.gaParameters.setParameter("genotypeMaxMonsters", maxMonsters);
        this.gaParameters.setParameter("genotypeMinRewards", minRewards);
        this.gaParameters.setParameter("genotypeMaxRewards", maxRewards);
        this.gaParameters.setParameter("genotypeMinExits", minExits);
        this.gaParameters.setParameter("genotypeMaxExits", maxExits);
        this.gaParameters.setParameter("mutateTileMinNumber", mapSizeX * mapSizeY / 20);
        this.gaParameters.setParameter("mutateTileMaxNumber", mapSizeX * mapSizeY / 5);
    }

    public void customizeParameters(int userExits, int userMonsters, int userRewards) {
        if (this.gaThreads != null || this.prepThread != null) {
            return;
        }
        this.gaParameters.setParameter("genotypeMaxMonsters", Math.max(userMonsters, this.defaultMaxMonsters));
        this.gaParameters.setParameter("genotypeMaxRewards", Math.max(userRewards, this.defaultMaxRewards));
        this.gaParameters.setParameter("genotypeMaxExits", Math.max(userExits, this.defaultMaxExits));
    }

    public Dungeon getSuggestion(int index) {
        return this.suggestions.get(index);
    }

    public Vector<Dungeon> getSuggestions() {
        return this.suggestions;
    }

    public String getSuggestionLabel(int index) {
        return this.suggestionLabels.get(index);
    }

    public Vector<String> getSuggestionLabels() {
        return this.suggestionLabels;
    }

    public double[] getFitnesses(int index) {
        double[] result = new double[FeasibleFitness.labels.length];
        for (int j = 0; j < result.length; ++j) {
            FeasibleFitness fn = new FeasibleFitness(j);
            result[j] = fn.evaluate(this.suggestions.get(index));
        }
        return result;
    }

    public Vector<double[]> getFitnesses() {
        Vector<double[]> result = new Vector<double[]>();
        for (int i = 0; i < this.suggestions.size(); ++i) {
            result.add(this.getFitnesses(i));
        }
        return result;
    }

    public int size() {
        return this.suggestions == null ? 0 : this.suggestions.size();
    }

    public void clearSuggestions() {
        this.suggestions.clear();
    }

    public void createSuggestions(Dungeon baseMap, int suggestionsNumber) {
        DungeonGene baseGene = DungeonGeneConverter.getGene(baseMap, this.gaParameters);
        InfeasibleFitness ifn = new InfeasibleFitness(this.gaParameters.getInteger("genotypeMinExits"), this.gaParameters.getInteger("genotypeMaxExits"), this.gaParameters.getInteger("genotypeMinMonsters"), this.gaParameters.getInteger("genotypeMaxMonsters"), this.gaParameters.getInteger("genotypeMinRewards"), this.gaParameters.getInteger("genotypeMaxRewards"));
        DungeonEmbryogeny de = new DungeonEmbryogeny(baseMap.getMapSizeX(), baseMap.getMapSizeY());
        while (this.suggestions.size() < suggestionsNumber) {
            DungeonGene initialGene = baseGene.clone();
            Dungeon phenotype = de.createPhenotype((initialGene = initialGene.mutate()).getGenotype());
            if (ifn.evaluate(phenotype) != 0.0) continue;
            this.suggestions.add(phenotype);
        }
    }

    public void initNoveltyTraining(Dungeon baseMap) {
        if (this.gaThreads != null || this.prepThread != null) {
            return;
        }
        this.baseMap = baseMap;
        this.prep = new DungeonNoveltyPreparation(baseMap, this.gaParameters);
        this.prepThread = new Thread(this.prep);
        this.prepThread.start();
    }

    public void initFitnessTraining(Dungeon baseMap) {
        if (this.gaThreads != null || this.prepThread != null) {
            return;
        }
        this.baseMap = baseMap;
        this.prep = new DungeonFitnessPreparation(baseMap, this.gaParameters);
        this.prepThread = new Thread(this.prep);
        this.prepThread.start();
    }

    public void initCompositeTraining(Dungeon baseMap) {
        if (this.gaThreads != null || this.prepThread != null) {
            return;
        }
        this.baseMap = baseMap;
        this.prep = new DungeonCompositePreparation(baseMap, this.gaParameters);
        this.prepThread = new Thread(this.prep);
        this.prepThread.start();
    }

    public void interruptTraining() {
        if (this.prepThread != null && this.prepThread.isAlive()) {
            this.prepThread.interrupt();
            this.prepThread = null;
        }
        if (this.gaThreads != null) {
            for (int i = 0; i < this.gaThreads.size(); ++i) {
                if (this.gaThreads.get(i) == null || !this.gaThreads.get(i).isAlive()) continue;
                this.gaThreads.get(i).interrupt();
            }
            this.gaThreads = null;
        }
    }

    public boolean isTraining() {
        return this.prepThread != null || this.gaThreads != null;
    }

    public boolean updateTraining() {
        if (this.prepThread != null && !this.prepThread.isAlive()) {
            int i;
            this.gaTrainers = this.prep.getTrainers();
            this.gaThreads = new Vector();
            for (i = 0; i < this.gaTrainers.size(); ++i) {
                this.gaThreads.add(new Thread((Runnable)this.gaTrainers.get(i)));
            }
            for (i = 0; i < this.gaThreads.size(); ++i) {
                this.gaThreads.get(i).start();
            }
            this.prepThread = null;
        }
        if (this.gaThreads != null) {
            int completedThreads = 0;
            for (int i = 0; i < this.gaThreads.size(); ++i) {
                if (this.gaThreads.get(i) == null || this.gaThreads.get(i).isAlive()) continue;
                ++completedThreads;
            }
            if (completedThreads > 0 && completedThreads == this.gaThreads.size()) {
                this.suggestions.clear();
                for (int j = 0; j < this.gaThreads.size(); ++j) {
                    if (this.gaTrainers.get(j).getBestFeasibleIndividual() == null) continue;
                    if (this.gaTrainers.get(j).getFeasibleTrainer() instanceof NoveltyTrainer) {
                        int shownMaps = this.gaThreads.size() == 1 ? 12 : 6;
                        Vector maps = this.gaTrainers.get(j).getBestFeasiblePhenotypes(shownMaps);
                        for (int i = 0; i < maps.size(); ++i) {
                            Dungeon temp = (Dungeon)maps.get(i);
                            if (this.baseMap.getTileDifference(temp) <= 0) continue;
                            boolean addMap = true;
                            for (Dungeon s : this.suggestions) {
                                if (s.getTileDifference(temp) != 0) continue;
                                addMap = false;
                                break;
                            }
                            if (!addMap) continue;
                            this.suggestions.add(temp);
                            this.suggestionLabels.add("noveltySearch");
                        }
                        continue;
                    }
                    if (this.gaTrainers.get(j).getFeasibleTrainer() instanceof GeneticAlgorithmTrainer) {
                        Dungeon temp = (Dungeon)this.gaTrainers.get(j).getBestFeasibleIndividual().getPhenotype();
                        if (this.baseMap.getTileDifference(temp) <= 0) continue;
                        boolean addMap = true;
                        for (Dungeon s : this.suggestions) {
                            if (s.getTileDifference(temp) != 0) continue;
                            addMap = false;
                            break;
                        }
                        if (!addMap) continue;
                        this.suggestions.add(temp);
                        this.suggestionLabels.add(((GeneticAlgorithmTrainer)this.gaTrainers.get(j).getFeasibleTrainer()).getFitnessFunction().getLabel());
                        continue;
                    }
                    Dungeon temp = (Dungeon)this.gaTrainers.get(j).getBestFeasibleIndividual().getPhenotype();
                    if (this.baseMap.getTileDifference(temp) <= 0) continue;
                    boolean addMap = true;
                    for (Dungeon s : this.suggestions) {
                        if (s.getTileDifference(temp) != 0) continue;
                        addMap = false;
                        break;
                    }
                    if (!addMap) continue;
                    this.suggestions.add(temp);
                    this.suggestionLabels.add("unknown");
                }
                this.gaThreads = null;
                return true;
            }
        }
        return false;
    }

    class DungeonNoveltyPreparation
    extends DungeonSuggestionsPreparation {
        public DungeonNoveltyPreparation(Dungeon baseMap, ParameterCollection gaParameters) {
            super(baseMap, gaParameters);
        }

        @Override
        public void run() {
            if (DungeonSuggestions.this.gaThreads != null) {
                return;
            }
            InfeasibleFitness ifn = new InfeasibleFitness(this.gaParameters.getInteger("genotypeMinExits"), this.gaParameters.getInteger("genotypeMaxExits"), this.gaParameters.getInteger("genotypeMinMonsters"), this.gaParameters.getInteger("genotypeMaxMonsters"), this.gaParameters.getInteger("genotypeMinRewards"), this.gaParameters.getInteger("genotypeMaxRewards"));
            DungeonEmbryogeny de = new DungeonEmbryogeny(this.gaParameters.getInteger("mapSizeX"), this.gaParameters.getInteger("mapSizeY"));
            DungeonGene baseGene = DungeonGeneConverter.getGene(this.baseMap, this.gaParameters);
            DungeonDifferenceFitness dfn = new DungeonDifferenceFitness();
            int populationSize = this.gaParameters.getInteger("population");
            Vector<DungeonGene> population_1 = new Vector<DungeonGene>();
            for (int j = 0; j < populationSize; ++j) {
                DungeonGene initialGene = baseGene.clone();
                population_1.add(initialGene.mutate());
            }
            Vector<DungeonGene> population_2 = new Vector<DungeonGene>();
            for (int j = 0; j < populationSize; ++j) {
                DungeonGene initialGene = baseGene.clone();
                population_2.add(initialGene.mutate());
            }
            DungeonGeneticAlgorithm ga = new DungeonGeneticAlgorithm(this.gaParameters);
            ga.initializePopulation();
            ga.replacePopulation(population_1);
            DungeonGeneticAlgorithm iga = new DungeonGeneticAlgorithm(this.gaParameters);
            iga.initializePopulation();
            iga.replacePopulation(population_2);
            NoveltyTrainer fgaTrainer = new NoveltyTrainer((DifferenceFitness)dfn, (Embryogeny)de, (GeneticAlgorithm)ga, this.gaParameters);
            GeneticAlgorithmTrainer igaTrainer = new GeneticAlgorithmTrainer((Fitness)ifn, (Embryogeny)de, (GeneticAlgorithm)iga, this.gaParameters);
            DungeonSuggestions.this.gaThreads = new Vector();
            this.gaTrainers = new Vector();
            FI2PopTrainer trainer = new FI2PopTrainer((Fitness)ifn, (GeneticAlgorithmTrainerGeneric)fgaTrainer, (GeneticAlgorithmTrainerGeneric)igaTrainer, this.gaParameters);
            trainer.shufflePopulations();
            this.gaTrainers.add(trainer);
        }
    }

    class DungeonFitnessPreparation
    extends DungeonSuggestionsPreparation {
        public DungeonFitnessPreparation(Dungeon baseMap, ParameterCollection gaParameters) {
            super(baseMap, gaParameters);
        }

        @Override
        public void run() {
            if (DungeonSuggestions.this.gaThreads != null) {
                return;
            }
            InfeasibleFitness ifn = new InfeasibleFitness(this.gaParameters.getInteger("genotypeMinExits"), this.gaParameters.getInteger("genotypeMaxExits"), this.gaParameters.getInteger("genotypeMinMonsters"), this.gaParameters.getInteger("genotypeMaxMonsters"), this.gaParameters.getInteger("genotypeMinRewards"), this.gaParameters.getInteger("genotypeMaxRewards"));
            Vector<FeasibleFitness> sfn = new Vector<FeasibleFitness>();
            for (int i = 0; i < 6; ++i) {
                sfn.add(new FeasibleFitness(i));
            }
            DungeonEmbryogeny de = new DungeonEmbryogeny(this.gaParameters.getInteger("mapSizeX"), this.gaParameters.getInteger("mapSizeY"));
            DungeonSuggestions.this.gaThreads = new Vector();
            this.gaTrainers = new Vector();
            DungeonGene baseGene = DungeonGeneConverter.getGene(this.baseMap, this.gaParameters);
            for (int i = 0; i < sfn.size(); ++i) {
                int populationSize = this.gaParameters.getInteger("population");
                Vector<DungeonGene> population_1 = new Vector<DungeonGene>();
                for (int j = 0; j < populationSize; ++j) {
                    DungeonGene initialGene = baseGene.clone();
                    population_1.add(initialGene.mutate());
                }
                Vector<DungeonGene> population_2 = new Vector<DungeonGene>();
                for (int j = 0; j < populationSize; ++j) {
                    DungeonGene initialGene = baseGene.clone();
                    population_2.add(initialGene.mutate());
                }
                DungeonGeneticAlgorithm ga = new DungeonGeneticAlgorithm(this.gaParameters);
                ga.initializePopulation();
                ga.replacePopulation(population_1);
                DungeonGeneticAlgorithm iga = new DungeonGeneticAlgorithm(this.gaParameters);
                iga.initializePopulation();
                iga.replacePopulation(population_2);
                FI2PopTrainer trainer = new FI2PopTrainer((Fitness)sfn.get(i), (Fitness)ifn, (Embryogeny)de, (GeneticAlgorithm)ga, (GeneticAlgorithm)iga, this.gaParameters);
                trainer.shufflePopulations();
                this.gaTrainers.add(trainer);
            }
        }
    }

    class DungeonCompositePreparation
    extends DungeonSuggestionsPreparation {
        public DungeonCompositePreparation(Dungeon baseMap, ParameterCollection gaParameters) {
            super(baseMap, gaParameters);
        }

        @Override
        public void run() {
            DungeonGeneticAlgorithm iga;
            DungeonGene initialGene;
            DungeonGene initialGene2;
            Vector<DungeonGene> population_1;
            int populationSize;
            if (DungeonSuggestions.this.gaThreads != null) {
                return;
            }
            InfeasibleFitness ifn = new InfeasibleFitness(this.gaParameters.getInteger("genotypeMinExits"), this.gaParameters.getInteger("genotypeMaxExits"), this.gaParameters.getInteger("genotypeMinMonsters"), this.gaParameters.getInteger("genotypeMaxMonsters"), this.gaParameters.getInteger("genotypeMinRewards"), this.gaParameters.getInteger("genotypeMaxRewards"));
            Vector<FeasibleFitness> sfn = new Vector<FeasibleFitness>();
            for (int i = 0; i < FeasibleFitness.labels.length; ++i) {
                sfn.add(new FeasibleFitness(i));
            }
            DungeonEmbryogeny de = new DungeonEmbryogeny(this.gaParameters.getInteger("mapSizeX"), this.gaParameters.getInteger("mapSizeY"));
            DungeonSuggestions.this.gaThreads = new Vector();
            this.gaTrainers = new Vector();
            DungeonGene baseGene = DungeonGeneConverter.getGene(this.baseMap, this.gaParameters);
            for (int i = 0; i < sfn.size(); ++i) {
                populationSize = this.gaParameters.getInteger("population");
                population_1 = new Vector<DungeonGene>();
                for (int j = 0; j < populationSize; ++j) {
                    initialGene2 = baseGene.clone();
                    population_1.add(initialGene2.mutate());
                }
                Vector<DungeonGene> population_2 = new Vector<DungeonGene>();
                for (int j = 0; j < populationSize; ++j) {
                    initialGene = baseGene.clone();
                    population_2.add(initialGene.mutate());
                }
                DungeonGeneticAlgorithm ga = new DungeonGeneticAlgorithm(this.gaParameters);
                ga.initializePopulation();
                ga.replacePopulation(population_1);
                iga = new DungeonGeneticAlgorithm(this.gaParameters);
                iga.initializePopulation();
                iga.replacePopulation(population_2);
                FI2PopTrainer trainer = new FI2PopTrainer((Fitness)sfn.get(i), (Fitness)ifn, (Embryogeny)de, (GeneticAlgorithm)ga, (GeneticAlgorithm)iga, this.gaParameters);
                trainer.shufflePopulations();
                this.gaTrainers.add(trainer);
            }
            DungeonDifferenceFitness dfn = new DungeonDifferenceFitness();
            populationSize = this.gaParameters.getInteger("population");
            population_1 = new Vector();
            for (int j = 0; j < populationSize; ++j) {
                initialGene2 = baseGene.clone();
                population_1.add(initialGene2.mutate());
            }
            Vector<DungeonGene> population_2 = new Vector<DungeonGene>();
            for (int j = 0; j < populationSize; ++j) {
                initialGene = baseGene.clone();
                population_2.add(initialGene.mutate());
            }
            DungeonGeneticAlgorithm ga = new DungeonGeneticAlgorithm(this.gaParameters);
            ga.initializePopulation();
            ga.replacePopulation(population_1);
            iga = new DungeonGeneticAlgorithm(this.gaParameters);
            iga.initializePopulation();
            iga.replacePopulation(population_2);
            NoveltyTrainer fgaTrainer = new NoveltyTrainer((DifferenceFitness)dfn, (Embryogeny)de, (GeneticAlgorithm)ga, this.gaParameters);
            GeneticAlgorithmTrainer igaTrainer = new GeneticAlgorithmTrainer((Fitness)ifn, (Embryogeny)de, (GeneticAlgorithm)iga, this.gaParameters);
            FI2PopTrainer trainer = new FI2PopTrainer((Fitness)ifn, (GeneticAlgorithmTrainerGeneric)fgaTrainer, (GeneticAlgorithmTrainerGeneric)igaTrainer, this.gaParameters);
            trainer.shufflePopulations();
            this.gaTrainers.add(trainer);
        }
    }

    abstract class DungeonSuggestionsPreparation
    implements Runnable {
        Dungeon baseMap;
        ParameterCollection gaParameters;
        Vector<FI2PopTrainer> gaTrainers;

        public DungeonSuggestionsPreparation(Dungeon baseMap, ParameterCollection gaParameters) {
            this.baseMap = baseMap;
            this.gaParameters = gaParameters;
        }

        public Vector<FI2PopTrainer> getTrainers() {
            return this.gaTrainers;
        }
    }
}

