/*
 * Decompiled with CFR 0.152.
 */
package dungeon.genetic.fitness;

import dungeon.Dungeon;
import genetic.fitness.Fitness;
import genetic.fitness.WeightedFitness;
import java.util.Arrays;
import java.util.Vector;
import util.image.processing.Thresholding;
import util.math2d.Matrix2D;
import util.math2d.Point2D;
import util.statics.LogManager;

public class FeasibleFitness
extends WeightedFitness {
    public float minSafety = 0.35f;
    public static final String[] labels = new String[]{"Reward Ownership", "Area Control", "Exploration", "Reward Ownership Fairness", "Area Control Fairness", "Exploration Fairness"};

    public FeasibleFitness() {
        this.add(1.0, new RewardOwnershipFitness());
        this.add(1.0, new AreaControlFitness());
        this.add(1.0, new ExplorationFitness());
        this.add(1.0, new RewardOwnershipFairnessFitness());
        this.add(1.0, new AreaControlFairnessFitness());
        this.add(1.0, new ExplorationFairnessFitness());
    }

    public FeasibleFitness(double w_resOwn, double w_resOwnFairness, double w_areaControl, double w_areaControlFairness, double w_exploration, double w_explorationFairness) {
        if (w_resOwn != 0.0) {
            this.add(w_resOwn, new RewardOwnershipFitness());
        }
        if (w_areaControl != 0.0) {
            this.add(w_areaControl, new AreaControlFitness());
        }
        if (w_exploration != 0.0) {
            this.add(w_exploration, new ExplorationFitness());
        }
        if (w_resOwnFairness != 0.0) {
            this.add(w_resOwnFairness, new RewardOwnershipFairnessFitness());
        }
        if (w_areaControlFairness != 0.0) {
            this.add(w_areaControlFairness, new AreaControlFairnessFitness());
        }
        if (w_explorationFairness != 0.0) {
            this.add(w_explorationFairness, new ExplorationFairnessFitness());
        }
    }

    public FeasibleFitness(int index) {
        this(index, true);
    }

    public FeasibleFitness(int index, boolean positive) {
        double w;
        double d = w = positive ? 1.0 : -1.0;
        if (index == 0) {
            this.add(w, new RewardOwnershipFitness());
        } else if (index == 1) {
            this.add(w, new AreaControlFitness());
        } else if (index == 2) {
            this.add(w, new ExplorationFitness());
        } else if (index == 3) {
            this.add(w, new RewardOwnershipFairnessFitness());
        } else if (index == 4) {
            this.add(w, new AreaControlFairnessFitness());
        } else if (index == 5) {
            this.add(w, new ExplorationFairnessFitness());
        } else {
            LogManager.writeError("Error", (Object)this, "Feasible fitness " + index + " doesn't exist");
        }
        if (positive) {
            this.setLabel(labels[index]);
        } else {
            this.setLabel("inv_" + labels[index]);
        }
    }

    public FeasibleFitness(double w_resOwn, double w_resOwnFairness, double w_areaControl, double w_areaControlFairness, double w_exploration, double w_explorationFairness, double w_explorationRew, double w_explorationRewFairness) {
        if (w_resOwn != 0.0) {
            this.add(w_resOwn, new RewardOwnershipFitness());
        }
        if (w_areaControl != 0.0) {
            this.add(w_areaControl, new AreaControlFitness());
        }
        if (w_exploration != 0.0) {
            this.add(w_exploration, new ExplorationFitness());
        }
        if (w_resOwnFairness != 0.0) {
            this.add(w_resOwnFairness, new RewardOwnershipFairnessFitness());
        }
        if (w_areaControlFairness != 0.0) {
            this.add(w_areaControlFairness, new AreaControlFairnessFitness());
        }
        if (w_explorationFairness != 0.0) {
            this.add(w_explorationFairness, new ExplorationFairnessFitness());
        }
        if (w_explorationRew != 0.0) {
            this.add(w_explorationRew, new ExplorationRewardsFitness());
        }
        if (w_explorationRewFairness != 0.0) {
            this.add(w_explorationRewFairness, new ExplorationRewardsFairnessFitness());
        }
    }

    class ExplorationFairnessFitness
    extends Fitness<Dungeon> {
        public ExplorationFairnessFitness() {
            this.label = "Exploration Fairness";
        }

        public double evaluateSpecific(Dungeon phenotype) {
            if (phenotype.getExitLength() < 2) {
                return -1.0;
            }
            if (phenotype.getPaths().getExitPaths().size() < phenotype.getExitLength() * (phenotype.getExitLength() - 1) / 2) {
                return -1.0;
            }
            double result = 0.0;
            float[] baseExplorations = new float[phenotype.getExitLength()];
            for (int i = 0; i < phenotype.getExitLength(); ++i) {
                baseExplorations[i] = Matrix2D.count(phenotype.getPaths().getExplorationMatrix(i));
            }
            int comparisons = 0;
            for (int i = 0; i < baseExplorations.length; ++i) {
                for (int j = 0; j < baseExplorations.length; ++j) {
                    if (i == j) continue;
                    result += (double)Math.abs(baseExplorations[i] - baseExplorations[j]) / (double)Math.max(baseExplorations[i], baseExplorations[j]);
                    ++comparisons;
                }
            }
            return 1.0 - (result /= (double)comparisons);
        }
    }

    class AreaControlFairnessFitness
    extends Fitness<Dungeon> {
        public AreaControlFairnessFitness() {
            this.label = "Area Control Fairness";
        }

        public double evaluateSpecific(Dungeon phenotype) {
            if (phenotype.getExitLength() + phenotype.getMonsterLength() < 2) {
                return -1.0;
            }
            if (phenotype.getPaths().getExitPathLength() < phenotype.getExitLength() * (phenotype.getExitLength() - 1) / 2) {
                return -1.0;
            }
            double result = 0.0;
            int totalPassable = phenotype.getMapSizeX() * phenotype.getMapSizeY() - Matrix2D.count(phenotype.getImpassableArray());
            double[] baseAreas = new double[phenotype.getExitLength() + phenotype.getMonsterLength()];
            for (int i = 0; i < phenotype.getExitLength() + phenotype.getMonsterLength(); ++i) {
                baseAreas[i] = Matrix2D.count(Thresholding.getArrayAboveValue(phenotype.getPaths().getSafetyMatrix(i), FeasibleFitness.this.minSafety));
            }
            int comparisons = 0;
            for (int i = 0; i < baseAreas.length; ++i) {
                for (int j = 0; j < baseAreas.length; ++j) {
                    if (i == j) continue;
                    result += Math.abs(baseAreas[i] - baseAreas[j]) / Math.max(baseAreas[i], baseAreas[j]);
                    ++comparisons;
                }
            }
            return 1.0 - (result /= (double)comparisons);
        }
    }

    class RewardOwnershipFairnessFitness
    extends Fitness<Dungeon> {
        public RewardOwnershipFairnessFitness() {
            this.label = "Reward Ownership Fairness";
        }

        public double evaluateSpecific(Dungeon phenotype) {
            if (phenotype.getMonsterLength() < 2 || phenotype.getRewardLength() == 0) {
                return -1.0;
            }
            double result = 0.0;
            float[] avgSafety = new float[phenotype.getMonsterLength()];
            for (int i = 0; i < phenotype.getRewardLength(); ++i) {
                int j = 0;
                while (j < phenotype.getMonsterLength()) {
                    float safety = phenotype.getPaths().getRewardSafety(i)[j];
                    if (safety == -1.0f) {
                        return -1.0;
                    }
                    int n = j++;
                    avgSafety[n] = avgSafety[n] + safety;
                }
            }
            for (int j = 0; j < phenotype.getMonsterLength(); ++j) {
                for (int k = j + 1; k < phenotype.getMonsterLength(); ++k) {
                    result += (double)Math.abs(avgSafety[j] - avgSafety[k]);
                }
            }
            return 1.0 - (result /= (double)((phenotype.getMonsterLength() - 1) * phenotype.getRewardLength()));
        }
    }

    class ExplorationRewardsFairnessFitness
    extends Fitness<Dungeon> {
        public ExplorationRewardsFairnessFitness() {
            this.label = "ExplorationRewards Fairness";
        }

        public double evaluateSpecific(Dungeon phenotype) {
            int i;
            int totalTiles = phenotype.getExitLength() + phenotype.getRewardLength();
            if (totalTiles < 2) {
                return -1.0;
            }
            double result = 0.0;
            float[] explorationAreas = new float[totalTiles];
            Vector<Point2D> refTiles = new Vector<Point2D>();
            for (i = 0; i < phenotype.getExitLength(); ++i) {
                refTiles.add(phenotype.getExit(i));
            }
            for (i = 0; i < phenotype.getRewardLength(); ++i) {
                refTiles.add(phenotype.getReward(i));
            }
            float[][][] explorationMatrix = phenotype.getPaths().calculateCustomExplorationMatrix(refTiles);
            int comparisons = 0;
            for (int i2 = 0; i2 < totalTiles; ++i2) {
                float exploration_i = Matrix2D.count(explorationMatrix[i2]);
                for (int j = 0; j < totalTiles; ++j) {
                    if (i2 == j) continue;
                    float exploration_j = Matrix2D.count(explorationMatrix[i2]);
                    result += (double)Math.abs(exploration_i - exploration_j) / (double)Math.max(exploration_i, exploration_j);
                    ++comparisons;
                }
            }
            return 1.0 - (result /= (double)comparisons);
        }
    }

    class ExplorationRewardsFitness
    extends Fitness<Dungeon> {
        public ExplorationRewardsFitness() {
            this.label = "ExplorationRewards";
        }

        public double evaluateSpecific(Dungeon phenotype) {
            int i;
            Vector<Point2D> refTiles = new Vector<Point2D>();
            for (i = 0; i < phenotype.getExitLength(); ++i) {
                refTiles.add(phenotype.getExit(i));
            }
            for (i = 0; i < phenotype.getRewardLength(); ++i) {
                refTiles.add(phenotype.getReward(i));
            }
            if (refTiles.size() < 2) {
                return -1.0;
            }
            double result = 0.0;
            int totalPassable = phenotype.getMapSizeX() * phenotype.getMapSizeY() - Matrix2D.count(phenotype.getImpassableArray());
            float[] explorationAreas = new float[refTiles.size()];
            float[][][] explorationMatrix = phenotype.getPaths().calculateCustomExplorationMatrix(refTiles);
            for (int i2 = 0; i2 < refTiles.size(); ++i2) {
                explorationAreas[i2] = Matrix2D.count(explorationMatrix[i2]);
                result += (double)explorationAreas[i2] / (double)totalPassable;
            }
            return result /= (double)refTiles.size();
        }
    }

    class ExplorationFitness
    extends Fitness<Dungeon> {
        public ExplorationFitness() {
            this.label = "Exploration";
        }

        public double evaluateSpecific(Dungeon phenotype) {
            if (phenotype.getExitLength() < 2) {
                return -1.0;
            }
            if (phenotype.getPaths().getExitPaths().size() < phenotype.getExitLength() * (phenotype.getExitLength() - 1) / 2) {
                return -1.0;
            }
            double result = 0.0;
            int totalPassable = phenotype.getMapSizeX() * phenotype.getMapSizeY() - Matrix2D.count(phenotype.getImpassableArray());
            float[] explorationAreas = new float[phenotype.getExitLength()];
            for (int i = 0; i < phenotype.getExitLength(); ++i) {
                explorationAreas[i] = Matrix2D.count(phenotype.getPaths().getExplorationMatrix(i));
                result += (double)explorationAreas[i] / (double)totalPassable;
            }
            return result /= (double)phenotype.getExitLength();
        }
    }

    class AreaControlFitness
    extends Fitness<Dungeon> {
        public AreaControlFitness() {
            this.label = "Area Control";
        }

        public double evaluateSpecific(Dungeon phenotype) {
            if (phenotype.getExitLength() + phenotype.getMonsterLength() < 2) {
                return -1.0;
            }
            if (phenotype.getPaths().getExitPathLength() < phenotype.getExitLength() * (phenotype.getExitLength() - 1) / 2) {
                return -1.0;
            }
            if (phenotype.getPaths().getExit_monsterPathLength() < (phenotype.getExitLength() - 1) * phenotype.getMonsterLength()) {
                return -1.0;
            }
            double result = 0.0;
            int totalPassable = phenotype.getMapSizeX() * phenotype.getMapSizeY() - Matrix2D.count(phenotype.getImpassableArray());
            int[] baseAreas = new int[phenotype.getExitLength() + phenotype.getMonsterLength()];
            for (int i = 0; i < phenotype.getExitLength() + phenotype.getMonsterLength(); ++i) {
                baseAreas[i] = Matrix2D.count(Thresholding.getArrayAboveValue(phenotype.getPaths().getSafetyMatrix(i), FeasibleFitness.this.minSafety));
                result += (double)baseAreas[i];
            }
            return result /= (double)totalPassable;
        }
    }

    class RewardOwnershipFitness
    extends Fitness<Dungeon> {
        public RewardOwnershipFitness() {
            this.label = "Reward Ownership";
        }

        public double evaluateSpecific(Dungeon phenotype) {
            if (phenotype.getMonsterLength() < 2 || phenotype.getRewardLength() == 0) {
                return -1.0;
            }
            double result = 0.0;
            for (int i = 0; i < phenotype.getRewardLength(); ++i) {
                float[] safetyPerBase = phenotype.getPaths().getRewardSafety(i);
                float[] sortedSafety = Arrays.copyOf(safetyPerBase, safetyPerBase.length);
                Arrays.sort(sortedSafety);
                if (sortedSafety[0] == -1.0f) {
                    return -1.0;
                }
                result += (double)sortedSafety[sortedSafety.length - 1];
            }
            return result /= (double)phenotype.getRewardLength();
        }
    }
}

