/*
 * Decompiled with CFR 0.152.
 */
package dungeon.screens.components;

import dungeon.Dungeon;
import java.util.Arrays;
import ui.BaseApplet;
import ui.components.UIComparativeProgressBar;
import ui.components.UILabel;
import ui.screens.UIContainer;

public class StatsPanel_Editor
extends UIContainer {
    double[] evaluationScores;
    int[] dataScores;
    String[] evaluationLabels = new String[]{"Owned_Rewards", "Area_Control", "Exploration", "Owned_Rewards_Fairness", "Area_Control_Fairness", "Exploration_Fairness"};
    int[][] evaluationColors = new int[][]{{0, 0, 255}, {255, 0, 128}, {0, 255, 0}, {0, 0, 128}, {128, 0, 64}, {0, 128, 0}};
    String[] dataLabels = new String[]{"Exits", "Monsters", "Rewards", "Used_Space", "Max_Base_Distance", "Avg_Base_Distance", "Min_Base_Distance", "Choke_Points", "Dead_Ends", "Open_Areas"};

    public StatsPanel_Editor(BaseApplet p, int x, int y) {
        super(p);
        this.initialize(x, y);
    }

    protected void initializeSingleEvaluation(int positionX, int positionY, int index) {
        UIComparativeProgressBar pb = new UIComparativeProgressBar(this.p, 0, 0, 100, 20);
        pb.setTopLeftPosition(positionX, positionY);
        pb.setColor(this.p.color(this.evaluationColors[index][0], this.evaluationColors[index][1], this.evaluationColors[index][2]));
        pb.setUseText(true);
        this.addComponent(this.evaluationLabels[index] + "_Bar", pb);
        UILabel l = new UILabel(this.p, "N/A", pb.getPositionX(), pb.getPositionY());
        this.addComponent(this.evaluationLabels[index] + "None_Label", l);
        this.hide(this.evaluationLabels[index] + "None_Label");
        l = new UILabel(this.p, this.evaluationLabels[index].replace("_", " "), pb.getPositionX(), pb.getPositionY() - pb.getHeight());
        this.addComponent(this.evaluationLabels[index] + "_Label", l);
        l = new UILabel(this.p, "++", 0, 0, "Large");
        l.setTextColor(this.p.color(0, 255, 0));
        l.setTopLeftPosition(pb.getTopRightCorner());
        l.setCaption("");
        this.addComponent(this.evaluationLabels[index] + "Plus_Label", l);
        l = new UILabel(this.p, "--", 0, 0, "Large");
        l.setTextColor(this.p.color(255, 0, 0));
        l.setBottomRightPosition(pb.getBottomLeftCorner());
        l.setCaption("");
        this.addComponent(this.evaluationLabels[index] + "Minus_Label", l);
    }

    protected void initializeSingleData(int positionX, int positionY, int index) {
        UILabel l = new UILabel(this.p, this.dataLabels[index].replace("_", " ") + ": ", 0, 0);
        l.setTopRightPosition(positionX, positionY);
        this.addComponent(this.dataLabels[index] + "_Label", l);
        l = new UILabel(this.p, "XXX", 0, 0);
        l.setTextCenter(1);
        l.setTopLeftPosition(positionX - 19, positionY);
        l.setCaption("");
        this.addComponent(this.dataLabels[index] + "Data_Label", l);
        l = new UILabel(this.p, "XXX", 0, 0);
        l.setTextCenter(1);
        l.setTopLeftPosition(positionX + 14, positionY);
        l.setCaption("");
        this.addComponent(this.dataLabels[index] + "Other_Label", l);
    }

    protected void initialize(int positionX, int positionY) {
        int i;
        int x = positionX;
        int y = positionY;
        for (i = 0; i < this.evaluationLabels.length; ++i) {
            if (i == this.evaluationLabels.length / 2) {
                x += 145;
                y = positionY;
            }
            this.initializeSingleEvaluation(x, y, i);
            y += 50;
        }
        x = positionX + 65;
        y = positionY += 135;
        for (i = 0; i < this.dataLabels.length; ++i) {
            if (i == 3) {
                x += 75;
                y = 55 + positionY;
            }
            if (i == 7) {
                x += 75;
                y = positionY;
            }
            this.initializeSingleData(x, y, i);
            y += 17;
        }
    }

    public void updateSingleData(int data, int index) {
        UILabel l = (UILabel)this.getComponent(this.dataLabels[index] + "Data_Label");
        if (this.dataLabels[index].equals("Used_Space")) {
            l.setCaption("" + data + "%");
        } else {
            l.setCaption("" + data);
        }
    }

    public void updateSingleEvaluation(double evaluationScore, int index) {
        if (this.evaluationScores[index] == -1.0) {
            this.show(this.evaluationLabels[index] + "None_Label");
            this.hide(this.evaluationLabels[index] + "_Bar");
        } else {
            this.hide(this.evaluationLabels[index] + "None_Label");
            this.show(this.evaluationLabels[index] + "_Bar");
        }
        UIComparativeProgressBar pb = (UIComparativeProgressBar)this.getComponent(this.evaluationLabels[index] + "_Bar");
        pb.setProgress(this.evaluationScores[index]);
    }

    public void updateEvaluations(Dungeon map, double[] evaluationScores) {
        int i;
        this.evaluationScores = Arrays.copyOf(evaluationScores, evaluationScores.length);
        for (i = 0; i < this.evaluationLabels.length; ++i) {
            this.updateSingleEvaluation(evaluationScores[i], i);
        }
        this.dataScores = map.getMetrics().getDataArray();
        for (i = 0; i < this.dataScores.length; ++i) {
            this.updateSingleData(this.dataScores[i], i);
        }
    }

    public void updateSingleComparison(double comparativeScore, int index) {
        UILabel l = (UILabel)this.getComponent(this.evaluationLabels[index] + "Plus_Label");
        if (comparativeScore > 0.2) {
            l.setCaption("++");
        } else if (comparativeScore > 0.01) {
            l.setCaption("+");
        } else {
            l.setCaption("");
        }
        l = (UILabel)this.getComponent(this.evaluationLabels[index] + "Minus_Label");
        if (comparativeScore < -0.2) {
            l.setCaption("--");
        } else if (comparativeScore < -0.01) {
            l.setCaption("-");
        } else {
            l.setCaption("");
        }
        UIComparativeProgressBar pb = (UIComparativeProgressBar)this.getComponent(this.evaluationLabels[index] + "_Bar");
        pb.setAltProgress(comparativeScore + this.evaluationScores[index]);
    }

    public void updateComparisons(Dungeon otherMap, double[] comparativeScores) {
        if (comparativeScores == null || otherMap == null) {
            this.removeComparisons();
        } else {
            for (int i = 0; i < this.evaluationLabels.length; ++i) {
                if (this.evaluationScores[i] == -1.0) continue;
                this.updateSingleComparison(comparativeScores[i], i);
            }
            int[] otherData = otherMap.getMetrics().getDataArray();
            for (int i = 0; i < otherData.length; ++i) {
                this.updateSingleDataComparison(otherData[i], i);
            }
        }
    }

    public void removeSingleComparison(int index) {
        UILabel l = (UILabel)this.getComponent(this.evaluationLabels[index] + "Plus_Label");
        l.setCaption("");
        l = (UILabel)this.getComponent(this.evaluationLabels[index] + "Minus_Label");
        l.setCaption("");
        UIComparativeProgressBar pb = (UIComparativeProgressBar)this.getComponent(this.evaluationLabels[index] + "_Bar");
        pb.setAltProgress(-1.0);
    }

    public void removeSingleData(int index) {
        UILabel l = (UILabel)this.getComponent(this.dataLabels[index] + "Other_Label");
        l.setCaption("");
    }

    public void removeComparisons() {
        int i;
        for (i = 0; i < this.evaluationLabels.length; ++i) {
            this.removeSingleComparison(i);
        }
        for (i = 0; i < this.dataLabels.length; ++i) {
            this.removeSingleData(i);
        }
    }

    public void updateSingleDataComparison(int otherData, int index) {
        UILabel l = (UILabel)this.getComponent(this.dataLabels[index] + "Other_Label");
        if (otherData > this.dataScores[index]) {
            l.setTextColor(this.p.color(0, 255, 0));
        } else if (otherData < this.dataScores[index]) {
            l.setTextColor(this.p.color(255, 0, 0));
        } else {
            l.setTextColor(this.p.color(128));
        }
        if (this.dataLabels[index].equals("Used_Space")) {
            l.setCaption("" + otherData + "%");
        } else {
            l.setCaption("" + otherData);
        }
    }
}

