/*
 * Decompiled with CFR 0.152.
 */
package dungeon.screens.threaded;

import dungeon.DetailConverter;
import dungeon.Dungeon;
import dungeon.genetic.DungeonGene;
import dungeon.genetic.DungeonGeneConverter;
import dungeon.visualization.DungeonDetailVisualizer;
import dungeon.visualization.DungeonVisualizer;
import java.io.File;
import java.util.Vector;
import processing.core.PImage;
import renderer.Render2D;
import ui.BaseApplet;
import ui.components.UIButton;
import ui.components.UIImage;
import ui.components.UILabel;
import ui.components.UIToggleButtonGroup;
import ui.screens.Screen;
import util.collections.ParameterCollection;
import util.logs.Writer;

public class Screen_DetailedView
extends Screen {
    final int imgSizeX = 512;
    final int imgSizeY = 512;
    public final int cellularSizeX = 10;
    public final int cellularSizeY = 10;
    int gridSizeX;
    int gridSizeY;
    Dungeon sketch;
    Vector<PImage> detailedViews;
    public static String sessionFile;

    public Screen_DetailedView(BaseApplet p, Dungeon sketch) {
        super(p);
        this.sketch = sketch;
        this.remakeDetailedViews();
        this.initialize();
    }

    protected void initialize() {
        this.gridSizeX = 512 / this.sketch.getMapSizeX();
        this.gridSizeY = 512 / this.sketch.getMapSizeY();
        UIImage img = new UIImage(this.p, this.detailedViews.get(0), 0, 0);
        img.setPosition(img.getWidth() / 2 + 10, img.getHeight() / 2 + 90);
        this.addComponent("Canvas", img);
        int offset = 40;
        this.addComponent("Title", new UILabel(this.p, "Dungeon Detailed View", this.p.width / 2, offset + 20, "Huge"));
        this.addComponent("ViewMode_Label", new UILabel(this.p, "Viewing Modes", img.getPositionX() + img.getWidth() / 2 + 57, offset + 205, "Large"));
        UIToggleButtonGroup t = new UIToggleButtonGroup(this.p, img.getPositionX() + img.getWidth() / 2 + 50, offset + 225, 90, 20);
        t.setAllowUnselected(false);
        t.addButton("Simple");
        t.addButtonNextLine("Room-based");
        t.addButtonNextLine("Dungeon");
        t.addButtonNextLine("Sprite Dungeon");
        t.setSelectedIndex(0);
        this.addComponent("ViewingMode_Group", t);
        this.addComponent("Reset_Button", new UIButton(this.p, "Regenerate", img.getPositionX() + img.getWidth() / 2 + 57, offset + 155, "Large"));
        this.addComponent("Back_Button", new UIButton(this.p, "Back", img.getPositionX() - img.getWidth() / 2 + 50, img.getPositionY() + img.getHeight() / 2 + 40, "Large"));
        this.addComponent("IncSession_Button", new UIButton(this.p, "New Save Location", img.getPositionX() + img.getWidth() / 2 + 75, 400, "Large"));
        this.addComponent("ExportMap_Button", new UIButton(this.p, "Export Map", img.getPositionX() + img.getWidth() / 2 + 200, 400, "Large"));
        this.addComponent("ExportGene_Button", new UIButton(this.p, "Export Gene", img.getPositionX() + img.getWidth() / 2 + 300, 400, "Large"));
    }

    @Override
    public void mouseClicked() {
        super.mouseClicked();
        UIButton b = null;
        b = (UIButton)this.getComponent("Back_Button");
        if (b != null && b.getState() == UIButton.State.PRESSED) {
            this.p.swapPreviousScreen();
        }
        if ((b = (UIButton)this.getComponent("Reset_Button")) != null && b.getState() == UIButton.State.PRESSED) {
            this.remakeDetailedViews();
            this.showMap();
        }
        if ((b = (UIButton)this.getComponent("IncSession_Button")) != null && b.getState() == UIButton.State.PRESSED) {
            sessionFile = this.findLogLocation();
        }
        if ((b = (UIButton)this.getComponent("ExportMap_Button")) != null && b.getState() == UIButton.State.PRESSED) {
            if (sessionFile == null) {
                sessionFile = this.findLogLocation();
            }
            UIToggleButtonGroup t = (UIToggleButtonGroup)this.getComponent("ViewingMode_Group");
            PImage mapImage = this.detailedViews.get(t.getSelectedIndex());
            mapImage.save(sessionFile + "/" + this.sketch.getMapSizeX() + "x" + this.sketch.getMapSizeY() + "_" + t.getSelectedCaption() + ".png");
        }
        if ((b = (UIButton)this.getComponent("ExportGene_Button")) != null && b.getState() == UIButton.State.PRESSED) {
            if (sessionFile == null) {
                sessionFile = this.findLogLocation();
            }
            DungeonGene baseGene = DungeonGeneConverter.getGene(this.sketch, new ParameterCollection());
            Writer writer = new Writer(sessionFile + "/" + this.sketch.getMapSizeX() + "x" + this.sketch.getMapSizeY() + "_gene.xml");
            writer.write(baseGene.toXML());
            writer.close();
        }
        this.showMap();
    }

    @Override
    public void update() {
        this.remakeDetailedViews();
        this.showMap();
    }

    public void remakeDetailedViews() {
        Render2D renderer = DungeonDetailVisualizer.renderDungeon(this.p, this.sketch, 512, 512);
        this.detailedViews = new Vector();
        this.detailedViews.add(renderer.getImage());
        DetailConverter dc = new DetailConverter(this.sketch, 9, 9);
        dc.makeFixedWidthRooms();
        renderer = DungeonDetailVisualizer.renderDungeon(this.p, dc.getMap());
        this.detailedViews.add(renderer.getImage());
    }

    protected void showMap() {
        UIToggleButtonGroup t = (UIToggleButtonGroup)this.getComponent("ViewingMode_Group");
        PImage mapImage = t.getSelectedIndex() < 2 ? this.detailedViews.get(t.getSelectedIndex()) : (t.getSelectedIndex() == 2 ? DungeonVisualizer.renderDungeon(this.p, this.sketch, 512, 512).getImage() : DungeonDetailVisualizer.renderCorridorDungeon(this.p, this.sketch, 512, 512).getImage());
        UIImage c = (UIImage)this.getComponent("Canvas");
        c.setImage(mapImage, true);
    }

    protected String findLogLocation() {
        String baseFile = "./exportedMaps/";
        int result = 0;
        File fp = null;
        while ((fp = new File("./exportedMaps/" + ++result)).exists()) {
        }
        return "./exportedMaps/" + result;
    }
}

