/*
 * Decompiled with CFR 0.152.
 */
package dungeon.visualization;

import ai.pathfinder.Connector;
import ai.pathfinder.Node;
import ai.pathfinder.Pathfinder;
import common.PathLibrary;
import dungeon.Dungeon;
import dungeon.visualization.DungeonTiles;
import processing.core.PApplet;
import renderer.Render2D;
import renderer.SpriteRender2D;
import util.math2d.Point2D;
import util.math2d.Vector2D;

public class DungeonDetailVisualizer {
    static final String passableFile = "./resources/tilesets/dungeon/passable.png";
    static final String impassableFile = "./resources/tilesets/dungeon/impassable.png";
    static final int tileX = 10;
    static final int tileY = 10;

    public static Render2D renderDungeon(PApplet p, Dungeon map) {
        return DungeonDetailVisualizer.renderDungeon(p, map, map.getMapSizeX() * 10, map.getMapSizeY() * 10);
    }

    public static Render2D renderDungeon(PApplet p, Dungeon map, int imgSizeX, int imgSizeY) {
        int i;
        DungeonTiles dt = new DungeonTiles(p);
        boolean[][] impassable = map.getImpassableArray();
        SpriteRender2D renderer = new SpriteRender2D(p, map.getMapSizeX(), map.getMapSizeY(), imgSizeX, imgSizeY);
        renderer.renderGrid();
        renderer.renderTiles(impassable, dt.getImpassableTile(), dt.getPassableTile());
        for (i = 0; i < map.getMonsterLength(); ++i) {
            renderer.renderTile(map.getMonster(i), dt.getRandomMonster());
        }
        for (i = 0; i < map.getRewardLength(); ++i) {
            renderer.renderTile(map.getReward(i), dt.getRandomItem());
        }
        for (i = 0; i < map.getExitLength(); ++i) {
            renderer.renderTile(map.getExit(i), dt.getEntranceTile());
        }
        return renderer;
    }

    public static Render2D renderCorridorDungeon(PApplet p, Dungeon map, int imgSizeX, int imgSizeY) {
        int j;
        int i;
        int y;
        int x;
        DungeonTiles dt = new DungeonTiles(p);
        int gridSize = 10;
        int[] color = new int[]{p.color(0), p.color(255), p.color(120, 40, 0), p.color(200, 0, 0), p.color(255, 255, 0), p.color(140, 140, 140)};
        boolean[][] rewards = map.getRewardArray();
        boolean[][] monsters = map.getMonsterArray();
        boolean[][] exits = map.getExitArray();
        boolean[][] passable = map.getPassableArray();
        boolean[][] chokePoints = map.getPaths().getChokePoints();
        boolean[][] deadEnds = map.getPaths().getDeadEnds();
        int roomSize = 5;
        boolean[][] openSpace = new boolean[map.getMapSizeX() * gridSize][map.getMapSizeY() * gridSize];
        for (x = 0; x < passable.length; ++x) {
            for (y = 0; y < passable[x].length; ++y) {
                if (!passable[x][y] || !exits[x][y] && (chokePoints[x][y] || deadEnds[x][y])) continue;
                for (i = 1; i < roomSize - 1; ++i) {
                    for (j = 1; j < roomSize - 1; ++j) {
                        openSpace[x * roomSize + i][y * roomSize + j] = true;
                    }
                }
            }
        }
        for (x = 0; x < passable.length; ++x) {
            for (y = 0; y < passable[x].length; ++y) {
                if (y >= passable[x].length - 1 || x >= passable.length - 1 || !passable[x][y] || !passable[x][y + 1] || !passable[x + 1][y] || !passable[x + 1][y + 1]) continue;
                for (i = 1; i < 2 * roomSize - 1; ++i) {
                    for (j = 1; j < 2 * roomSize - 1; ++j) {
                        openSpace[x * roomSize + i][y * roomSize + j] = true;
                    }
                }
            }
        }
        if (map.getPaths() != null && map.getPaths().getAStar() != null) {
            Pathfinder astar = map.getPaths().getAStar();
            for (int i2 = 0; i2 < astar.nodes.size(); ++i2) {
                Node n = (Node)astar.nodes.get(i2);
                if (!n.walkable) continue;
                Connector conn = null;
                for (j = 0; j < n.links.size(); ++j) {
                    conn = (Connector)n.links.get(j);
                    Point2D start = PathLibrary.transformNode(n);
                    Point2D end = Vector2D.interpolate(PathLibrary.transformNode(n), PathLibrary.transformNode(conn.n), 0.5f);
                    if (start.x != end.x && start.y != end.y) continue;
                    start.x = (start.x + 0.5) * (double)roomSize;
                    start.y = (start.y + 0.5) * (double)roomSize;
                    end.x = (end.x + 0.5) * (double)roomSize;
                    end.y = (end.y + 0.5) * (double)roomSize;
                    for (int x2 = (int)Math.min(start.x, end.x); x2 <= (int)Math.max(start.x, end.x); ++x2) {
                        for (int y2 = (int)Math.min(start.y, end.y); y2 <= (int)Math.max(start.y, end.y); ++y2) {
                            openSpace[x2][y2] = true;
                        }
                    }
                }
            }
        }
        SpriteRender2D renderer = new SpriteRender2D(p, map.getMapSizeX() * roomSize, map.getMapSizeY() * roomSize, imgSizeX, imgSizeY);
        renderer.renderGrid();
        renderer.renderTiles(openSpace, dt.getPassableTile(), dt.getImpassableTile());
        int locationDiameter = Math.min(renderer.getGridSizeX(), renderer.getGridSizeY()) * gridSize / 2;
        for (int x3 = 0; x3 < exits.length; ++x3) {
            for (int y3 = 0; y3 < exits[x3].length; ++y3) {
                if (monsters[x3][y3]) {
                    renderer.renderTile((int)(((double)x3 + 0.5) * (double)roomSize), (int)(((double)y3 + 0.5) * (double)roomSize), dt.getRandomMonster());
                }
                if (rewards[x3][y3]) {
                    renderer.renderTile((int)(((double)x3 + 0.5) * (double)roomSize), (int)(((double)y3 + 0.5) * (double)roomSize), dt.getRandomItem());
                }
                if (!exits[x3][y3]) continue;
                renderer.renderTile((int)(((double)x3 + 0.5) * (double)roomSize), (int)(((double)y3 + 0.5) * (double)roomSize), dt.getExitTile());
            }
        }
        return renderer;
    }
}

