/*
 * Decompiled with CFR 0.152.
 */
package dungeon.visualization;

import java.util.HashMap;
import processing.core.PApplet;
import processing.core.PImage;
import util.statics.RandomNumberManager;

public class DungeonTiles {
    HashMap<String, PImage> tiles;
    String[] combat_items;
    String[] magic_items;
    String[] misc_items;
    String[] combat_monsters;
    String[] magic_monsters;
    String[] misc_monsters;

    public DungeonTiles(PApplet p) {
        this.loadTiles(p);
    }

    public void loadTiles(PApplet p) {
        String path = "./resources/tilesets/dungeon/";
        this.tiles = new HashMap();
        this.tiles.put("wall", p.loadImage("./resources/tilesets/dungeon/wall.png"));
        this.tiles.put("empty", p.loadImage("./resources/tilesets/dungeon/empty.png"));
        this.tiles.put("exit", p.loadImage("./resources/tilesets/dungeon/exit.png"));
        this.tiles.put("entrance", p.loadImage("./resources/tilesets/dungeon/entrance.png"));
        this.tiles.put("missile", p.loadImage("./resources/tilesets/dungeon/missile.png"));
        this.tiles.put("fireball", p.loadImage("./resources/tilesets/dungeon/fireball.png"));
        this.tiles.put("acidcloud", p.loadImage("./resources/tilesets/dungeon/acidcloud.png"));
        this.tiles.put("bow", p.loadImage("./resources/tilesets/dungeon/bow.png"));
        this.tiles.put("axe", p.loadImage("./resources/tilesets/dungeon/axe.png"));
        this.tiles.put("sword", p.loadImage("./resources/tilesets/dungeon/sword.png"));
        this.tiles.put("magicsword", p.loadImage("./resources/tilesets/dungeon/magicsword.png"));
        this.tiles.put("leatherarmor", p.loadImage("./resources/tilesets/dungeon/leatherarmor.png"));
        this.tiles.put("azurearmor", p.loadImage("./resources/tilesets/dungeon/azurearmor.png"));
        this.tiles.put("metalarmor", p.loadImage("./resources/tilesets/dungeon/metalarmor.png"));
        this.tiles.put("chest", p.loadImage("./resources/tilesets/dungeon/chest.png"));
        this.tiles.put("ring", p.loadImage("./resources/tilesets/dungeon/ring.png"));
        this.tiles.put("potion", p.loadImage("./resources/tilesets/dungeon/potion.png"));
        this.tiles.put("manapotion", p.loadImage("./resources/tilesets/dungeon/manapotion.png"));
        this.tiles.put("gold", p.loadImage("./resources/tilesets/dungeon/gold.png"));
        this.tiles.put("evileye", p.loadImage("./resources/tilesets/dungeon/evileye.png"));
        this.tiles.put("greendragon", p.loadImage("./resources/tilesets/dungeon/greendragon.png"));
        this.tiles.put("demon", p.loadImage("./resources/tilesets/dungeon/demon.png"));
        this.tiles.put("imp", p.loadImage("./resources/tilesets/dungeon/imp.png"));
        this.tiles.put("golem", p.loadImage("./resources/tilesets/dungeon/golem.png"));
        this.tiles.put("dragon", p.loadImage("./resources/tilesets/dungeon/dragon.png"));
        this.tiles.put("goblin", p.loadImage("./resources/tilesets/dungeon/goblin.png"));
        this.tiles.put("snake", p.loadImage("./resources/tilesets/dungeon/snake.png"));
        this.tiles.put("spider", p.loadImage("./resources/tilesets/dungeon/spider.png"));
        this.combat_items = new String[]{"bow", "axe", "sword", "leatherarmor", "metalarmor"};
        this.magic_items = new String[]{"acidcloud", "fireball", "missile", "magicsword", "azurearmor"};
        this.misc_items = new String[]{"chest", "manapotion", "potion", "gold", "ring"};
        this.combat_monsters = new String[]{"dragon", "golem", "goblin", "snake", "spider"};
        this.magic_monsters = new String[]{"demon", "greendragon", "evileye", "imp"};
    }

    public PImage getPassableTile() {
        return this.tiles.get("empty");
    }

    public PImage getImpassableTile() {
        return this.tiles.get("wall");
    }

    public PImage getEntranceTile() {
        return this.tiles.get("entrance");
    }

    public PImage getExitTile() {
        return this.tiles.get("exit");
    }

    public PImage getRandomMonster() {
        int totalMonsters = this.combat_monsters.length + this.magic_monsters.length;
        int roll = RandomNumberManager.getRandomInt(0, totalMonsters);
        if (roll < this.combat_monsters.length) {
            return this.tiles.get(this.combat_monsters[roll]);
        }
        if (roll - this.combat_monsters.length < this.magic_monsters.length) {
            return this.tiles.get(this.magic_monsters[roll - this.combat_monsters.length]);
        }
        return null;
    }

    public PImage getRandomItem() {
        int totalItems = this.combat_items.length + this.magic_items.length + this.misc_items.length;
        int roll = RandomNumberManager.getRandomInt(0, totalItems);
        if (roll < this.combat_items.length) {
            return this.tiles.get(this.combat_items[roll]);
        }
        if (roll - this.combat_items.length < this.magic_items.length) {
            return this.tiles.get(this.magic_items[roll - this.combat_items.length]);
        }
        if (roll - this.combat_items.length - this.magic_items.length < this.misc_items.length) {
            return this.tiles.get(this.misc_items[roll - this.combat_items.length - this.magic_items.length]);
        }
        return null;
    }
}

