/*
 * Decompiled with CFR 0.152.
 */
package dungeon.visualization;

import ai.pathfinder.Connector;
import ai.pathfinder.Node;
import ai.pathfinder.Pathfinder;
import common.PathLibrary;
import dungeon.Dungeon;
import java.util.ArrayList;
import java.util.Vector;
import processing.core.PApplet;
import renderer.Render2D;
import util.image.processing.ImageProcessing;
import util.image.processing.Thresholding;
import util.math2d.Matrix2D;
import util.math2d.Point2D;
import util.math2d.Vector2D;

public class DungeonVisualizer {
    static final int[][] baseColors = new int[][]{{255, 0, 0}, {0, 0, 255}, {64, 255, 64}, {128, 0, 255}, {255, 255, 0}, {0, 255, 255}, {255, 255, 255}, {0, 0, 0}};
    static final int[] impassableColor = new int[]{40, 40, 40};
    static final int[] passableColor = new int[]{255, 255, 255};
    static final int[] exitColor = new int[]{140, 140, 140};
    static final int[] monsterColor = new int[]{200, 0, 0};
    static final int[] rewardColor = new int[]{255, 255, 0};
    static int explorationIndex = 0;

    public static Render2D renderThumbnail(PApplet p, Dungeon map) {
        return DungeonVisualizer.renderThumbnail(p, map, map.getMapSizeX(), map.getMapSizeY());
    }

    public static Render2D renderThumbnail(PApplet p, Dungeon map, int imgSizeX, int imgSizeY) {
        boolean[][] impassable = map.getImpassableArray();
        boolean[][] monsters = map.getMonsterArray();
        boolean[][] rewards = map.getRewardArray();
        boolean[][] exits = map.getExitArray();
        Render2D renderer = new Render2D(p, map.getMapSizeX(), map.getMapSizeY(), imgSizeX, imgSizeY);
        renderer.renderGrid();
        renderer.renderTiles(impassable, p.color(impassableColor[0], impassableColor[1], impassableColor[2]), p.color(passableColor[0], passableColor[1], passableColor[2]));
        renderer.renderTiles(monsters, p.color(monsterColor[0], monsterColor[1], monsterColor[2]));
        renderer.renderTiles(rewards, p.color(rewardColor[0], rewardColor[1], rewardColor[2]));
        renderer.renderTiles(exits, p.color(exitColor[0], exitColor[1], exitColor[2]));
        return renderer;
    }

    public static Render2D renderExplorationThumbnail(PApplet p, Dungeon map, int imgSizeX, int imgSizeY) {
        Render2D renderer = new Render2D(p, map.getMapSizeX(), map.getMapSizeY(), imgSizeX, imgSizeY);
        renderer.renderGrid();
        int i = ++explorationIndex % map.getExitLength();
        float[][] temp = map.getPaths().getExplorationMatrix(i);
        System.out.println(Matrix2D.print(Thresholding.getArrayAboveValue(temp, 0.2f)));
        int c_on = p.color(baseColors[i][0], baseColors[i][1], baseColors[i][2], 160);
        renderer.renderTiles(temp, c_on);
        return renderer;
    }

    public static Render2D renderNavmeshThumbnail(PApplet p, Dungeon map) {
        return DungeonVisualizer.renderNavmeshThumbnail(p, map, map.getMapSizeX(), map.getMapSizeY());
    }

    public static Render2D renderNavmeshThumbnail(PApplet p, Dungeon map, int imgSizeX, int imgSizeY) {
        boolean[][] impassable = map.getImpassableArray();
        boolean[][] monsters = map.getMonsterArray();
        boolean[][] rewards = map.getRewardArray();
        boolean[][] exits = map.getExitArray();
        Render2D renderer = new Render2D(p, map.getMapSizeX(), map.getMapSizeY(), imgSizeX, imgSizeY);
        renderer.renderGrid();
        renderer.renderTiles(impassable, p.color(impassableColor[0], impassableColor[1], impassableColor[2]), p.color(passableColor[0], passableColor[1], passableColor[2]));
        boolean[][] deadEnds = map.getPaths().getDeadEnds();
        boolean[][] chokePoints = map.getPaths().getChokePoints();
        boolean[][] openSpaces = map.getPaths().getOpenAreas();
        renderer.renderTiles(deadEnds, p.color(0, 0, 0, 75));
        renderer.renderTiles(chokePoints, p.color(255, 0, 128, 75));
        renderer.renderTiles(openSpaces, p.color(255, 255, 0, 75));
        if (map.getPaths() != null && map.getPaths().getAStar() != null) {
            Pathfinder astar = map.getPaths().getAStar();
            for (int i = 0; i < astar.nodes.size(); ++i) {
                Node n = (Node)astar.nodes.get(i);
                if (!n.walkable) continue;
                Connector conn = null;
                for (int j = 0; j < n.links.size(); ++j) {
                    conn = (Connector)n.links.get(j);
                    renderer.renderLine(PathLibrary.transformNode(conn.n), PathLibrary.transformNode(n), p.color(0, 255, 0), 2.0f);
                    int pointColor = p.color(0, 255, 0);
                    if (openSpaces[(int)conn.n.x][(int)conn.n.y]) {
                        pointColor = p.color(255, 255, 0);
                    }
                    if (chokePoints[(int)conn.n.x][(int)conn.n.y]) {
                        pointColor = p.color(255, 0, 128);
                    }
                    if (deadEnds[(int)conn.n.x][(int)conn.n.y]) {
                        pointColor = p.color(0, 0, 0);
                    }
                    renderer.renderMidpoint(PathLibrary.transformNode(conn.n), pointColor, 10);
                    pointColor = p.color(0, 255, 0);
                    if (openSpaces[(int)n.x][(int)n.y]) {
                        pointColor = p.color(255, 255, 0);
                    }
                    if (deadEnds[(int)n.x][(int)n.y]) {
                        pointColor = p.color(0, 0, 0);
                    }
                    if (chokePoints[(int)n.x][(int)n.y]) {
                        pointColor = p.color(255, 0, 128);
                    }
                    renderer.renderMidpoint(PathLibrary.transformNode(n), pointColor, 10);
                }
            }
        }
        return renderer;
    }

    public static Render2D renderUnusedSpaceThumbnail(PApplet p, Dungeon map) {
        return DungeonVisualizer.renderUnusedSpaceThumbnail(p, map, map.getMapSizeX(), map.getMapSizeY());
    }

    public static Render2D renderUnusedSpaceThumbnail(PApplet p, Dungeon map, int imgSizeX, int imgSizeY) {
        boolean[][] impassable = map.getImpassableArray();
        boolean[][] monsters = map.getMonsterArray();
        boolean[][] rewards = map.getRewardArray();
        boolean[][] exits = map.getExitArray();
        Render2D renderer = new Render2D(p, map.getMapSizeX(), map.getMapSizeY(), imgSizeX, imgSizeY);
        renderer.renderGrid();
        renderer.renderTiles(impassable, p.color(impassableColor[0], impassableColor[1], impassableColor[2]), p.color(passableColor[0], passableColor[1], passableColor[2]));
        renderer.renderTiles(monsters, p.color(monsterColor[0], monsterColor[1], monsterColor[2]));
        renderer.renderTiles(rewards, p.color(rewardColor[0], rewardColor[1], rewardColor[2]));
        renderer.renderTiles(exits, p.color(exitColor[0], exitColor[1], exitColor[2]));
        if (map.getPaths() != null && map.getPaths().getExit_monsterPaths() != null && map.getPaths().getExitPaths() != null) {
            Vector<Point2D> points;
            ArrayList path;
            int i;
            boolean[][] unusedSpace = map.getPaths().getUnusedSpaces();
            renderer.renderTiles(unusedSpace, p.color(255, 127, 39));
            for (i = 0; i < map.getPaths().getExitPathLength(); ++i) {
                path = map.getPaths().getExitPaths().get(i);
                points = PathLibrary.transformPath(path);
                renderer.renderPath(points, p.color(220), 6.0f);
            }
            for (i = 0; i < map.getPaths().getExit_monsterPathLength(); ++i) {
                path = map.getPaths().getExit_monsterPaths().get(i);
                points = PathLibrary.transformPath(path);
                renderer.renderPath(points, p.color(220, 0, 0), 4.0f);
            }
            for (i = 0; i < map.getPaths().getMonster_rewardPathLength(); ++i) {
                path = map.getPaths().getMonster_rewardPaths().get(i);
                points = PathLibrary.transformPath(path);
                renderer.renderPath(points, p.color(220, 220, 0), 2.0f);
            }
        }
        return renderer;
    }

    public static Render2D renderSegmentsThumbnail(PApplet p, Dungeon map) {
        return DungeonVisualizer.renderSegmentsThumbnail(p, map, map.getMapSizeX(), map.getMapSizeY());
    }

    public static Render2D renderSegmentsThumbnail(PApplet p, Dungeon map, int imgSizeX, int imgSizeY) {
        boolean[][] impassable = map.getImpassableArray();
        boolean[][] monsters = map.getMonsterArray();
        boolean[][] rewards = map.getRewardArray();
        boolean[][] exits = map.getExitArray();
        Render2D renderer = new Render2D(p, map.getMapSizeX(), map.getMapSizeY(), imgSizeX, imgSizeY);
        renderer.renderGrid();
        renderer.renderTiles(impassable, p.color(impassableColor[0], impassableColor[1], impassableColor[2]), p.color(passableColor[0], passableColor[1], passableColor[2]));
        renderer.renderTiles(monsters, p.color(monsterColor[0], monsterColor[1], monsterColor[2]));
        renderer.renderTiles(rewards, p.color(rewardColor[0], rewardColor[1], rewardColor[2]));
        renderer.renderTiles(exits, p.color(exitColor[0], exitColor[1], exitColor[2]));
        boolean[][] altImpassable = Matrix2D.copy(impassable);
        boolean[][] chokePoints = map.getPaths().getChokePoints();
        altImpassable = Matrix2D.union(altImpassable, chokePoints);
        altImpassable = Matrix2D.invert(altImpassable);
        Vector<boolean[][]> segments = ImageProcessing.getSegments(altImpassable, 0);
        for (int i = 0; i < segments.size(); ++i) {
            int cIndex = Math.min(i, baseColors.length - 1);
            renderer.renderTiles(segments.get(i), p.color(baseColors[cIndex][0], baseColors[cIndex][1], baseColors[cIndex][2], 160));
        }
        return renderer;
    }

    public static Render2D renderNearbyRewardsThumbnail(PApplet p, Dungeon map) {
        return DungeonVisualizer.renderNearbyRewardsThumbnail(p, map, map.getMapSizeX(), map.getMapSizeY());
    }

    public static Render2D renderNearbyRewardsThumbnail(PApplet p, Dungeon map, int imgSizeX, int imgSizeY) {
        float minSafety = 0.35f;
        boolean[][] impassable = map.getImpassableArray();
        boolean[][] monsters = map.getMonsterArray();
        boolean[][] rewards = map.getRewardArray();
        boolean[][] exits = map.getExitArray();
        Render2D renderer = new Render2D(p, map.getMapSizeX(), map.getMapSizeY(), imgSizeX, imgSizeY);
        renderer.renderGrid();
        renderer.renderTiles(impassable, p.color(impassableColor[0], impassableColor[1], impassableColor[2]), p.color(passableColor[0], passableColor[1], passableColor[2]));
        renderer.renderTiles(monsters, p.color(monsterColor[0], monsterColor[1], monsterColor[2]));
        renderer.renderTiles(rewards, p.color(rewardColor[0], rewardColor[1], rewardColor[2]));
        renderer.renderTiles(exits, p.color(exitColor[0], exitColor[1], exitColor[2]));
        for (int j = 0; j < map.getRewardLength(); ++j) {
            float[] rewardSafety = map.getPaths().getRewardSafety(j);
            for (int i = 0; i < map.getMonsterLength(); ++i) {
                if (!(rewardSafety[i] > 0.35f)) continue;
                ArrayList path = map.getPaths().getRewardPathFromMonster(j, i);
                renderer.renderPath(PathLibrary.transformPath(path), p.color(0, 155, 0), 3.0f);
                renderer.renderTile(map.getReward(j), p.color(0.0f, 255.0f, 0.0f, 255.0f * (rewardSafety[i] - 0.35f) / 0.65f));
            }
        }
        return renderer;
    }

    public static Render2D renderSafetyMatrix(PApplet p, Dungeon map) {
        return DungeonVisualizer.renderSafetyMatrix(p, map, map.getMapSizeX(), map.getMapSizeY());
    }

    public static Render2D renderSafetyMatrix(PApplet p, Dungeon map, int imgSizeX, int imgSizeY) {
        int c_on;
        int j;
        boolean[][] impassable = map.getImpassableArray();
        boolean[][] monsters = map.getMonsterArray();
        boolean[][] rewards = map.getRewardArray();
        boolean[][] exits = map.getExitArray();
        Render2D renderer = new Render2D(p, map.getMapSizeX(), map.getMapSizeY(), imgSizeX, imgSizeY);
        renderer.renderGrid();
        renderer.renderTiles(impassable, p.color(impassableColor[0], impassableColor[1], impassableColor[2]), p.color(passableColor[0], passableColor[1], passableColor[2]));
        renderer.renderTiles(monsters, p.color(monsterColor[0], monsterColor[1], monsterColor[2]));
        renderer.renderTiles(rewards, p.color(rewardColor[0], rewardColor[1], rewardColor[2]));
        renderer.renderTiles(exits, p.color(exitColor[0], exitColor[1], exitColor[2]));
        for (j = 0; j < map.getExitLength(); ++j) {
            c_on = p.color(exitColor[0], exitColor[1], exitColor[2], 160);
            renderer.renderTiles(Thresholding.getArrayAboveValue(map.getPaths().getSafetyMatrix(j), 0.35f), c_on);
        }
        for (j = 0; j < map.getMonsterLength(); ++j) {
            c_on = p.color(monsterColor[0], monsterColor[1], monsterColor[2], 160);
            renderer.renderTiles(Thresholding.getArrayAboveValue(map.getPaths().getSafetyMatrix(map.getExitLength() + j), 0.35f), c_on);
        }
        return renderer;
    }

    public static Render2D renderDungeon(PApplet p, Dungeon map, int imgSizeX, int imgSizeY) {
        int j;
        int i;
        int y;
        int x;
        int gridSize = 10;
        int[] color = new int[]{p.color(0), p.color(255), p.color(120, 40, 0), p.color(200, 0, 0), p.color(255, 255, 0), p.color(140, 140, 140)};
        boolean[][] rewards = map.getRewardArray();
        boolean[][] monsters = map.getMonsterArray();
        boolean[][] exits = map.getExitArray();
        boolean[][] passable = map.getPassableArray();
        boolean[][] chokePoints = map.getPaths().getChokePoints();
        boolean[][] openAreas = map.getPaths().getOpenAreas();
        Render2D renderer = new Render2D(p, map.getMapSizeX() * gridSize, map.getMapSizeY() * gridSize, imgSizeX, imgSizeY);
        renderer.renderGrid();
        renderer.renderBackground(color[0]);
        for (x = 0; x < passable.length; ++x) {
            for (y = 0; y < passable[x].length; ++y) {
                if (!passable[x][y] || chokePoints[x][y] && !rewards[x][y] && !monsters[x][y] && !exits[x][y]) continue;
                for (i = 1; i < gridSize - 1; ++i) {
                    for (j = 1; j < gridSize - 1; ++j) {
                        renderer.renderTile(x * gridSize + i, y * gridSize + j, color[1]);
                    }
                }
            }
        }
        for (x = 0; x < passable.length; ++x) {
            for (y = 0; y < passable[x].length; ++y) {
                if (y >= passable[x].length - 1 || x >= passable.length - 1 || !passable[x][y] || !passable[x][y + 1] || !passable[x + 1][y] || !passable[x + 1][y + 1]) continue;
                for (i = 1; i < 2 * gridSize - 1; ++i) {
                    for (j = 1; j < 2 * gridSize - 1; ++j) {
                        renderer.renderTile(x * gridSize + i, y * gridSize + j, color[1]);
                    }
                }
            }
        }
        float corridorWidth = Math.min(renderer.getGridSizeX(), renderer.getGridSizeY()) * gridSize / 3;
        if (map.getPaths() != null && map.getPaths().getAStar() != null) {
            Pathfinder astar = map.getPaths().getAStar();
            for (i = 0; i < astar.nodes.size(); ++i) {
                Node n = (Node)astar.nodes.get(i);
                if (!n.walkable) continue;
                Connector conn = null;
                for (int j2 = 0; j2 < n.links.size(); ++j2) {
                    conn = (Connector)n.links.get(j2);
                    Point2D start = PathLibrary.transformNode(n);
                    Point2D end = Vector2D.interpolate(PathLibrary.transformNode(n), PathLibrary.transformNode(conn.n), 0.5f);
                    if (start.x != end.x && start.y != end.y) continue;
                    start.x = (start.x + 0.5) * (double)gridSize;
                    start.y = (start.y + 0.5) * (double)gridSize;
                    end.x = (end.x + 0.5) * (double)gridSize;
                    end.y = (end.y + 0.5) * (double)gridSize;
                    renderer.renderLine(start, end, color[1], corridorWidth);
                    renderer.renderMidrect(start, color[1], (int)corridorWidth, (int)corridorWidth);
                }
            }
        }
        int locationDiameter = Math.min(renderer.getGridSizeX(), renderer.getGridSizeY()) * gridSize / 2;
        for (int x2 = 0; x2 < exits.length; ++x2) {
            for (int y2 = 0; y2 < exits[x2].length; ++y2) {
                if (monsters[x2][y2]) {
                    renderer.renderMidtriangle((int)(((double)x2 + 0.5) * (double)gridSize), (int)(((double)y2 + 0.5) * (double)gridSize), color[3], locationDiameter, locationDiameter, true);
                }
                if (rewards[x2][y2]) {
                    renderer.renderMidpoint((int)(((double)x2 + 0.5) * (double)gridSize), (int)(((double)y2 + 0.5) * (double)gridSize), color[4], locationDiameter, true);
                }
                if (!exits[x2][y2]) continue;
                renderer.renderMidrect((int)(((double)x2 + 0.5) * (double)gridSize), (int)(((double)y2 + 0.5) * (double)gridSize), color[5], locationDiameter, locationDiameter, true);
            }
        }
        return renderer;
    }
}

