/*
 * Decompiled with CFR 0.152.
 */
package experiments.aiide;

import experiments.fdg.Testbed;
import genetic.Embryogeny;
import genetic.FI2PopTrainer;
import genetic.Gene;
import genetic.GeneticAlgorithm;
import genetic.fitness.Fitness;
import genetic.fitness.WeightedFitness;
import genetic.logger.BestFitnessLogger;
import genetic.logger.SingleFitnessLogger;
import processing.core.PApplet;
import processing.core.PImage;
import strategymap.DetailConverter;
import strategymap.StrategySketch;
import strategymap.genetic.StrategySketchEmbryogeny;
import strategymap.genetic.StrategySketchGene;
import strategymap.genetic.StrategySketchGeneticAlgorithm;
import strategymap.genetic.fitness.FeasibleFitness;
import strategymap.genetic.fitness.InfeasibleFitness;
import strategymap.visualization.MapVisualizer;
import util.collections.ParameterCollection;
import util.statics.LogManager;

public class StrategyGame_FI2pop {
    final int totalRuns = 20;
    final int generations = 101;
    final StrategySketch testbed = Testbed.createTesbed2();

    public void experiment(WeightedFitness sfn, Fitness ifn, int mapSizeX, int mapSizeY, ParameterCollection params, String name) {
        String file = name + "/" + sfn.getLabel() + "/";
        PApplet p = new PApplet();
        SingleFitnessLogger logger = new SingleFitnessLogger(101, 20, (Fitness)sfn);
        BestFitnessLogger bLogger = new BestFitnessLogger(101, 20, sfn);
        LogManager.addLogfile("Best_" + sfn.getLabel(), file + "/bestIndividuals.xml");
        LogManager.addLogfile("Times_" + sfn.getLabel(), file + "/times.csv");
        int[][] allFeasible = new int[101][20];
        int[][] allMatches = new int[101][20];
        int[][] bestDifference = new int[101][20];
        double[][] feasibleDiversity = new double[101][20];
        for (int r = 1; r <= 20; ++r) {
            long startTime = System.currentTimeMillis();
            StrategySketchEmbryogeny sme = new StrategySketchEmbryogeny(mapSizeX, mapSizeY);
            StrategySketchGeneticAlgorithm ga = new StrategySketchGeneticAlgorithm(params);
            StrategySketchGeneticAlgorithm iga = new StrategySketchGeneticAlgorithm(params);
            ga.initializePopulation();
            iga.initializePopulation();
            FI2PopTrainer gTrainer = new FI2PopTrainer((Fitness)sfn, ifn, (Embryogeny)sme, (GeneticAlgorithm)ga, (GeneticAlgorithm)iga, params);
            gTrainer.shufflePopulations();
            gTrainer.setLogID(file + r + "/log");
            gTrainer.evaluateParents();
            gTrainer.setLogID(file + r + "/log");
            LogManager.addLogfile("MapOutput" + sfn.getLabel() + "_" + r, file + r + "/geneticalgorithm_map.log");
            for (int i = 0; i < 101; ++i) {
                logger.storeGeneration(i, r, gTrainer.getFeasibleTrainer());
                bLogger.storeGeneration(i, r, gTrainer.getFeasibleTrainer());
                int matches = 0;
                int bestDiff = Integer.MAX_VALUE;
                double currDiversity = 0.0;
                for (int j = 0; j < gTrainer.getFeasibleTrainer().getPopulation().getPopulationSize(); ++j) {
                    Gene cg = gTrainer.getFeasibleTrainer().getPopulation().getGene(j);
                    int tc = 0;
                    int cf = 0;
                    for (int k = 0; k < gTrainer.getFeasibleTrainer().getPopulation().getPopulationSize(); ++k) {
                        cf = (int)((float)cf + gTrainer.getFeasibleTrainer().getPopulation().getGene(k).getDifference(cg));
                        ++tc;
                    }
                    currDiversity += (double)cf / (double)tc;
                    if (this.testbed == null) continue;
                    int currDiff = this.testbed.getTileDifference((StrategySketch)cg.getPhenotype());
                    if (currDiff == 0) {
                        ++matches;
                    }
                    if (currDiff >= bestDiff) continue;
                    bestDiff = currDiff;
                }
                feasibleDiversity[i][r - 1] = currDiversity / (double)gTrainer.getFeasibleTrainer().getPopulation().getPopulationSize();
                allFeasible[i][r - 1] = gTrainer.getFeasibleTrainer().getPopulation().getPopulationSize();
                allMatches[i][r - 1] = matches;
                bestDifference[i][r - 1] = bestDiff;
                StrategySketchGene best = (StrategySketchGene)gTrainer.getBestFeasibleIndividual();
                if (best != null && i % 10 == 0) {
                    StrategySketch im = sme.createPhenotype(best.getGenotype());
                    PImage img = MapVisualizer.renderThumbnail(p, im, 80, 80).getImage();
                    img.save(file + r + "/bestIndividual" + i + ".png");
                    System.out.println(sfn.getLabel() + " (" + i + ") " + gTrainer.getFeasibleTrainer().getMaxFitness());
                    DetailConverter dc = new DetailConverter(im, 10, 10);
                    dc.generateMap();
                    PImage sprite_img = MapVisualizer.renderGradient(p, dc, mapSizeX * dc.getGridSizeX(), mapSizeY * dc.getGridSizeY()).getImage();
                    sprite_img.save(file + r + "/bestThumb" + i + "_sprite.png");
                }
                if (i >= 101) continue;
                gTrainer.train(1);
            }
            long elapsedTime = System.currentTimeMillis() - startTime;
            LogManager.write("Times_" + sfn.getLabel(), elapsedTime + "");
            logger.writeRun(r, file);
            bLogger.writeRun(r, file);
            if (gTrainer.getFeasibleTrainer().getBestIndividual() == null) continue;
            StrategySketchGene bestGene = (StrategySketchGene)gTrainer.getFeasibleTrainer().getBestIndividual();
            StrategySketch bestSketch = (StrategySketch)bestGene.getPhenotype();
            LogManager.write("Best_" + sfn.getLabel(), bestGene.toXML());
            PImage thumb = MapVisualizer.renderThumbnail(p, bestSketch).getImage();
            thumb.save(file + "/bestThumb" + r + ".png");
            DetailConverter dc = new DetailConverter(bestSketch, 10, 10);
            dc.generateMap();
            PImage sprite_img = MapVisualizer.renderGradient(p, dc, mapSizeX * dc.getGridSizeX(), mapSizeY * dc.getGridSizeY()).getImage();
            sprite_img.save(file + r + "/bestThumb" + r + "_sprite.png");
        }
        logger.writeAllProgress(file);
        bLogger.writeAllProgress(file);
        LogManager.addLogfile("FeasibleIndividuals" + sfn.getLabel(), file + "/feasibleIndividuals.csv");
        LogManager.addLogfile("FeasibleDiversity" + sfn.getLabel(), file + "/feasibleDiversity.csv");
        if (this.testbed != null) {
            LogManager.addLogfile("Matches" + sfn.getLabel(), file + "/matches.csv");
        }
        if (this.testbed != null) {
            LogManager.addLogfile("BestDifference" + sfn.getLabel(), file + "/bestDifference.csv");
        }
        String output1 = "";
        String output2 = "";
        String output3 = "";
        String output4 = "";
        for (int i = 0; i < allFeasible.length; ++i) {
            for (int r = 0; r < allFeasible[i].length; ++r) {
                output1 = output1 + allFeasible[i][r] + ";";
                output2 = output2 + allMatches[i][r] + ";";
                output3 = output3 + bestDifference[i][r] + ";";
                output4 = output4 + feasibleDiversity[i][r] + ";";
            }
            LogManager.write("FeasibleIndividuals" + sfn.getLabel(), output1);
            LogManager.write("FeasibleDiversity" + sfn.getLabel(), output4);
            if (this.testbed != null) {
                LogManager.write("Matches" + sfn.getLabel(), output2);
            }
            if (this.testbed != null) {
                LogManager.write("BestDifference" + sfn.getLabel(), output3);
            }
            output1 = "";
            output2 = "";
            output3 = "";
            output4 = "";
        }
    }

    public static void set_experiment(String name, int mapSizeX, int mapSizeY, int minBases, int maxBases, int minResources, int maxResources, int population) {
        LogManager.reset();
        StrategyGame_FI2pop smg = new StrategyGame_FI2pop();
        ParameterCollection params = new ParameterCollection();
        params.setParameter("population", population / 2);
        params.setParameter("maxGenerations", "500");
        params.setParameter("normalizeFitness", "1");
        params.setParameter("steadyPercentage", "1");
        params.setParameter("enforceMinFeasiblePopulation", "0.5");
        params.setParameter("normalizeFitness", "1");
        params.setParameter("steadyPercentage", "1");
        params.setParameter("repair", "1");
        params.setParameter("enforceMinFeasiblePopulation", "0.5");
        params.setParameter("crossoverPoints", "2");
        params.setParameter("mapSizeX", "" + mapSizeX);
        params.setParameter("mapSizeY", "" + mapSizeY);
        params.setParameter("genotypeMinResources", "" + minResources);
        params.setParameter("genotypeMaxResources", "" + maxResources);
        params.setParameter("genotypeMinBases", "" + minBases);
        params.setParameter("genotypeMaxBases", "" + maxBases);
        params.setParameter("mutateAnyProbability", "1");
        params.setParameter("mutateOnlyProbability", "0");
        params.setParameter("mutateTile", "5");
        params.setParameter("mutateBase", "0");
        params.setParameter("mutateResource", "0");
        params.setParameter("mutateShift", "5");
        params.setParameter("mutateDiagonal", "0");
        params.setParameter("mutateTileMinNumber", "" + (int)(0.05 * (double)mapSizeX * (double)mapSizeY));
        params.setParameter("mutateTileMaxNumber", "" + (int)(0.2 * (double)mapSizeX * (double)mapSizeY));
        params.setParameter("repair", "1");
        InfeasibleFitness ifn = new InfeasibleFitness(minBases, maxBases, minResources, maxResources);
        smg.experiment(new FeasibleFitness(0.25, 0.25, 0.0, 0.0, 0.25, 0.25), (Fitness)ifn, mapSizeX, mapSizeY, params, name);
    }

    public static void main(String[] args) {
        StrategyGame_FI2pop.set_experiment("experiment/aiide/strategy/12x12", 12, 12, 4, 4, 6, 15, 100);
    }
}

