/*
 * Decompiled with CFR 0.152.
 */
package experiments.evogames;

import experiments.logger.AllFitnessLogger;
import genetic.Embryogeny;
import genetic.FI2PopTrainer;
import genetic.GeneticAlgorithm;
import genetic.fitness.Fitness;
import genetic.fitness.WeightedFitness;
import processing.core.PApplet;
import processing.core.PImage;
import strategymap.StrategySketch;
import strategymap.genetic.StrategySketchEmbryogeny;
import strategymap.genetic.StrategySketchGene;
import strategymap.genetic.StrategySketchGeneticAlgorithm;
import strategymap.genetic.fitness.FeasibleFitness;
import strategymap.genetic.fitness.InfeasibleFitness;
import strategymap.visualization.MapVisualizer;
import util.collections.ParameterCollection;
import util.statics.LogManager;

public class Experiment_Standard {
    final boolean saveBestMap = false;
    final int totalRuns = 20;
    final int intervals = 101;
    final int genPerInterval = 1;
    static final int mapSize = 8;
    static final int minBases = 2;
    static final int maxBases = 2;
    static final int minResources = 4;
    static final int maxResources = 10;

    public void offlineExperiment(WeightedFitness fn, ParameterCollection params, String name) {
        String file = "./logs/strategymap/" + name + "/offline_simpleGA/" + fn.getLabel() + "/";
        PApplet p = new PApplet();
        ParameterCollection infParams = new ParameterCollection(params);
        infParams.setParameter("mutateAnyProbability", "1");
        infParams.setParameter("mutateOnlyProbability", "5");
        AllFitnessLogger logger = new AllFitnessLogger(101, 20, fn);
        LogManager.addLogfile("Best_" + fn.getLabel(), file + "/bestIndividuals.xml");
        LogManager.addLogfile("Times_" + fn.getLabel(), file + "/times.csv");
        LogManager.addLogfile("Diversity_" + fn.getLabel(), file + "/diversity.csv");
        for (int r = 1; r <= 20; ++r) {
            InfeasibleFitness ifn = new InfeasibleFitness(2, 2, 4, 10);
            long startTime = System.currentTimeMillis();
            StrategySketchGeneticAlgorithm ga = new StrategySketchGeneticAlgorithm(params);
            StrategySketchGeneticAlgorithm iga = new StrategySketchGeneticAlgorithm(infParams);
            ga.initializePopulation();
            ga.randomizePopulation();
            iga.initializePopulation();
            iga.randomizePopulation();
            StrategySketchEmbryogeny sme = new StrategySketchEmbryogeny(8, 8);
            FI2PopTrainer gTrainer = new FI2PopTrainer((Fitness)fn, (Fitness)ifn, (Embryogeny)sme, (GeneticAlgorithm)ga, (GeneticAlgorithm)iga, params);
            gTrainer.shufflePopulations();
            gTrainer.setLogID(file + r + "/log");
            LogManager.addLogfile("MapOutput" + fn.getLabel() + "_" + r, file + r + "/geneticalgorithm_map.log");
            for (int i = 0; i < 101; ++i) {
                LogManager.write("MapOutput" + fn.getLabel() + "_" + r, "generation " + i + "\n");
                LogManager.write("MapOutput" + fn.getLabel() + "_" + r, "best fitness " + gTrainer.getFeasibleTrainer().getMaxFitness());
                StrategySketchGene best = (StrategySketchGene)gTrainer.getFeasibleTrainer().getBestIndividual();
                if (best != null && i * 1 % 10 == 0) {
                    System.out.println(fn.getLabel() + " (" + i * 1 + ") " + gTrainer.getFeasibleTrainer().getMaxFitness());
                }
                logger.storeGeneration(i, r, gTrainer.getFeasibleTrainer());
                if (i < 101) {
                    gTrainer.train(1);
                }
                gTrainer.evaluateParents();
            }
            long elapsedTime = System.currentTimeMillis() - startTime;
            LogManager.write("Times_" + fn.getLabel(), elapsedTime + "");
            logger.writeRun(r, file);
            LogManager.write("Diversity_" + fn.getLabel(), gTrainer.getFeasibleTrainer().getPopulation().getDiversity() + "");
            StrategySketchGene bestGene = (StrategySketchGene)gTrainer.getFeasibleTrainer().getBestIndividual();
            PImage thumb = MapVisualizer.renderThumbnail(p, (StrategySketch)bestGene.getPhenotype()).getImage();
            thumb.save(file + "/bestThumb" + r + ".png");
        }
        logger.writeAllProgress(file);
    }

    public static void set_experiment(String name, int population) {
        LogManager.reset();
        ParameterCollection params = new ParameterCollection();
        params.setParameter("population", population / 2);
        params.setParameter("maxGenerations", "500");
        params.setParameter("normalizeFitness", "1");
        params.setParameter("steadyPercentage", "1");
        params.setParameter("enforceMinFeasiblePopulation", "0.5");
        params.setParameter("crossoverPoints", "2");
        params.setParameter("mapSizeX", "8");
        params.setParameter("mapSizeY", "8");
        params.setParameter("genotypeMinResources", "4");
        params.setParameter("genotypeMaxResources", "10");
        params.setParameter("genotypeMinBases", "2");
        params.setParameter("genotypeMaxBases", "2");
        params.setParameter("mutateAnyProbability", "1");
        params.setParameter("mutateOnlyProbability", "5");
        params.setParameter("repair", "1");
        params.setParameter("mutateTile", "5");
        params.setParameter("mutateBase", "0");
        params.setParameter("mutateResource", "1");
        params.setParameter("mutateShift", "15");
        params.setParameter("mutateDiagonal", "0");
        params.setParameter("mutateTileMinNumber", "2");
        params.setParameter("mutateTileMaxNumber", "6");
        Experiment_Standard smg = new Experiment_Standard();
        smg.offlineExperiment(new FeasibleFitness(0.3333333333333333, 0.0, 0.3333333333333333, 0.0, 0.3333333333333333, 0.0), params, name);
    }

    public static void main(String[] args) {
        Experiment_Standard.set_experiment("evoGames_20runs", 100);
    }
}

