/*
 * Decompiled with CFR 0.152.
 */
package experiments.fdg;

import experiments.fdg.Testbed;
import genetic.Embryogeny;
import genetic.FI2PopTrainer;
import genetic.Gene;
import genetic.GeneticAlgorithm;
import genetic.GeneticAlgorithmTrainer;
import genetic.GeneticAlgorithmTrainerGeneric;
import genetic.NoveltyTrainer;
import genetic.fitness.DifferenceFitness;
import genetic.fitness.Fitness;
import genetic.fitness.WeightedFitness;
import genetic.logger.BestFitnessLogger;
import genetic.logger.SingleFitnessLogger;
import processing.core.PApplet;
import processing.core.PImage;
import strategymap.StrategySketch;
import strategymap.genetic.StrategySketchEmbryogeny;
import strategymap.genetic.StrategySketchGene;
import strategymap.genetic.StrategySketchGeneticAlgorithm;
import strategymap.genetic.fitness.FeasibleFitness;
import strategymap.genetic.fitness.InfeasibleFitness;
import strategymap.genetic.fitness.SketchDifferenceFitness;
import strategymap.visualization.MapVisualizer;
import util.collections.ParameterCollection;
import util.statics.LogManager;

public class OfflineFI2PopNS {
    final int totalRuns = 120;
    final int generations = 101;
    final StrategySketch testbed = Testbed.createTesbed2();

    public void experiment(DifferenceFitness dfn, Fitness ifn, WeightedFitness rfn, int mapSizeX, int mapSizeY, ParameterCollection params, String name) {
        String file = name + "/" + rfn.getLabel() + "/";
        PApplet p = new PApplet();
        SingleFitnessLogger logger = new SingleFitnessLogger(101, 120, (Fitness)rfn);
        BestFitnessLogger bLogger = new BestFitnessLogger(101, 120, rfn);
        LogManager.addLogfile("Best_" + rfn.getLabel(), file + "/bestIndividuals.xml");
        LogManager.addLogfile("Times_" + rfn.getLabel(), file + "/times.csv");
        if (this.testbed != null) {
            System.out.println("is infeasible " + ifn.evaluateSpecific((Object)this.testbed));
            PImage thumb = MapVisualizer.renderThumbnail(p, this.testbed).getImage();
            thumb.save(file + "/testbed.png");
        }
        int[][] allFeasible = new int[101][120];
        int[][] allMatches = new int[101][120];
        int[][] bestDifference = new int[101][120];
        double[][] feasibleDiversity = new double[101][120];
        for (int r = 1; r <= 120; ++r) {
            long startTime = System.currentTimeMillis();
            StrategySketchEmbryogeny sme = new StrategySketchEmbryogeny(mapSizeX, mapSizeY);
            StrategySketchGeneticAlgorithm ga = new StrategySketchGeneticAlgorithm(params);
            StrategySketchGeneticAlgorithm iga = new StrategySketchGeneticAlgorithm(params);
            ga.initializePopulation();
            iga.initializePopulation();
            NoveltyTrainer gaTrainer = new NoveltyTrainer(dfn, (Embryogeny)sme, (GeneticAlgorithm)ga, params);
            GeneticAlgorithmTrainer igaTrainer = new GeneticAlgorithmTrainer(ifn, (Embryogeny)sme, (GeneticAlgorithm)iga, params);
            FI2PopTrainer gTrainer = new FI2PopTrainer(ifn, (GeneticAlgorithmTrainerGeneric)gaTrainer, (GeneticAlgorithmTrainerGeneric)igaTrainer, params);
            gTrainer.shufflePopulations();
            gTrainer.setLogID(file + r + "/log");
            LogManager.addLogfile("MapOutput" + rfn.getLabel() + "_" + r, file + r + "/geneticalgorithm_map.log");
            for (int i = 0; i < 101; ++i) {
                logger.storeGeneration(i, r, gTrainer.getFeasibleTrainer());
                bLogger.storeGeneration(i, r, gTrainer.getFeasibleTrainer());
                int matches = 0;
                int bestDiff = Integer.MAX_VALUE;
                double currDiversity = 0.0;
                for (int j = 0; j < gTrainer.getFeasibleTrainer().getPopulation().getPopulationSize(); ++j) {
                    Gene cg = gTrainer.getFeasibleTrainer().getPopulation().getGene(j);
                    int tc = 0;
                    int cf = 0;
                    for (int k = 0; k < gTrainer.getFeasibleTrainer().getPopulation().getPopulationSize(); ++k) {
                        cf = (int)((float)cf + gTrainer.getFeasibleTrainer().getPopulation().getGene(k).getDifference(cg));
                        ++tc;
                    }
                    currDiversity += (double)cf / (double)tc;
                    if (this.testbed == null) continue;
                    int currDiff = this.testbed.getTileDifference((StrategySketch)gTrainer.getFeasibleTrainer().getPopulation().getGene(j).getPhenotype());
                    if (currDiff == 0) {
                        ++matches;
                    }
                    if (currDiff >= bestDiff) continue;
                    bestDiff = currDiff;
                }
                feasibleDiversity[i][r - 1] = currDiversity / (double)gTrainer.getFeasibleTrainer().getPopulation().getPopulationSize();
                allFeasible[i][r - 1] = gTrainer.getFeasibleTrainer().getPopulation().getPopulationSize();
                allMatches[i][r - 1] = matches;
                bestDifference[i][r - 1] = bestDiff;
                StrategySketchGene best = (StrategySketchGene)gTrainer.getBestFeasibleIndividualCustom((Fitness)rfn);
                if (best != null && i % 10 == 0) {
                    StrategySketch im = sme.createPhenotype(best.getGenotype());
                    PImage img = MapVisualizer.renderThumbnail(p, im, 80, 80).getImage();
                    img.save(file + r + "/bestIndividual" + i + ".png");
                    System.out.println(rfn.getLabel() + " (" + i + ") " + gTrainer.getFeasibleTrainer().getMaxFitness());
                }
                if (i >= 101) continue;
                gTrainer.train(1);
            }
            long elapsedTime = System.currentTimeMillis() - startTime;
            LogManager.write("Times_" + rfn.getLabel(), elapsedTime + "");
            logger.writeRun(r, file);
            bLogger.writeRun(r, file);
            StrategySketchGene bestGene = (StrategySketchGene)gTrainer.getBestFeasibleIndividualCustom((Fitness)rfn);
            StrategySketch bestSketch = (StrategySketch)bestGene.getPhenotype();
            LogManager.write("Best_" + rfn.getLabel(), bestGene.toXML());
            PImage thumb = MapVisualizer.renderThumbnail(p, bestSketch).getImage();
            thumb.save(file + "/bestThumb" + r + ".png");
        }
        logger.writeAllProgress(file);
        bLogger.writeAllProgress(file);
        LogManager.addLogfile("FeasibleIndividuals" + rfn.getLabel(), file + "/feasibleIndividuals.csv");
        LogManager.addLogfile("FeasibleDiversity" + rfn.getLabel(), file + "/feasibleDiversity.csv");
        if (this.testbed != null) {
            LogManager.addLogfile("Matches" + rfn.getLabel(), file + "/matches.csv");
        }
        if (this.testbed != null) {
            LogManager.addLogfile("BestDifference" + rfn.getLabel(), file + "/bestDifference.csv");
        }
        String output1 = "";
        String output2 = "";
        String output3 = "";
        String output4 = "";
        for (int i = 0; i < allFeasible.length; ++i) {
            for (int r = 0; r < allFeasible[i].length; ++r) {
                output1 = output1 + allFeasible[i][r] + ";";
                output2 = output2 + allMatches[i][r] + ";";
                output3 = output3 + bestDifference[i][r] + ";";
                output4 = output4 + feasibleDiversity[i][r] + ";";
            }
            LogManager.write("FeasibleIndividuals" + rfn.getLabel(), output1);
            LogManager.write("FeasibleDiversity" + rfn.getLabel(), output4);
            if (this.testbed != null) {
                LogManager.write("Matches" + rfn.getLabel(), output2);
            }
            if (this.testbed != null) {
                LogManager.write("BestDifference" + rfn.getLabel(), output3);
            }
            output1 = "";
            output2 = "";
            output3 = "";
            output4 = "";
        }
    }

    public void experiment(WeightedFitness rfn, DifferenceFitness dfn, Fitness fcheck, int mapSizeX, int mapSizeY, ParameterCollection params, String name) {
        String file = name + "/" + rfn.getLabel() + "/";
        PApplet p = new PApplet();
        SingleFitnessLogger logger = new SingleFitnessLogger(101, 120, (Fitness)rfn);
        BestFitnessLogger bLogger = new BestFitnessLogger(101, 120, rfn);
        LogManager.addLogfile("Best_" + rfn.getLabel(), file + "/bestIndividuals.xml");
        LogManager.addLogfile("Times_" + rfn.getLabel(), file + "/times.csv");
        for (int r = 1; r <= 120; ++r) {
            long startTime = System.currentTimeMillis();
            StrategySketchEmbryogeny sme = new StrategySketchEmbryogeny(mapSizeX, mapSizeY);
            StrategySketchGeneticAlgorithm ga = new StrategySketchGeneticAlgorithm(params);
            StrategySketchGeneticAlgorithm iga = new StrategySketchGeneticAlgorithm(params);
            ga.initializePopulation();
            iga.initializePopulation();
            GeneticAlgorithmTrainer gaTrainer = new GeneticAlgorithmTrainer((Fitness)rfn, (Embryogeny)sme, (GeneticAlgorithm)ga, params);
            NoveltyTrainer igaTrainer = new NoveltyTrainer(dfn, (Embryogeny)sme, (GeneticAlgorithm)iga, params);
            FI2PopTrainer gTrainer = new FI2PopTrainer(fcheck, (GeneticAlgorithmTrainerGeneric)gaTrainer, (GeneticAlgorithmTrainerGeneric)igaTrainer, params);
            gTrainer.shufflePopulations();
            gTrainer.setLogID(file + r + "/log");
            LogManager.addLogfile("MapOutput" + rfn.getLabel() + "_" + r, file + r + "/geneticalgorithm_map.log");
            for (int i = 0; i < 101; ++i) {
                logger.storeGeneration(i, r, gTrainer.getFeasibleTrainer());
                bLogger.storeGeneration(i, r, gTrainer.getFeasibleTrainer());
                StrategySketchGene best = (StrategySketchGene)gTrainer.getBestFeasibleIndividualCustom((Fitness)rfn);
                if (best != null && i % 10 == 0) {
                    StrategySketch im = sme.createPhenotype(best.getGenotype());
                    PImage img = MapVisualizer.renderThumbnail(p, im, 80, 80).getImage();
                    img.save(file + r + "/bestIndividual" + i + ".png");
                    System.out.println(rfn.getLabel() + " (" + i + ") " + gTrainer.getFeasibleTrainer().getMaxFitness());
                }
                if (i >= 101) continue;
                gTrainer.train(1);
            }
            long elapsedTime = System.currentTimeMillis() - startTime;
            LogManager.write("Times_" + rfn.getLabel(), elapsedTime + "");
            logger.writeRun(r, file);
            bLogger.writeRun(r, file);
            if (gTrainer.getFeasibleTrainer().getBestIndividual() == null) continue;
            StrategySketchGene bestGene = (StrategySketchGene)gTrainer.getBestFeasibleIndividualCustom((Fitness)rfn);
            StrategySketch bestSketch = (StrategySketch)bestGene.getPhenotype();
            LogManager.write("Best_" + rfn.getLabel(), bestGene.toXML());
            PImage thumb = MapVisualizer.renderThumbnail(p, bestSketch).getImage();
            thumb.save(file + "/bestThumb" + r + ".png");
        }
        logger.writeAllProgress(file);
        bLogger.writeAllProgress(file);
    }

    public void experiment(DifferenceFitness fn, DifferenceFitness ifn, WeightedFitness rfn, Fitness fcheck, int mapSizeX, int mapSizeY, ParameterCollection params, String name) {
        String file = name + "/" + rfn.getLabel() + "/";
        PApplet p = new PApplet();
        SingleFitnessLogger logger = new SingleFitnessLogger(101, 120, (Fitness)rfn);
        BestFitnessLogger bLogger = new BestFitnessLogger(101, 120, rfn);
        LogManager.addLogfile("Best_" + rfn.getLabel(), file + "/bestIndividuals.xml");
        LogManager.addLogfile("Times_" + rfn.getLabel(), file + "/times.csv");
        for (int r = 1; r <= 120; ++r) {
            long startTime = System.currentTimeMillis();
            StrategySketchEmbryogeny sme = new StrategySketchEmbryogeny(mapSizeX, mapSizeY);
            StrategySketchGeneticAlgorithm ga = new StrategySketchGeneticAlgorithm(params);
            StrategySketchGeneticAlgorithm iga = new StrategySketchGeneticAlgorithm(params);
            ga.initializePopulation();
            iga.initializePopulation();
            NoveltyTrainer gaTrainer = new NoveltyTrainer(fn, (Embryogeny)sme, (GeneticAlgorithm)ga, params);
            NoveltyTrainer igaTrainer = new NoveltyTrainer(ifn, (Embryogeny)sme, (GeneticAlgorithm)iga, params);
            FI2PopTrainer gTrainer = new FI2PopTrainer(fcheck, (GeneticAlgorithmTrainerGeneric)gaTrainer, (GeneticAlgorithmTrainerGeneric)igaTrainer, params);
            gTrainer.shufflePopulations();
            gTrainer.setLogID(file + r + "/log");
            LogManager.addLogfile("MapOutput" + rfn.getLabel() + "_" + r, file + r + "/geneticalgorithm_map.log");
            for (int i = 0; i < 101; ++i) {
                logger.storeGeneration(i, r, gTrainer.getFeasibleTrainer());
                bLogger.storeGeneration(i, r, gTrainer.getFeasibleTrainer());
                StrategySketchGene best = (StrategySketchGene)gTrainer.getBestFeasibleIndividualCustom((Fitness)rfn);
                if (best != null && i % 10 == 0) {
                    StrategySketch im = sme.createPhenotype(best.getGenotype());
                    PImage img = MapVisualizer.renderThumbnail(p, im, 80, 80).getImage();
                    img.save(file + r + "/bestIndividual" + i + ".png");
                    System.out.println(rfn.getLabel() + " (" + i + ") " + gTrainer.getFeasibleTrainer().getMaxFitness());
                }
                if (i >= 101) continue;
                gTrainer.train(1);
            }
            long elapsedTime = System.currentTimeMillis() - startTime;
            LogManager.write("Times_" + rfn.getLabel(), elapsedTime + "");
            logger.writeRun(r, file);
            bLogger.writeRun(r, file);
            if (gTrainer.getFeasibleTrainer().getBestIndividual() == null) continue;
            StrategySketchGene bestGene = (StrategySketchGene)gTrainer.getBestFeasibleIndividualCustom((Fitness)rfn);
            StrategySketch bestSketch = (StrategySketch)bestGene.getPhenotype();
            LogManager.write("Best_" + rfn.getLabel(), bestGene.toXML());
            PImage thumb = MapVisualizer.renderThumbnail(p, bestSketch).getImage();
            thumb.save(file + "/bestThumb" + r + ".png");
        }
        logger.writeAllProgress(file);
        bLogger.writeAllProgress(file);
    }

    public static void set_experiment(String name, int mapSizeX, int mapSizeY, int minBases, int maxBases, int minResources, int maxResources, int population) {
        LogManager.reset();
        OfflineFI2PopNS smg = new OfflineFI2PopNS();
        ParameterCollection params = new ParameterCollection();
        params.setParameter("population", population / 2);
        params.setParameter("maxGenerations", "500");
        params.setParameter("normalizeFitness", "1");
        params.setParameter("steadyPercentage", "1");
        params.setParameter("enforceMinFeasiblePopulation", "0.5");
        params.setParameter("maxNeighbours", "20");
        params.setParameter("novelIndividualsPerGeneration", "5");
        params.setParameter("novelIndividualThreshold", "0.1");
        params.setParameter("crossoverPoints", "2");
        params.setParameter("mapSizeX", "" + mapSizeX);
        params.setParameter("mapSizeY", "" + mapSizeY);
        params.setParameter("genotypeMinResources", "" + minResources);
        params.setParameter("genotypeMaxResources", "" + maxResources);
        params.setParameter("genotypeMinBases", "" + minBases);
        params.setParameter("genotypeMaxBases", "" + maxBases);
        params.setParameter("mutateAnyProbability", "5");
        params.setParameter("mutateOnlyProbability", "1");
        params.setParameter("mutateTile", "5");
        params.setParameter("mutateBase", "0");
        params.setParameter("mutateResource", "1");
        params.setParameter("mutateShift", "15");
        params.setParameter("mutateDiagonal", "10");
        params.setParameter("mutateTileMinNumber", "2");
        params.setParameter("mutateTileMaxNumber", "6");
        InfeasibleFitness ifn = new InfeasibleFitness(minBases, maxBases, minResources, maxResources);
        SketchDifferenceFitness dfn = new SketchDifferenceFitness();
        int i = 0;
        smg.experiment(dfn, (Fitness)ifn, new FeasibleFitness(i, true), mapSizeX, mapSizeY, params, name + "F/" + mapSizeX + "x" + mapSizeY + "/");
    }

    public static void main(String[] args) {
        OfflineFI2PopNS.set_experiment("experiment/novelty", 8, 8, 2, 2, 4, 10, 100);
    }
}

