/*
 * Decompiled with CFR 0.152.
 */
package experiments.fdg;

import experiments.fitness.MCNSFeasibleFitness;
import genetic.Embryogeny;
import genetic.GeneticAlgorithm;
import genetic.GeneticAlgorithmTrainer;
import genetic.GeneticAlgorithmTrainerGeneric;
import genetic.fitness.Fitness;
import genetic.fitness.WeightedFitness;
import genetic.logger.BestFitnessLogger;
import genetic.logger.SingleFitnessLogger;
import processing.core.PApplet;
import processing.core.PImage;
import strategymap.StrategySketch;
import strategymap.genetic.StrategySketchEmbryogeny;
import strategymap.genetic.StrategySketchGene;
import strategymap.genetic.StrategySketchGeneticAlgorithm;
import strategymap.genetic.fitness.InfeasibleFitness;
import strategymap.visualization.MapVisualizer;
import util.collections.ParameterCollection;
import util.statics.LogManager;

public class OfflineGA_Species {
    final int totalRuns = 1;
    final int generations = 101;
    final StrategySketch testbed = null;

    public void experiment(WeightedFitness sfn, Fitness ifn, int mapSizeX, int mapSizeY, ParameterCollection params, String name) {
        String file = name + "/" + sfn.getLabel() + "/";
        PApplet p = new PApplet();
        SingleFitnessLogger logger = new SingleFitnessLogger(101, 1, (Fitness)sfn);
        BestFitnessLogger bLogger = new BestFitnessLogger(101, 1, sfn);
        LogManager.addLogfile("Best_" + sfn.getLabel(), file + "/bestIndividuals.xml");
        LogManager.addLogfile("Times_" + sfn.getLabel(), file + "/times.csv");
        int[][] allFeasible = new int[101][1];
        int[][] allMatches = new int[101][1];
        int[][] bestDifference = new int[101][1];
        double[][] feasibleDiversity = new double[101][1];
        for (int r = 1; r <= 1; ++r) {
            long startTime = System.currentTimeMillis();
            StrategySketchEmbryogeny sme = new StrategySketchEmbryogeny(mapSizeX, mapSizeY);
            StrategySketchGeneticAlgorithm ga = new StrategySketchGeneticAlgorithm(params);
            ga.initializePopulation();
            ga.randomizePopulation();
            GeneticAlgorithmTrainer gTrainer = new GeneticAlgorithmTrainer((Fitness)sfn, (Embryogeny)sme, (GeneticAlgorithm)ga, params);
            gTrainer.evaluateParents();
            gTrainer.setLogID(file + r + "/log");
            gTrainer.evaluateParents();
            gTrainer.setLogID(file + r + "/log");
            LogManager.addLogfile("MapOutput" + sfn.getLabel() + "_" + r, file + r + "/geneticalgorithm_map.log");
            for (int i = 0; i < 101; ++i) {
                logger.storeGeneration(i, r, (GeneticAlgorithmTrainerGeneric)gTrainer);
                bLogger.storeGeneration(i, r, (GeneticAlgorithmTrainerGeneric)gTrainer);
                int feasible = 0;
                int infeasible = 0;
                int matches = 0;
                int bestDiff = Integer.MAX_VALUE;
                double currDiversity = 0.0;
                for (int j = 0; j < gTrainer.getPopulation().getPopulationSize(); ++j) {
                    if (ifn.evaluate(gTrainer.getPopulation().getGene(j).getPhenotype()) != 0.0) {
                        ++infeasible;
                        continue;
                    }
                    int tc = 0;
                    int cf = 0;
                    for (int k = 0; k < gTrainer.getPopulation().getPopulationSize(); ++k) {
                        if (ifn.evaluate(gTrainer.getPopulation().getGene(k).getPhenotype()) != 0.0) continue;
                        cf = (int)((float)cf + gTrainer.getPopulation().getGene(k).getDifference(gTrainer.getPopulation().getGene(j)));
                        ++tc;
                    }
                    currDiversity += (double)cf / (double)tc;
                    ++feasible;
                    if (this.testbed == null) continue;
                    int currDiff = this.testbed.getTileDifference((StrategySketch)gTrainer.getPopulation().getGene(j).getPhenotype());
                    if (currDiff == 0) {
                        ++matches;
                    }
                    if (currDiff >= bestDiff) continue;
                    bestDiff = currDiff;
                }
                allFeasible[i][r - 1] = feasible;
                allMatches[i][r - 1] = matches;
                bestDifference[i][r - 1] = bestDiff;
                feasibleDiversity[i][r - 1] = currDiversity / (double)feasible;
                StrategySketchGene best = (StrategySketchGene)gTrainer.getBestIndividual();
                if (best != null && i % 10 == 0) {
                    StrategySketch im = sme.createPhenotype(best.getGenotype());
                    PImage img = MapVisualizer.renderThumbnail(p, im, 80, 80).getImage();
                    img.save(file + r + "/bestIndividual" + i + ".png");
                    System.out.println(sfn.getLabel() + " (" + i + ") " + gTrainer.getMaxFitness());
                }
                gTrainer.writeSpeciesProgress();
                if (i >= 101) continue;
                gTrainer.train(1);
            }
            long elapsedTime = System.currentTimeMillis() - startTime;
            LogManager.write("Times_" + sfn.getLabel(), elapsedTime + "");
            logger.writeRun(r, file);
            bLogger.writeRun(r, file);
            if (gTrainer.getBestIndividual() == null) continue;
            StrategySketchGene bestGene = (StrategySketchGene)gTrainer.getBestIndividual();
            StrategySketch bestSketch = (StrategySketch)bestGene.getPhenotype();
            LogManager.write("Best_" + sfn.getLabel(), bestGene.toXML());
            PImage thumb = MapVisualizer.renderThumbnail(p, bestSketch).getImage();
            thumb.save(file + "/bestThumb" + r + "_" + bestGene.getFitness() + ".png");
        }
        logger.writeAllProgress(file);
        bLogger.writeAllProgress(file);
        LogManager.addLogfile("FeasibleIndividuals" + sfn.getLabel(), file + "/feasibleIndividuals.csv");
        LogManager.addLogfile("FeasibleDiversity" + sfn.getLabel(), file + "/feasibleDiversity.csv");
        if (this.testbed != null) {
            LogManager.addLogfile("Matches" + sfn.getLabel(), file + "/matches.csv");
        }
        if (this.testbed != null) {
            LogManager.addLogfile("BestDifference" + sfn.getLabel(), file + "/bestDifference.csv");
        }
        String output1 = "";
        String output2 = "";
        String output3 = "";
        String output4 = "";
        for (int i = 0; i < allFeasible.length; ++i) {
            for (int r = 0; r < allFeasible[i].length; ++r) {
                output1 = output1 + allFeasible[i][r] + ";";
                output2 = output2 + allMatches[i][r] + ";";
                output3 = output3 + bestDifference[i][r] + ";";
                output4 = output4 + feasibleDiversity[i][r] + ";";
            }
            LogManager.write("FeasibleIndividuals" + sfn.getLabel(), output1);
            LogManager.write("FeasibleDiversity" + sfn.getLabel(), output4);
            if (this.testbed != null) {
                LogManager.write("Matches" + sfn.getLabel(), output2);
            }
            if (this.testbed != null) {
                LogManager.write("BestDifference" + sfn.getLabel(), output3);
            }
            output1 = "";
            output2 = "";
            output3 = "";
            output4 = "";
        }
    }

    public static void set_experiment(String name, int mapSizeX, int mapSizeY, int minBases, int maxBases, int minResources, int maxResources, int population) {
        LogManager.reset();
        OfflineGA_Species smg = new OfflineGA_Species();
        ParameterCollection params = new ParameterCollection();
        params.setParameter("population", population);
        params.setParameter("maxGenerations", "500");
        params.setParameter("normalizeFitness", "1");
        params.setParameter("steadyPercentage", "1");
        params.setParameter("crossoverPoints", "2");
        params.setParameter("mapSizeX", "" + mapSizeX);
        params.setParameter("mapSizeY", "" + mapSizeY);
        params.setParameter("genotypeMinResources", "" + minResources);
        params.setParameter("genotypeMaxResources", "" + maxResources);
        params.setParameter("genotypeMinBases", "" + minBases);
        params.setParameter("genotypeMaxBases", "" + maxBases);
        params.setParameter("mutateAnyProbability", "5");
        params.setParameter("mutateOnlyProbability", "1");
        params.setParameter("mutateTile", "5");
        params.setParameter("mutateBase", "0");
        params.setParameter("mutateResource", "1");
        params.setParameter("mutateShift", "15");
        params.setParameter("mutateDiagonal", "10");
        params.setParameter("mutateTileMinNumber", "2");
        params.setParameter("mutateTileMaxNumber", "6");
        params.setParameter("repair", "1");
        params.setParameter("speciesTargetNumber", "10");
        params.setParameter("incDifferenceThreshold", "10");
        params.setParameter("minDifferenceThreshold", "10");
        params.setParameter("initialDifferenceThreshold", "80");
        InfeasibleFitness ifn = new InfeasibleFitness(minBases, maxBases, minResources, maxResources);
        smg.experiment(new MCNSFeasibleFitness(1), (Fitness)ifn, mapSizeX, mapSizeY, params, name);
    }

    public static void main(String[] args) {
        OfflineGA_Species.set_experiment("experiment/onepopGA_species/8x8", 8, 8, 2, 2, 4, 10, 100);
    }
}

