/*
 * Decompiled with CFR 0.152.
 */
package experiments.fdg;

import experiments.fitness.MCNSFeasibleFitness;
import experiments.fitness.NSDifference;
import genetic.Embryogeny;
import genetic.GeneticAlgorithm;
import genetic.GeneticAlgorithmTrainerGeneric;
import genetic.NoveltyTrainer;
import genetic.fitness.DifferenceFitness;
import genetic.fitness.Fitness;
import genetic.fitness.WeightedFitness;
import genetic.logger.BestFitnessLogger;
import genetic.logger.SingleFitnessLogger;
import processing.core.PApplet;
import processing.core.PImage;
import strategymap.StrategySketch;
import strategymap.genetic.StrategySketchEmbryogeny;
import strategymap.genetic.StrategySketchGene;
import strategymap.genetic.StrategySketchGeneticAlgorithm;
import strategymap.genetic.fitness.InfeasibleFitness;
import strategymap.visualization.MapVisualizer;
import util.collections.ParameterCollection;
import util.statics.LogManager;

public class OfflineNoveltySearch {
    final int totalRuns = 20;
    final int generations = 101;
    final StrategySketch testbed = null;

    public void experiment(DifferenceFitness dfn, Fitness fCheck, WeightedFitness rfn, int mapSizeX, int mapSizeY, ParameterCollection params, String name) {
        String file = name + "/" + rfn.getLabel() + "/";
        PApplet p = new PApplet();
        if (this.testbed != null) {
            PImage thumb = MapVisualizer.renderThumbnail(p, this.testbed).getImage();
            thumb.save(file + "/testbed.png");
        }
        SingleFitnessLogger logger = new SingleFitnessLogger(101, 20, (Fitness)rfn);
        BestFitnessLogger bLogger = new BestFitnessLogger(101, 20, rfn);
        LogManager.addLogfile("Best_" + rfn.getLabel(), file + "/bestIndividuals.xml");
        LogManager.addLogfile("Times_" + rfn.getLabel(), file + "/times.csv");
        int[][] allFeasible = new int[101][20];
        int[][] allMatches = new int[101][20];
        int[][] bestDifference = new int[101][20];
        double[][] feasibleDiversity = new double[101][20];
        for (int r = 1; r <= 20; ++r) {
            long startTime = System.currentTimeMillis();
            StrategySketchEmbryogeny sme = new StrategySketchEmbryogeny(mapSizeX, mapSizeY);
            StrategySketchGeneticAlgorithm ga = new StrategySketchGeneticAlgorithm(params);
            ga.initializePopulation();
            NoveltyTrainer gTrainer = new NoveltyTrainer(dfn, (Embryogeny)sme, (GeneticAlgorithm)ga, params);
            gTrainer.setLogID(file + r + "/log");
            gTrainer.evaluateParents();
            LogManager.addLogfile("MapOutput" + rfn.getLabel() + "_" + r, file + r + "/geneticalgorithm_map.log");
            LogManager.addLogfile("Population" + rfn.getLabel() + "_" + r, file + r + "/log_populationProgress.csv");
            LogManager.write("Population" + rfn.getLabel() + "_" + r, "infeasible;feasible");
            for (int i = 0; i < 101; ++i) {
                logger.storeGeneration(i, r, (GeneticAlgorithmTrainerGeneric)gTrainer);
                bLogger.storeGeneration(i, r, (GeneticAlgorithmTrainerGeneric)gTrainer);
                int feasible = 0;
                int infeasible = 0;
                int matches = 0;
                int bestDiff = Integer.MAX_VALUE;
                double currDiversity = 0.0;
                for (int j = 0; j < gTrainer.getPopulation().getPopulationSize(); ++j) {
                    if (fCheck.evaluate(gTrainer.getPopulation().getGene(j).getPhenotype()) != 0.0) {
                        ++infeasible;
                        continue;
                    }
                    int tc = 0;
                    int cf = 0;
                    for (int k = 0; k < gTrainer.getPopulation().getPopulationSize(); ++k) {
                        if (fCheck.evaluate(gTrainer.getPopulation().getGene(k).getPhenotype()) != 0.0) continue;
                        cf = (int)((float)cf + gTrainer.getPopulation().getGene(k).getDifference(gTrainer.getPopulation().getGene(j)));
                        ++tc;
                    }
                    currDiversity += (double)cf / (double)tc;
                    ++feasible;
                    if (this.testbed == null) continue;
                    int currDiff = this.testbed.getTileDifference((StrategySketch)gTrainer.getPopulation().getGene(j).getPhenotype());
                    if (currDiff == 0) {
                        ++matches;
                    }
                    if (currDiff >= bestDiff) continue;
                    bestDiff = currDiff;
                }
                allFeasible[i][r - 1] = feasible;
                allMatches[i][r - 1] = matches;
                bestDifference[i][r - 1] = bestDiff;
                feasibleDiversity[i][r - 1] = currDiversity / (double)feasible;
                LogManager.write("Population" + rfn.getLabel() + "_" + r, infeasible + ";" + feasible);
                StrategySketchGene best = (StrategySketchGene)gTrainer.getBestIndividualCustom((Fitness)rfn);
                if (best != null && i % 10 == 0) {
                    StrategySketch im = sme.createPhenotype(best.getGenotype());
                    PImage img = MapVisualizer.renderThumbnail(p, im, 80, 80).getImage();
                    img.save(file + r + "/bestIndividual" + i + ".png");
                    System.out.println(rfn.getLabel() + " (" + i + ") " + gTrainer.getMaxFitness());
                }
                if (i >= 101) continue;
                gTrainer.train(1);
            }
            long elapsedTime = System.currentTimeMillis() - startTime;
            LogManager.write("Times_" + rfn.getLabel(), elapsedTime + "");
            logger.writeRun(r, file);
            bLogger.writeRun(r, file);
            StrategySketchGene bestGene = (StrategySketchGene)gTrainer.getBestIndividualCustom((Fitness)rfn);
            StrategySketch bestSketch = (StrategySketch)bestGene.getPhenotype();
            LogManager.write("Best_" + rfn.getLabel(), bestGene.toXML());
            PImage thumb = MapVisualizer.renderThumbnail(p, bestSketch).getImage();
            thumb.save(file + "/bestThumb" + r + ".png");
        }
        logger.writeAllProgress(file);
        bLogger.writeAllProgress(file);
        LogManager.addLogfile("FeasibleIndividuals" + rfn.getLabel(), file + "/feasibleIndividuals.csv");
        LogManager.addLogfile("FeasibleDiversity" + rfn.getLabel(), file + "/feasibleDiversity.csv");
        if (this.testbed != null) {
            LogManager.addLogfile("Matches" + rfn.getLabel(), file + "/matches.csv");
        }
        if (this.testbed != null) {
            LogManager.addLogfile("BestDifference" + rfn.getLabel(), file + "/bestDifference.csv");
        }
        String output1 = "";
        String output2 = "";
        String output3 = "";
        String output4 = "";
        for (int i = 0; i < allFeasible.length; ++i) {
            for (int r = 0; r < allFeasible[i].length; ++r) {
                output1 = output1 + allFeasible[i][r] + ";";
                output2 = output2 + allMatches[i][r] + ";";
                output3 = output3 + bestDifference[i][r] + ";";
                output4 = output4 + feasibleDiversity[i][r] + ";";
            }
            LogManager.write("FeasibleIndividuals" + rfn.getLabel(), output1);
            LogManager.write("FeasibleDiversity" + rfn.getLabel(), output4);
            if (this.testbed != null) {
                LogManager.write("Matches" + rfn.getLabel(), output2);
            }
            if (this.testbed != null) {
                LogManager.write("BestDifference" + rfn.getLabel(), output3);
            }
            output1 = "";
            output2 = "";
            output3 = "";
            output4 = "";
        }
    }

    public static void set_experiment(String name, int mapSizeX, int mapSizeY, int minBases, int maxBases, int minResources, int maxResources, int population) {
        LogManager.reset();
        OfflineNoveltySearch smg = new OfflineNoveltySearch();
        ParameterCollection params = new ParameterCollection();
        params.setParameter("population", population);
        params.setParameter("maxGenerations", "500");
        params.setParameter("normalizeFitness", "1");
        params.setParameter("steadyPercentage", "1");
        params.setParameter("enforceMinFeasiblePopulation", "0.5");
        params.setParameter("maxNeighbours", "20");
        params.setParameter("novelIndividualsPerGeneration", "5");
        params.setParameter("novelIndividualThreshold", "0.1");
        params.setParameter("crossoverPoints", "2");
        params.setParameter("mapSizeX", "" + mapSizeX);
        params.setParameter("mapSizeY", "" + mapSizeY);
        params.setParameter("genotypeMinResources", "" + minResources);
        params.setParameter("genotypeMaxResources", "" + maxResources);
        params.setParameter("genotypeMinBases", "" + minBases);
        params.setParameter("genotypeMaxBases", "" + maxBases);
        params.setParameter("mutateAnyProbability", "5");
        params.setParameter("mutateOnlyProbability", "1");
        params.setParameter("mutateTile", "5");
        params.setParameter("mutateBase", "0");
        params.setParameter("mutateResource", "1");
        params.setParameter("mutateShift", "15");
        params.setParameter("mutateDiagonal", "10");
        params.setParameter("mutateTileMinNumber", "2");
        params.setParameter("mutateTileMaxNumber", "6");
        InfeasibleFitness ifn = new InfeasibleFitness(minBases, maxBases, minResources, maxResources);
        NSDifference mcdfn = new NSDifference();
        int i = 0;
        smg.experiment(mcdfn, (Fitness)ifn, new MCNSFeasibleFitness(i, true), mapSizeX, mapSizeY, params, name + "F/" + mapSizeX + "x" + mapSizeY + "/");
    }

    public static void main(String[] args) {
        OfflineNoveltySearch.set_experiment("experiment/singleNS", 16, 16, 8, 8, 12, 30, 100);
    }
}

