/*
 * Decompiled with CFR 0.152.
 */
package experiments.fitness;

import genetic.fitness.Fitness;
import genetic.fitness.WeightedFitness;
import java.util.Arrays;
import strategymap.StrategySketch;
import util.image.processing.Thresholding;
import util.math2d.Matrix2D;
import util.math2d.Point2D;
import util.statics.LogManager;

public class MCNSFeasibleFitness
extends WeightedFitness {
    public float minSafety = 0.35f;
    public static final String[] labels = new String[]{"Resource Safety", "Safe Area", "Exploration", "Resource Safety Fairness", "Safe Area Fairness", "Exploration Fairness"};

    public MCNSFeasibleFitness() {
        this.add(1.0, new ResourceSafetyFitness());
        this.add(1.0, new SafeAreaFitness());
        this.add(1.0, new ExplorationFitness());
        this.add(1.0, new ResourceSafetyFairnessFitness());
        this.add(1.0, new SafeAreaFairnessFitness());
        this.add(1.0, new ExplorationFairnessFitness());
    }

    public MCNSFeasibleFitness(double w_resSafe, double w_resSafeFairness, double w_safeArea, double w_safeAreaFairness, double w_exploration, double w_explorationFairness) {
        if (w_resSafe != 0.0) {
            this.add(w_resSafe, new ResourceSafetyFitness());
        }
        if (w_safeArea != 0.0) {
            this.add(w_safeArea, new SafeAreaFitness());
        }
        if (w_exploration != 0.0) {
            this.add(w_exploration, new ExplorationFitness());
        }
        if (w_resSafeFairness != 0.0) {
            this.add(w_resSafeFairness, new ResourceSafetyFairnessFitness());
        }
        if (w_safeAreaFairness != 0.0) {
            this.add(w_safeAreaFairness, new SafeAreaFairnessFitness());
        }
        if (w_explorationFairness != 0.0) {
            this.add(w_explorationFairness, new ExplorationFairnessFitness());
        }
    }

    public MCNSFeasibleFitness(int index) {
        this(index, true);
    }

    public MCNSFeasibleFitness(int index, boolean positive) {
        double w;
        double d = w = positive ? 1.0 : -1.0;
        if (index == 0) {
            this.add(w, new ResourceSafetyFitness());
        } else if (index == 1) {
            this.add(w, new SafeAreaFitness());
        } else if (index == 2) {
            this.add(w, new ExplorationFitness());
        } else if (index == 3) {
            this.add(w, new ResourceSafetyFairnessFitness());
        } else if (index == 4) {
            this.add(w, new SafeAreaFairnessFitness());
        } else if (index == 5) {
            this.add(w, new ExplorationFairnessFitness());
        } else {
            LogManager.writeError("Error", (Object)this, "Feasible fitness " + index + " doesn't exist");
        }
        if (positive) {
            this.setLabel(labels[index]);
        } else {
            this.setLabel("inv_" + labels[index]);
        }
    }

    class ExplorationFairnessFitness
    extends Fitness<StrategySketch> {
        public ExplorationFairnessFitness() {
            this.label = "Exploration Fairness";
        }

        public double evaluateSpecific(StrategySketch phenotype) {
            if (phenotype.getBaseLength() < 2) {
                return 0.0;
            }
            if (phenotype.getPaths().getBasePaths().size() < phenotype.getBaseLength() * (phenotype.getBaseLength() - 1) / 2) {
                return 0.0;
            }
            double result = 0.0;
            float[] baseExplorations = new float[phenotype.getBaseLength()];
            for (int i = 0; i < phenotype.getBaseLength(); ++i) {
                baseExplorations[i] = Matrix2D.count(phenotype.getPaths().getExplorationMatrix(i));
            }
            int comparisons = 0;
            for (int i = 0; i < baseExplorations.length; ++i) {
                for (int j = 0; j < baseExplorations.length; ++j) {
                    if (i == j) continue;
                    result += (double)Math.abs(baseExplorations[i] - baseExplorations[j]) / (double)Math.max(baseExplorations[i], baseExplorations[j]);
                    ++comparisons;
                }
            }
            return 1.0 - (result /= (double)comparisons);
        }
    }

    class SafeAreaFairnessFitness
    extends Fitness<StrategySketch> {
        public SafeAreaFairnessFitness() {
            this.label = "Safe Area Fairness";
        }

        public double evaluateSpecific(StrategySketch phenotype) {
            if (phenotype.getBaseLength() < 2) {
                return 0.0;
            }
            if (phenotype.getPaths().getBasePaths().size() < phenotype.getBaseLength() * (phenotype.getBaseLength() - 1) / 2) {
                return 0.0;
            }
            double result = 0.0;
            int totalPassable = phenotype.getMapSizeX() * phenotype.getMapSizeY() - Matrix2D.count(phenotype.getImpassableArray());
            double[] baseAreas = new double[phenotype.getBaseLength()];
            for (int i = 0; i < phenotype.getBaseLength(); ++i) {
                baseAreas[i] = Matrix2D.count(Thresholding.getArrayAboveValue(phenotype.getPaths().getSafetyMatrix(i), MCNSFeasibleFitness.this.minSafety));
            }
            int comparisons = 0;
            for (int i = 0; i < baseAreas.length; ++i) {
                for (int j = 0; j < baseAreas.length; ++j) {
                    if (i == j) continue;
                    result += Math.abs(baseAreas[i] - baseAreas[j]) / Math.max(baseAreas[i], baseAreas[j]);
                    ++comparisons;
                }
            }
            return 1.0 - (result /= (double)comparisons);
        }
    }

    class ResourceSafetyFairnessFitness
    extends Fitness<StrategySketch> {
        public ResourceSafetyFairnessFitness() {
            this.label = "Resource Safety Fairness";
        }

        public double evaluateSpecific(StrategySketch phenotype) {
            if (phenotype.getBaseLength() < 2 || phenotype.getResourceLength() == 0) {
                return 0.0;
            }
            double result = 0.0;
            boolean comparisons = false;
            float[] avgSafety = new float[phenotype.getBaseLength()];
            for (int i = 0; i < phenotype.getResourceLength(); ++i) {
                Point2D resPoint = phenotype.getResource(i);
                int j = 0;
                while (j < phenotype.getBaseLength()) {
                    float safety = phenotype.getPaths().getSafety((int)resPoint.x, (int)resPoint.y, j);
                    if (safety == -1.0f) {
                        return 0.0;
                    }
                    int n = j++;
                    avgSafety[n] = avgSafety[n] + safety;
                }
            }
            for (int j = 0; j < phenotype.getBaseLength(); ++j) {
                for (int k = j + 1; k < phenotype.getBaseLength(); ++k) {
                    result += (double)Math.abs(avgSafety[j] - avgSafety[k]);
                }
            }
            return 1.0 - (result /= (double)((phenotype.getBaseLength() - 1) * phenotype.getResourceLength()));
        }
    }

    class ExplorationFitness
    extends Fitness<StrategySketch> {
        public ExplorationFitness() {
            this.label = "Exploration";
        }

        public double evaluateSpecific(StrategySketch phenotype) {
            if (phenotype.getBaseLength() < 2) {
                return 0.0;
            }
            if (phenotype.getPaths().getBasePaths().size() < phenotype.getBaseLength() * (phenotype.getBaseLength() - 1) / 2) {
                return 0.0;
            }
            double result = 0.0;
            int totalPassable = phenotype.getMapSizeX() * phenotype.getMapSizeY() - Matrix2D.count(phenotype.getImpassableArray());
            float[] explorationAreas = new float[phenotype.getBaseLength()];
            for (int i = 0; i < phenotype.getBaseLength(); ++i) {
                explorationAreas[i] = Matrix2D.count(phenotype.getPaths().getExplorationMatrix(i));
                result += (double)explorationAreas[i] / (double)totalPassable;
            }
            return result /= (double)phenotype.getBaseLength();
        }
    }

    class SafeAreaFitness
    extends Fitness<StrategySketch> {
        public SafeAreaFitness() {
            this.label = "Safe Area";
        }

        public double evaluateSpecific(StrategySketch phenotype) {
            if (phenotype.getBaseLength() < 2) {
                return 0.0;
            }
            if (phenotype.getPaths().getBasePaths().size() < phenotype.getBaseLength() * (phenotype.getBaseLength() - 1) / 2) {
                return 0.0;
            }
            double result = 0.0;
            int totalPassable = phenotype.getMapSizeX() * phenotype.getMapSizeY() - Matrix2D.count(phenotype.getImpassableArray());
            int[] baseAreas = new int[phenotype.getBaseLength()];
            for (int i = 0; i < phenotype.getBaseLength(); ++i) {
                baseAreas[i] = Matrix2D.count(Thresholding.getArrayAboveValue(phenotype.getPaths().getSafetyMatrix(i), MCNSFeasibleFitness.this.minSafety));
                result += (double)baseAreas[i];
            }
            return result /= (double)totalPassable;
        }
    }

    class ResourceSafetyFitness
    extends Fitness<StrategySketch> {
        public ResourceSafetyFitness() {
            this.label = "Resource Safety";
        }

        public double evaluateSpecific(StrategySketch phenotype) {
            if (phenotype.getBaseLength() < 2 || phenotype.getResourceLength() == 0) {
                return 0.0;
            }
            double result = 0.0;
            for (int i = 0; i < phenotype.getResourceLength(); ++i) {
                Point2D resPoint = phenotype.getResource(i);
                float[] safetyPerBase = phenotype.getPaths().getSafety((int)resPoint.x, (int)resPoint.y);
                Arrays.sort(safetyPerBase);
                if (safetyPerBase[0] == -1.0f) {
                    return 0.0;
                }
                result += (double)safetyPerBase[safetyPerBase.length - 1];
            }
            return result /= (double)phenotype.getResourceLength();
        }
    }
}

