/*
 * Decompiled with CFR 0.152.
 */
package experiments.gecco;

import experiments.fitness.MCNSDifference;
import experiments.fitness.NSDifference;
import experiments.gecco.OfflineExperiment;
import genetic.FI2PopTrainer;
import genetic.GeneticAlgorithm;
import genetic.GeneticAlgorithmTrainer;
import genetic.GeneticAlgorithmTrainerGeneric;
import genetic.NoveltyTrainer;
import strategymap.genetic.StrategySketchGeneticAlgorithm;
import strategymap.genetic.fitness.InfeasibleFitness;

public class OfflineCollection {
    static final boolean seedFeasible = false;

    public OfflineCollection(int totalRuns, int[] generationMode, int population, int maxGenerations) {
        boolean saveSpaceships = false;
        String file_end = "" + generationMode[0] + "x" + generationMode[1] + "_b" + generationMode[2] + "-" + generationMode[3] + "_r" + generationMode[4] + "-" + generationMode[5] + "_" + population + "_" + totalRuns;
        E_OfflineFI2NS experiment1 = new E_OfflineFI2NS(totalRuns, generationMode, population, maxGenerations, "FI2NS_" + file_end, saveSpaceships, false);
        E_OfflineFI2NS experiment2 = new E_OfflineFI2NS(totalRuns, generationMode, population, maxGenerations, "FI2NS_boost_" + file_end, saveSpaceships, true);
        E_OfflineFINS experiment3 = new E_OfflineFINS(totalRuns, generationMode, population, maxGenerations, "FINS_" + file_end, saveSpaceships, false);
        E_OfflineFINS experiment4 = new E_OfflineFINS(totalRuns, generationMode, population, maxGenerations, "FINS_boost_" + file_end, saveSpaceships, true);
        E_OfflineMCNS experiment5 = new E_OfflineMCNS(totalRuns, generationMode, population, maxGenerations, "MCNS_" + file_end, saveSpaceships);
        E_OfflineNoveltySearch experiment6 = new E_OfflineNoveltySearch(totalRuns, generationMode, population, maxGenerations, "NoveltySearch_" + file_end, saveSpaceships);
        experiment1.run();
        experiment2.run();
        experiment3.run();
        experiment4.run();
        experiment5.run();
        experiment6.run();
    }

    public static void main(String[] args) {
        boolean smallMap = true;
        int[] generationMode = new int[]{8, 8, 2, 2, 4, 10};
        OfflineCollection experiment = new OfflineCollection(20, generationMode, 100, 101);
    }

    class E_OfflineNoveltySearch
    extends OfflineExperiment {
        public E_OfflineNoveltySearch(int totalRuns, int[] generationMode, int population, int maxGenerations, String filesuffix, boolean saveSpaceships) {
            super(totalRuns, generationMode, population, maxGenerations, filesuffix, saveSpaceships);
            this.fCheck = new InfeasibleFitness(generationMode[2], generationMode[3], generationMode[4], generationMode[5]);
            this.dfn = new NSDifference();
            this.initParameters();
            this.gaParameters.setParameter("population", population);
        }

        @Override
        protected void initializeTrainer() {
            StrategySketchGeneticAlgorithm ga = new StrategySketchGeneticAlgorithm(this.gaParameters);
            this.gaParameters.setParameter("repair", "1");
            ga.initializePopulation();
            this.nTrainer = new NoveltyTrainer(this.dfn, this.embryogeny, (GeneticAlgorithm)ga, this.gaParameters);
            this.nTrainer.evaluateParents();
        }
    }

    class E_OfflineMCNS
    extends OfflineExperiment {
        public E_OfflineMCNS(int totalRuns, int[] generationMode, int population, int maxGenerations, String filesuffix, boolean saveSpaceships) {
            super(totalRuns, generationMode, population, maxGenerations, filesuffix, saveSpaceships);
            this.fCheck = new InfeasibleFitness(generationMode[2], generationMode[3], generationMode[4], generationMode[5]);
            this.dfn = new MCNSDifference(this.fCheck);
            this.initParameters();
            this.gaParameters.setParameter("population", population);
        }

        @Override
        protected void initializeTrainer() {
            StrategySketchGeneticAlgorithm ga = new StrategySketchGeneticAlgorithm(this.gaParameters);
            this.gaParameters.setParameter("repair", "1");
            ga.initializePopulation();
            this.nTrainer = new NoveltyTrainer(this.dfn, this.embryogeny, (GeneticAlgorithm)ga, this.gaParameters);
            this.nTrainer.evaluateParents();
        }
    }

    class E_OfflineFINS
    extends OfflineExperiment {
        public E_OfflineFINS(int totalRuns, int[] generationMode, int population, int maxGenerations, String filesuffix, boolean saveSpaceships, boolean boost) {
            super(totalRuns, generationMode, population, maxGenerations, filesuffix, saveSpaceships);
            this.fCheck = new InfeasibleFitness(generationMode[2], generationMode[3], generationMode[4], generationMode[5]);
            this.dfn = new NSDifference();
            this.initParameters();
            this.gaParameters.setParameter("population", population / 2);
            if (boost) {
                this.gaParameters.setParameter("enforceMinFeasiblePopulation", 0.5);
            }
        }

        @Override
        protected void initializeTrainer() {
            StrategySketchGeneticAlgorithm ga = new StrategySketchGeneticAlgorithm(this.gaParameters);
            StrategySketchGeneticAlgorithm iga = new StrategySketchGeneticAlgorithm(this.gaParameters);
            this.gaParameters.setParameter("repair", "1");
            ga.initializePopulation();
            iga.initializePopulation();
            NoveltyTrainer gaTrainer = new NoveltyTrainer(this.dfn, this.embryogeny, (GeneticAlgorithm)ga, this.gaParameters);
            GeneticAlgorithmTrainer igaTrainer = new GeneticAlgorithmTrainer(this.fCheck, this.embryogeny, (GeneticAlgorithm)iga, this.gaParameters);
            this.ifTrainer = new FI2PopTrainer(this.fCheck, (GeneticAlgorithmTrainerGeneric)gaTrainer, (GeneticAlgorithmTrainerGeneric)igaTrainer, this.gaParameters);
            this.ifTrainer.shufflePopulations();
        }
    }

    class E_OfflineFI2NS
    extends OfflineExperiment {
        public E_OfflineFI2NS(int totalRuns, int[] generationMode, int population, int maxGenerations, String filesuffix, boolean saveSpaceships, boolean boost) {
            super(totalRuns, generationMode, population, maxGenerations, filesuffix, saveSpaceships);
            this.fCheck = new InfeasibleFitness(generationMode[2], generationMode[3], generationMode[4], generationMode[5]);
            this.dfn = new NSDifference();
            this.initParameters();
            this.gaParameters.setParameter("population", population / 2);
            if (boost) {
                this.gaParameters.setParameter("enforceMinFeasiblePopulation", 0.5);
            }
        }

        @Override
        protected void initializeTrainer() {
            StrategySketchGeneticAlgorithm ga = new StrategySketchGeneticAlgorithm(this.gaParameters);
            StrategySketchGeneticAlgorithm iga = new StrategySketchGeneticAlgorithm(this.gaParameters);
            this.gaParameters.setParameter("repair", "1");
            ga.initializePopulation();
            iga.initializePopulation();
            NoveltyTrainer gaTrainer = new NoveltyTrainer(this.dfn, this.embryogeny, (GeneticAlgorithm)ga, this.gaParameters);
            NoveltyTrainer igaTrainer = new NoveltyTrainer(this.dfn, this.embryogeny, (GeneticAlgorithm)iga, this.gaParameters);
            this.ifTrainer = new FI2PopTrainer(this.fCheck, (GeneticAlgorithmTrainerGeneric)gaTrainer, (GeneticAlgorithmTrainerGeneric)igaTrainer, this.gaParameters);
            this.ifTrainer.shufflePopulations();
        }
    }
}

