/*
 * Decompiled with CFR 0.152.
 */
package experiments.gecco;

import genetic.Embryogeny;
import genetic.FI2PopTrainer;
import genetic.Gene;
import genetic.NoveltyTrainer;
import genetic.fitness.DifferenceFitness;
import genetic.fitness.Fitness;
import java.util.Collections;
import java.util.Vector;
import processing.core.PApplet;
import processing.core.PImage;
import strategymap.StrategySketch;
import strategymap.genetic.StrategySketchEmbryogeny;
import strategymap.genetic.StrategySketchGene;
import strategymap.visualization.MapVisualizer;
import util.collections.ParameterCollection;
import util.logs.Writer;
import util.statics.LogManager;

public abstract class OfflineExperiment {
    final int population;
    final int maxGenerations;
    final int[] generationMode;
    final int totalRuns;
    final boolean saveFeasible;
    final String filepath = "./experiment/GECCO/neighb50_M/";
    final String filesuffix;
    NoveltyTrainer nTrainer;
    FI2PopTrainer ifTrainer;
    Fitness fCheck;
    DifferenceFitness dfn;
    ParameterCollection gaParameters;
    Embryogeny embryogeny;
    Embryogeny imgEmbryogeny;
    PApplet p = new PApplet();

    public OfflineExperiment(int totalRuns, int[] generationMode, int population, int maxGenerations, String filesuffix, boolean saveSpaceships) {
        this.p.init();
        this.p.setup();
        this.totalRuns = totalRuns;
        this.generationMode = generationMode;
        this.population = population;
        this.maxGenerations = maxGenerations;
        this.filesuffix = filesuffix;
        this.saveFeasible = saveSpaceships;
        this.embryogeny = new StrategySketchEmbryogeny(generationMode[0], generationMode[1]);
        this.imgEmbryogeny = new StrategySketchImageEmbryogeny(this.p);
    }

    public void initParameters() {
        this.gaParameters = new ParameterCollection("./experiment/novelty_k50.xml");
        this.gaParameters.setParameter("repair", "1");
        this.gaParameters.setParameter("mapSizeX", this.generationMode[0]);
        this.gaParameters.setParameter("mapSizeY", this.generationMode[1]);
        this.gaParameters.setParameter("genotypeMinBases", this.generationMode[2]);
        this.gaParameters.setParameter("genotypeMaxBases", this.generationMode[3]);
        this.gaParameters.setParameter("genotypeMinResources", this.generationMode[4]);
        this.gaParameters.setParameter("genotypeMaxResources", this.generationMode[5]);
        this.gaParameters.setParameter("mutateShift", "5");
        this.gaParameters.setParameter("mutateTile", "5");
        this.gaParameters.setParameter("mutateDiagonal", "0");
        this.gaParameters.setParameter("mutateOnlyProbability", "101");
        this.gaParameters.setParameter("mutateAnyProbability", "101");
        this.gaParameters.setParameter("mutateBase", "0");
        this.gaParameters.setParameter("mutateResource", "0");
        this.gaParameters.setParameter("mutateTileMinNumber", this.generationMode[0] * this.generationMode[1] / 20);
        this.gaParameters.setParameter("mutateTileMaxNumber", this.generationMode[0] * this.generationMode[1] / 5);
    }

    public void run() {
        int[][] allFeasible = new int[this.maxGenerations][this.totalRuns];
        float[][] minDiversities = new float[this.maxGenerations][this.totalRuns];
        float[][] maxDiversities = new float[this.maxGenerations][this.totalRuns];
        float[][] medianDiversities = new float[this.maxGenerations][this.totalRuns];
        float[][] point25Diversities = new float[this.maxGenerations][this.totalRuns];
        float[][] point75Diversities = new float[this.maxGenerations][this.totalRuns];
        float[][] avgDiversities = new float[this.maxGenerations][this.totalRuns];
        LogManager.addLogfile("Times_" + this.filesuffix, "./experiment/GECCO/neighb50_M/" + this.filesuffix + "/times.csv");
        for (int r = 1; r <= this.totalRuns; ++r) {
            long startTime = System.currentTimeMillis();
            this.nTrainer = null;
            this.ifTrainer = null;
            this.initializeTrainer();
            if (this.ifTrainer != null) {
                this.ifTrainer.setLogID("./experiment/GECCO/neighb50_M/" + this.filesuffix + "/" + r);
            } else if (this.nTrainer != null) {
                this.nTrainer.setLogID("./experiment/GECCO/neighb50_M/" + this.filesuffix + "/" + r);
            } else {
                LogManager.writeError("Error", this, "no Trainer found!");
                return;
            }
            for (int i = 0; i < this.maxGenerations; ++i) {
                Vector<Float> differences = new Vector<Float>();
                int feasibleCount = -100;
                int tc = 0;
                float cf = 0.0f;
                if (this.ifTrainer != null) {
                    int j;
                    feasibleCount = this.ifTrainer.getFeasibleTrainer().getPopulation().getPopulationSize();
                    for (j = 0; j < feasibleCount; ++j) {
                        for (int k = 0; k < feasibleCount; ++k) {
                            if (k == j) continue;
                            float currDiff = (float)this.dfn.evaluate(this.ifTrainer.getFeasibleTrainer().getPopulation().getGene(j).getPhenotype(), this.ifTrainer.getFeasibleTrainer().getPopulation().getGene(k).getPhenotype());
                            differences.add(Float.valueOf(currDiff));
                            cf += currDiff;
                            ++tc;
                        }
                    }
                    if (this.saveFeasible) {
                        for (j = 0; j < this.ifTrainer.getFeasibleTrainer().getPopulation().getPopulationSize(); ++j) {
                            PImage bestDist = (PImage)this.imgEmbryogeny.createPhenotype(this.ifTrainer.getFeasibleTrainer().getPopulation().getGene(j).getPhenotype());
                            bestDist.save(this.ifTrainer.getLogID() + "/gen" + i + "_" + j + ".png");
                        }
                    }
                }
                if (this.nTrainer != null) {
                    int j;
                    Vector<Gene> feasibleGenes = new Vector<Gene>();
                    for (j = 0; j < this.nTrainer.getPopulation().getPopulationSize(); ++j) {
                        if (this.fCheck.evaluate(this.nTrainer.getPopulation().getGene(j).getPhenotype()) != 0.0) continue;
                        feasibleGenes.add(this.nTrainer.getPopulation().getGene(j));
                    }
                    feasibleCount = feasibleGenes.size();
                    for (j = 0; j < feasibleGenes.size(); ++j) {
                        for (int k = 0; k < feasibleGenes.size(); ++k) {
                            if (k == j) continue;
                            float currDiff = (float)this.dfn.evaluate(((Gene)feasibleGenes.get(j)).getPhenotype(), ((Gene)feasibleGenes.get(k)).getPhenotype());
                            differences.add(Float.valueOf(currDiff));
                            cf += currDiff;
                            ++tc;
                        }
                    }
                    if (this.saveFeasible) {
                        for (j = 0; j < feasibleGenes.size(); ++j) {
                            PImage bestDist = (PImage)this.imgEmbryogeny.createPhenotype(((Gene)feasibleGenes.get(j)).getPhenotype());
                            bestDist.save(this.nTrainer.getLogID() + "/gen" + i + "_" + j + ".png");
                        }
                    }
                }
                Collections.sort(differences);
                allFeasible[i][r - 1] = feasibleCount;
                System.out.println("i=" + i + ", feasibleGenes=" + feasibleCount);
                if (feasibleCount == 0) {
                    minDiversities[i][r - 1] = -1.0f;
                    maxDiversities[i][r - 1] = -1.0f;
                    medianDiversities[i][r - 1] = -1.0f;
                    point25Diversities[i][r - 1] = -1.0f;
                    point75Diversities[i][r - 1] = -1.0f;
                    avgDiversities[i][r - 1] = -1.0f;
                } else if (differences.isEmpty()) {
                    minDiversities[i][r - 1] = -0.5f;
                    minDiversities[i][r - 1] = -0.5f;
                    maxDiversities[i][r - 1] = -0.5f;
                    medianDiversities[i][r - 1] = -0.5f;
                    point25Diversities[i][r - 1] = -0.5f;
                    point75Diversities[i][r - 1] = -0.5f;
                    avgDiversities[i][r - 1] = -0.5f;
                } else {
                    minDiversities[i][r - 1] = ((Float)differences.firstElement()).floatValue();
                    maxDiversities[i][r - 1] = ((Float)differences.lastElement()).floatValue();
                    medianDiversities[i][r - 1] = ((Float)differences.get((int)Math.floor(differences.size() / 2))).floatValue();
                    point25Diversities[i][r - 1] = ((Float)differences.get((int)Math.floor(differences.size() / 4))).floatValue();
                    point75Diversities[i][r - 1] = ((Float)differences.get((int)Math.floor(differences.size() * 3 / 4))).floatValue();
                    avgDiversities[i][r - 1] = cf / (float)tc;
                }
                if (i % 5 == 0) {
                    PImage bestDist = null;
                    if (this.nTrainer != null) {
                        bestDist = (PImage)this.imgEmbryogeny.createPhenotype(this.nTrainer.getBestIndividual().getPhenotype());
                    }
                    if (this.ifTrainer != null && feasibleCount > 0) {
                        bestDist = (PImage)this.imgEmbryogeny.createPhenotype(this.ifTrainer.getBestFeasibleIndividual().getPhenotype());
                    }
                    if (bestDist != null) {
                        bestDist.save("./experiment/GECCO/neighb50_M/" + this.filesuffix + "/" + r + "/gen" + i + "_bestDist.png");
                    }
                }
                if (this.nTrainer != null) {
                    this.nTrainer.train(1);
                }
                if (this.ifTrainer == null) continue;
                this.ifTrainer.train(1);
            }
            long elapsedTime = System.currentTimeMillis() - startTime;
            LogManager.write("Times_" + this.filesuffix, elapsedTime + "");
        }
        this.printData("./experiment/GECCO/neighb50_M/" + this.filesuffix + "/allFeasible.csv", allFeasible);
        this.printData("./experiment/GECCO/neighb50_M/" + this.filesuffix + "/minDiversities.csv", minDiversities);
        this.printData("./experiment/GECCO/neighb50_M/" + this.filesuffix + "/maxDiversities.csv", maxDiversities);
        this.printData("./experiment/GECCO/neighb50_M/" + this.filesuffix + "/medianDiversities.csv", medianDiversities);
        this.printData("./experiment/GECCO/neighb50_M/" + this.filesuffix + "/point25Diversities.csv", point25Diversities);
        this.printData("./experiment/GECCO/neighb50_M/" + this.filesuffix + "/point75Diversities.csv", point75Diversities);
        this.printData("./experiment/GECCO/neighb50_M/" + this.filesuffix + "/avgDiversities.csv", avgDiversities);
    }

    protected void printData(String filename, int[][] data) {
        Writer temp = new Writer(filename);
        String output = "";
        for (int i = 0; i < data.length; ++i) {
            for (int r = 0; r < data[i].length; ++r) {
                output = output + data[i][r] + ";";
            }
            output = output + "\n";
        }
        temp.write(output);
        temp.close();
    }

    protected void printData(String filename, float[][] data) {
        Writer temp = new Writer(filename);
        String output = "";
        for (int i = 0; i < data.length; ++i) {
            for (int r = 0; r < data[i].length; ++r) {
                output = output + data[i][r] + ";";
            }
            output = output + "\n";
        }
        temp.write(output);
        temp.close();
    }

    protected StrategySketchGene initializeFeasible() {
        int sizeX = this.gaParameters.getInteger("mapSizeX");
        int sizeY = this.gaParameters.getInteger("mapSizeY");
        StrategySketchGene result = new StrategySketchGene(sizeX, sizeY, this.gaParameters);
        result.repairGenotype();
        return result;
    }

    protected abstract void initializeTrainer();

    class StrategySketchImageEmbryogeny
    implements Embryogeny<StrategySketch, PImage> {
        PApplet p;

        public StrategySketchImageEmbryogeny(PApplet p) {
            this.p = p;
        }

        public PImage createPhenotype(StrategySketch sketch) {
            return MapVisualizer.renderThumbnail(this.p, sketch, 80, 80).getImage();
        }
    }
}

