/*
 * Decompiled with CFR 0.152.
 */
package experiments.gecco;

import strategymap.StrategySketch;
import strategymap.genetic.StrategySketchEmbryogeny;
import strategymap.genetic.StrategySketchGene;
import strategymap.genetic.StrategySketchGeneticAlgorithm;
import strategymap.genetic.fitness.InfeasibleFitness;
import util.collections.ParameterCollection;

public class TestFeasibility {
    public static ParameterCollection initParameters(int[] generationMode) {
        ParameterCollection gaParameters = new ParameterCollection("./experiment/novelty.xml");
        gaParameters.setParameter("repair", "0");
        gaParameters.setParameter("mapSizeX", generationMode[0]);
        gaParameters.setParameter("mapSizeY", generationMode[1]);
        gaParameters.setParameter("genotypeMinBases", generationMode[2]);
        gaParameters.setParameter("genotypeMaxBases", generationMode[3]);
        gaParameters.setParameter("genotypeMinResources", generationMode[4]);
        gaParameters.setParameter("genotypeMaxResources", generationMode[5]);
        gaParameters.setParameter("mutateTileMinNumber", generationMode[0] * generationMode[1] / 20);
        gaParameters.setParameter("mutateTileMaxNumber", generationMode[0] * generationMode[1] / 5);
        return gaParameters;
    }

    public static void main(String[] args) {
        int[] generationMode = new int[6];
        int number = 1000000000;
        generationMode[0] = 8;
        generationMode[1] = 8;
        generationMode[2] = 2;
        generationMode[3] = 2;
        generationMode[4] = 4;
        generationMode[5] = 10;
        ParameterCollection gaParameters = TestFeasibility.initParameters(generationMode);
        StrategySketchGeneticAlgorithm ga = new StrategySketchGeneticAlgorithm(gaParameters);
        ga.initializePopulation();
        StrategySketchEmbryogeny embryogeny = new StrategySketchEmbryogeny(generationMode[0], generationMode[1]);
        InfeasibleFitness fCheck = new InfeasibleFitness(generationMode[2], generationMode[3], generationMode[4], generationMode[5]);
        int feasibleCount = 0;
        for (int i = 0; i < number; ++i) {
            StrategySketchGene entry = new StrategySketchGene(generationMode[0], generationMode[1], gaParameters);
            entry.randomize();
            StrategySketch temp = embryogeny.createPhenotype(entry.getGenotype());
            if (fCheck.evaluate(temp) != 0.0) continue;
            ++feasibleCount;
        }
        System.out.println("feasibleCount = " + feasibleCount);
    }
}

