/*
 * Decompiled with CFR 0.152.
 */
package experiments.logger;

import experiments.logger.BestFitnessLogger;
import experiments.logger.SingleFitnessLogger;
import genetic.GeneticAlgorithmTrainerGeneric;
import genetic.fitness.Fitness;
import genetic.fitness.WeightedFitness;
import java.util.Vector;
import util.statics.LogManager;

public class AllFitnessLogger {
    Vector<SingleFitnessLogger> allFnLoggers;
    BestFitnessLogger bestLogger = null;
    BestFitnessLogger userTasteLogger = null;
    int totalGenerations;
    int totalRuns;

    public AllFitnessLogger(int totalGenerations, int totalRuns) {
        this.totalGenerations = totalGenerations;
        this.totalRuns = totalRuns;
        this.allFnLoggers = new Vector();
    }

    public AllFitnessLogger(int totalGenerations, int totalRuns, WeightedFitness bestEvaluator) {
        this(totalGenerations, totalRuns);
        this.allFnLoggers.add(new SingleFitnessLogger(totalGenerations, totalRuns, (Fitness)bestEvaluator));
        this.bestLogger = new BestFitnessLogger(totalGenerations, totalRuns, bestEvaluator);
    }

    public AllFitnessLogger(int totalGenerations, int totalRuns, WeightedFitness bestEvaluator, WeightedFitness userTasteEvaluator) {
        this(totalGenerations, totalRuns);
        this.allFnLoggers.add(new SingleFitnessLogger(totalGenerations, totalRuns, (Fitness)bestEvaluator));
        this.bestLogger = new BestFitnessLogger(totalGenerations, totalRuns, bestEvaluator);
        this.userTasteLogger = new BestFitnessLogger(totalGenerations, totalRuns, userTasteEvaluator);
        this.userTasteLogger.setSuffix("userTaste");
    }

    public void initBestFitnessLogger() {
        if (this.bestLogger != null) {
            LogManager.writeError("Error", this, "bestLogger already exists!");
        } else {
            this.bestLogger = new BestFitnessLogger(this.totalGenerations, this.totalRuns, null);
        }
    }

    public void initUserTasteFitnessLogger() {
        if (this.userTasteLogger != null) {
            LogManager.writeError("Error", this, "userTasteLogger already exists!");
        } else {
            this.userTasteLogger = new BestFitnessLogger(this.totalGenerations, this.totalRuns, null);
        }
    }

    public BestFitnessLogger getBestFitnessLogger() {
        return this.bestLogger;
    }

    public BestFitnessLogger getUserTasteFitnessLogger() {
        return this.userTasteLogger;
    }

    public void addFitnessLogger(Fitness fitness) {
        this.allFnLoggers.add(new SingleFitnessLogger(this.totalGenerations, this.totalRuns, fitness));
    }

    public void reset() {
        this.allFnLoggers.clear();
        if (this.bestLogger != null) {
            this.bestLogger.reset();
        }
        if (this.userTasteLogger != null) {
            this.userTasteLogger.reset();
        }
    }

    public void storeGeneration(int currGeneration, int currRun, GeneticAlgorithmTrainerGeneric gTrainer) {
        for (SingleFitnessLogger sfl : this.allFnLoggers) {
            sfl.storeGeneration(currGeneration, currRun, gTrainer);
        }
        if (this.bestLogger != null) {
            this.bestLogger.storeGeneration(currGeneration, currRun, gTrainer);
        }
        if (this.userTasteLogger != null) {
            this.userTasteLogger.storeGeneration(currGeneration, currRun, gTrainer);
        }
    }

    public void writeRun(int run, String fileBase) {
        for (SingleFitnessLogger sfl : this.allFnLoggers) {
            sfl.writeRun(run, fileBase);
        }
        if (this.bestLogger != null) {
            this.bestLogger.writeRun(run, fileBase);
        }
        if (this.userTasteLogger != null) {
            this.userTasteLogger.writeRun(run, fileBase);
        }
    }

    public void writeAllProgress(String fileBase) {
        for (SingleFitnessLogger sfl : this.allFnLoggers) {
            sfl.writeAllProgress(fileBase);
        }
        if (this.bestLogger != null) {
            this.bestLogger.writeAllProgress(fileBase);
        }
        if (this.userTasteLogger != null) {
            this.userTasteLogger.writeAllProgress(fileBase);
        }
    }
}

