/*
 * Decompiled with CFR 0.152.
 */
package experiments.logger;

import genetic.Gene;
import genetic.GeneticAlgorithmTrainerGeneric;
import genetic.fitness.Fitness;
import genetic.fitness.WeightedFitness;
import java.util.Vector;
import util.logs.Writer;
import util.statics.LogManager;
import util.statics.StatisticUtils;

public class BestFitnessLogger {
    WeightedFitness bestEvaluator;
    String suffix;
    Vector<double[][]> avgFitnesses;
    Vector<double[]> difference;
    Vector<double[]> diversity;

    public BestFitnessLogger(int totalGenerations, int totalRuns, WeightedFitness bestEvaluator) {
        int i;
        this.bestEvaluator = bestEvaluator;
        this.suffix = "best";
        this.avgFitnesses = new Vector();
        for (i = 0; i < totalGenerations; ++i) {
            this.avgFitnesses.add(new double[bestEvaluator.getFitnessDimensions()][totalRuns]);
        }
        this.difference = new Vector();
        this.diversity = new Vector();
        for (i = 0; i < totalGenerations; ++i) {
            this.difference.add(new double[totalRuns]);
            this.diversity.add(new double[totalRuns]);
        }
    }

    public void setSuffix(String value) {
        this.suffix = value;
    }

    public void reset() {
        this.avgFitnesses.clear();
    }

    public void storeGeneration(int currGeneration, int currRun, GeneticAlgorithmTrainerGeneric gTrainer) {
        if (this.bestEvaluator == null) {
            LogManager.writeError("Error", this, "bestEvaluator fitness not initialized");
            return;
        }
        Gene best = gTrainer.getBestIndividualCustom((Fitness)this.bestEvaluator);
        Fitness[] fn = this.bestEvaluator.getFitnesses();
        for (int i = 0; i < fn.length; ++i) {
            double deb = -1.0;
            if (best != null) {
                deb = fn[i].evaluate(best.getPhenotype());
            }
            this.avgFitnesses.get((int)currGeneration)[i][currRun - 1] = deb;
        }
        this.difference.get((int)currGeneration)[currRun - 1] = gTrainer.getPopulation().getDiversity(best);
        this.diversity.get((int)currGeneration)[currRun - 1] = gTrainer.getPopulation().getDiversity();
    }

    public void storeBestPhenotype(int currGeneration, int currRun, Object bestPhenotype) {
        Fitness[] fn = this.bestEvaluator.getFitnesses();
        for (int i = 0; i < fn.length; ++i) {
            double deb = -1.0;
            if (bestPhenotype != null) {
                deb = fn[i].evaluate(bestPhenotype);
            }
            this.avgFitnesses.get((int)currGeneration)[i][currRun - 1] = deb;
        }
    }

    public void writeRun(int run, String fileBase) {
        int i;
        if (run < 1 || run > this.avgFitnesses.size()) {
            LogManager.writeError("Error", this, "run to write out of bounds");
            return;
        }
        --run;
        String result_allAverageFitnesses = "";
        Fitness[] fn = this.bestEvaluator.getFitnesses();
        for (i = 0; i < fn.length; ++i) {
            result_allAverageFitnesses = result_allAverageFitnesses + fn[i].getLabel();
            if (i >= fn.length - 1) continue;
            result_allAverageFitnesses = result_allAverageFitnesses + ";";
        }
        result_allAverageFitnesses = result_allAverageFitnesses + "\n";
        for (i = 0; i < this.avgFitnesses.size(); ++i) {
            for (int j = 0; j < fn.length; ++j) {
                result_allAverageFitnesses = result_allAverageFitnesses + this.avgFitnesses.get(i)[j][run];
                if (j >= fn.length - 1) continue;
                result_allAverageFitnesses = result_allAverageFitnesses + ";";
            }
            result_allAverageFitnesses = result_allAverageFitnesses + "\n";
        }
        Writer allAverageFitnesses = new Writer(fileBase + (run + 1) + "/" + this.suffix + "-allAverageFitnesses.csv");
        allAverageFitnesses.write(result_allAverageFitnesses);
        String result_differenceProgress = "";
        result_differenceProgress = result_differenceProgress + "difference\n";
        for (int i2 = 0; i2 < this.difference.size(); ++i2) {
            result_differenceProgress = result_differenceProgress + this.difference.get(i2)[run] + "\n";
        }
        Writer differenceProgress = new Writer(fileBase + (run + 1) + "/" + this.suffix + "-difference.csv");
        differenceProgress.write(result_differenceProgress);
        String result_diversityProgress = "";
        result_diversityProgress = result_diversityProgress + "diversity\n";
        for (int i3 = 0; i3 < this.diversity.size(); ++i3) {
            result_diversityProgress = result_diversityProgress + this.diversity.get(i3)[run] + "\n";
        }
        Writer diversityProgress = new Writer(fileBase + (run + 1) + "/" + "diversity.csv");
        diversityProgress.write(result_diversityProgress);
    }

    public void writeAllProgress(String fileBase) {
        int i;
        String result_allAverageFitnesses = "";
        int totalRuns = this.avgFitnesses.get(0)[0].length;
        int intervals = this.avgFitnesses.size();
        Fitness[] fn = this.bestEvaluator.getFitnesses();
        double[][] avgFitnesses_avg = new double[intervals][fn.length];
        double[][] avgFitnesses_stdev = new double[intervals][fn.length];
        for (i = 0; i < fn.length; ++i) {
            result_allAverageFitnesses = result_allAverageFitnesses + fn[i].getLabel() + ";";
            result_allAverageFitnesses = result_allAverageFitnesses + fn[i].getLabel() + "_stdev";
            if (i >= fn.length - 1) continue;
            result_allAverageFitnesses = result_allAverageFitnesses + ";";
        }
        result_allAverageFitnesses = result_allAverageFitnesses + "\n";
        for (i = 0; i < intervals; ++i) {
            for (int f = 0; f < fn.length; ++f) {
                double avgTotal = 0.0;
                for (int j = 0; j < totalRuns; ++j) {
                    avgTotal += this.avgFitnesses.get(i)[f][j];
                }
                result_allAverageFitnesses = result_allAverageFitnesses + (avgTotal /= (double)totalRuns) + ";" + StatisticUtils.standardDeviation(this.avgFitnesses.get(i)[f]);
                if (f >= fn.length - 1) continue;
                result_allAverageFitnesses = result_allAverageFitnesses + ";";
            }
            result_allAverageFitnesses = result_allAverageFitnesses + "\n";
        }
        Writer allAverageFitnesses = new Writer(fileBase + this.suffix + "-allAverageFitnesses.csv");
        allAverageFitnesses.write(result_allAverageFitnesses);
        String result_differenceProgress = "";
        double[] avgDifference_avg = new double[intervals];
        double[] avgDifference_stdev = new double[intervals];
        result_differenceProgress = result_differenceProgress + "difference;difference_stdev\n";
        for (int i2 = 0; i2 < intervals; ++i2) {
            double avgTotal = 0.0;
            for (int j = 0; j < totalRuns; ++j) {
                avgTotal += this.difference.get(i2)[j];
            }
            result_differenceProgress = result_differenceProgress + (avgTotal /= (double)totalRuns) + ";" + StatisticUtils.standardDeviation(this.difference.get(i2));
            result_differenceProgress = result_differenceProgress + "\n";
        }
        Writer differenceProgress = new Writer(fileBase + this.suffix + "-difference.csv");
        differenceProgress.write(result_differenceProgress);
        String result_diversityProgress = "";
        double[] avgDiversity_avg = new double[intervals];
        double[] avgDiversity_stdev = new double[intervals];
        result_differenceProgress = result_differenceProgress + "difference;difference_stdev\n";
        for (int i3 = 0; i3 < intervals; ++i3) {
            double avgTotal = 0.0;
            for (int j = 0; j < totalRuns; ++j) {
                avgTotal += this.difference.get(i3)[j];
            }
            result_diversityProgress = result_diversityProgress + (avgTotal /= (double)totalRuns) + ";" + StatisticUtils.standardDeviation(this.difference.get(i3));
            result_diversityProgress = result_diversityProgress + "\n";
        }
        Writer diversityProgress = new Writer(fileBase + "diversity.csv");
        diversityProgress.write(result_diversityProgress);
    }
}

