/*
 * Decompiled with CFR 0.152.
 */
package experiments.tciaig;

import genetic.Embryogeny;
import genetic.FI2PopTrainer;
import genetic.Gene;
import genetic.GeneticAlgorithm;
import genetic.fitness.Fitness;
import genetic.fitness.WeightedFitness;
import genetic.logger.AllFitnessLogger;
import genetic.logger.BestFitnessLogger;
import java.util.Vector;
import processing.core.PApplet;
import processing.core.PImage;
import strategymap.DetailConverter;
import strategymap.StrategySketch;
import strategymap.genetic.StrategySketchEmbryogeny;
import strategymap.genetic.StrategySketchGene;
import strategymap.genetic.StrategySketchGeneticAlgorithm;
import strategymap.genetic.fitness.FeasibleFitness;
import strategymap.genetic.fitness.InfeasibleFitness;
import strategymap.visualization.MapVisualizer;
import util.collections.ParameterCollection;
import util.statics.LogManager;

public class StrategyGame_Population {
    final int totalRuns = 50;
    static int generations = 101;
    final StrategySketch testbed = null;
    static final boolean seedFeasible = false;
    static final String seededGene = "";

    public void experiment(WeightedFitness sfn, Fitness ifn, int mapSizeX, int mapSizeY, ParameterCollection params, String name) {
        String file = name;
        if (!seededGene.isEmpty()) {
            file = file + "seededGene/";
        }
        file = file + "/" + sfn.getLabel() + "/";
        PApplet p = new PApplet();
        AllFitnessLogger logger = new AllFitnessLogger(generations, 50, sfn);
        BestFitnessLogger bLogger = new BestFitnessLogger(generations, 50, sfn);
        LogManager.addLogfile("Best_" + sfn.getLabel(), file + "/bestIndividuals.xml");
        LogManager.addLogfile("Times_" + sfn.getLabel(), file + "/times.csv");
        int[][] allFeasible = new int[generations][50];
        int[][] allMatches = new int[generations][50];
        int[][] bestDifference = new int[generations][50];
        double[][] feasibleDiversity = new double[generations][50];
        for (int r = 1; r <= 50; ++r) {
            long startTime = System.currentTimeMillis();
            StrategySketchEmbryogeny sme = new StrategySketchEmbryogeny(mapSizeX, mapSizeY);
            StrategySketchGeneticAlgorithm ga = new StrategySketchGeneticAlgorithm(params);
            StrategySketchGeneticAlgorithm iga = new StrategySketchGeneticAlgorithm(params);
            ga.initializePopulation();
            iga.initializePopulation();
            if (!seededGene.isEmpty()) {
                Vector<Gene> initialSeed = new Vector<Gene>();
                String[] xml = p.loadStrings(seededGene);
                initialSeed.add(StrategySketchGene.loadFromString(xml[0], params.getInteger("mapSizeX"), params.getInteger("mapSizeY"), params));
                for (int i = 1; i < ga.getPopulationSize(); ++i) {
                    initialSeed.add(ga.getGene(i));
                }
                ga.replacePopulation(initialSeed);
            }
            FI2PopTrainer gTrainer = new FI2PopTrainer((Fitness)sfn, ifn, (Embryogeny)sme, (GeneticAlgorithm)ga, (GeneticAlgorithm)iga, params);
            gTrainer.shufflePopulations();
            gTrainer.setLogID(file + r + "/log");
            for (int k = 0; k < gTrainer.getFeasibleSize(); ++k) {
                StrategySketch im = sme.createPhenotype(((StrategySketchGene)gTrainer.getFeasibleTrainer().getPopulation().getGene(k)).getGenotype());
                PImage img = MapVisualizer.renderThumbnail(p, im).getImage();
                img.save(file + r + "/initial/" + k + ".png");
            }
            LogManager.addLogfile("MapOutput" + sfn.getLabel() + "_" + r, file + r + "/geneticalgorithm_map.log");
            for (int i = 0; i < generations; ++i) {
                logger.storeGeneration(i, r, gTrainer.getFeasibleTrainer());
                bLogger.storeGeneration(i, r, gTrainer.getFeasibleTrainer());
                int matches = 0;
                int bestDiff = Integer.MAX_VALUE;
                double currDiversity = 0.0;
                for (int j = 0; j < gTrainer.getFeasibleTrainer().getPopulation().getPopulationSize(); ++j) {
                    Gene cg = gTrainer.getFeasibleTrainer().getPopulation().getGene(j);
                    int tc = 0;
                    int cf = 0;
                    for (int k = 0; k < gTrainer.getFeasibleTrainer().getPopulation().getPopulationSize(); ++k) {
                        cf = (int)((float)cf + gTrainer.getFeasibleTrainer().getPopulation().getGene(k).getDifference(cg));
                        ++tc;
                    }
                    currDiversity += (double)cf / (double)tc;
                    if (this.testbed == null) continue;
                    int currDiff = this.testbed.getTileDifference((StrategySketch)cg.getPhenotype());
                    if (currDiff == 0) {
                        ++matches;
                    }
                    if (currDiff >= bestDiff) continue;
                    bestDiff = currDiff;
                }
                feasibleDiversity[i][r - 1] = currDiversity / (double)gTrainer.getFeasibleTrainer().getPopulation().getPopulationSize();
                allFeasible[i][r - 1] = gTrainer.getFeasibleTrainer().getPopulation().getPopulationSize();
                allMatches[i][r - 1] = matches;
                bestDifference[i][r - 1] = bestDiff;
                StrategySketchGene best = (StrategySketchGene)gTrainer.getBestFeasibleIndividual();
                if (best != null && i % 10 == 0) {
                    StrategySketch im = sme.createPhenotype(best.getGenotype());
                    PImage img = MapVisualizer.renderThumbnail(p, im, 80, 80).getImage();
                    img.save(file + r + "/bestIndividual" + i + ".png");
                    System.out.println(sfn.getLabel() + " (" + i + ") " + gTrainer.getFeasibleTrainer().getMaxFitness());
                    DetailConverter dc = new DetailConverter(im, 10, 10);
                    dc.generateMap();
                    PImage sprite_img = MapVisualizer.renderGradient(p, dc, mapSizeX * dc.getGridSizeX(), mapSizeY * dc.getGridSizeY()).getImage();
                    sprite_img.save(file + r + "/bestThumb" + i + "_sprite.png");
                }
                if (i >= generations) continue;
                gTrainer.train(1);
            }
            long elapsedTime = System.currentTimeMillis() - startTime;
            LogManager.write("Times_" + sfn.getLabel(), elapsedTime + seededGene);
            logger.writeRun(r, file);
            bLogger.writeRun(r, file);
            if (gTrainer.getFeasibleTrainer().getBestIndividual() != null) {
                StrategySketchGene bestGene = (StrategySketchGene)gTrainer.getFeasibleTrainer().getBestIndividual();
                StrategySketch bestSketch = (StrategySketch)bestGene.getPhenotype();
                LogManager.write("Best_" + sfn.getLabel(), bestGene.toXML());
                PImage thumb = MapVisualizer.renderThumbnail(p, bestSketch).getImage();
                thumb.save(file + "/bestThumb" + r + ".png");
                DetailConverter dc = new DetailConverter(bestSketch, 10, 10);
                dc.generateMap();
                PImage sprite_img = MapVisualizer.renderGradient(p, dc, mapSizeX * dc.getGridSizeX(), mapSizeY * dc.getGridSizeY()).getImage();
                sprite_img.save(file + r + "/bestThumb" + r + "_sprite.png");
            }
            for (int k = 0; k < gTrainer.getFeasibleSize(); ++k) {
                StrategySketch im = sme.createPhenotype(((StrategySketchGene)gTrainer.getFeasibleTrainer().getPopulation().getGene(k)).getGenotype());
                PImage img = MapVisualizer.renderThumbnail(p, im).getImage();
                img.save(file + r + "/final/" + k + ".png");
            }
        }
        logger.writeAllProgress(file);
        bLogger.writeAllProgress(file);
        LogManager.addLogfile("FeasibleIndividuals" + sfn.getLabel(), file + "/feasibleIndividuals.csv");
        LogManager.addLogfile("FeasibleDiversity" + sfn.getLabel(), file + "/feasibleDiversity.csv");
        if (this.testbed != null) {
            LogManager.addLogfile("Matches" + sfn.getLabel(), file + "/matches.csv");
        }
        if (this.testbed != null) {
            LogManager.addLogfile("BestDifference" + sfn.getLabel(), file + "/bestDifference.csv");
        }
        String output1 = seededGene;
        String output2 = seededGene;
        String output3 = seededGene;
        String output4 = seededGene;
        for (int i = 0; i < allFeasible.length; ++i) {
            for (int r = 0; r < allFeasible[i].length; ++r) {
                output1 = output1 + allFeasible[i][r] + ";";
                output2 = output2 + allMatches[i][r] + ";";
                output3 = output3 + bestDifference[i][r] + ";";
                output4 = output4 + feasibleDiversity[i][r] + ";";
            }
            LogManager.write("FeasibleIndividuals" + sfn.getLabel(), output1);
            LogManager.write("FeasibleDiversity" + sfn.getLabel(), output4);
            if (this.testbed != null) {
                LogManager.write("Matches" + sfn.getLabel(), output2);
            }
            if (this.testbed != null) {
                LogManager.write("BestDifference" + sfn.getLabel(), output3);
            }
            output1 = seededGene;
            output2 = seededGene;
            output3 = seededGene;
            output4 = seededGene;
        }
    }

    protected StrategySketchGene initializeFeasible(ParameterCollection params) {
        int sizeX = params.getInteger("mapSizeX");
        int sizeY = params.getInteger("mapSizeY");
        StrategySketchGene result = new StrategySketchGene(sizeX, sizeY, params);
        result.repairGenotype();
        return result;
    }

    public static void set_experiment(String name, int mapSizeX, int mapSizeY, int minBases, int maxBases, int minResources, int maxResources, int population) {
        LogManager.reset();
        StrategyGame_Population smg = new StrategyGame_Population();
        ParameterCollection params = new ParameterCollection();
        params.setParameter("population", population / 2);
        params.setParameter("maxGenerations", "500");
        params.setParameter("normalizeFitness", "1");
        params.setParameter("steadyPercentage", "1");
        params.setParameter("repair", "1");
        params.setParameter("crossoverPoints", "2");
        params.setParameter("mapSizeX", seededGene + mapSizeX);
        params.setParameter("mapSizeY", seededGene + mapSizeY);
        params.setParameter("genotypeMinResources", seededGene + minResources);
        params.setParameter("genotypeMaxResources", seededGene + maxResources);
        params.setParameter("genotypeMinBases", seededGene + minBases);
        params.setParameter("genotypeMaxBases", seededGene + maxBases);
        params.setParameter("mutateAnyProbability", "1");
        params.setParameter("mutateOnlyProbability", "0");
        params.setParameter("mutateTile", "5");
        params.setParameter("mutateBase", "0");
        params.setParameter("mutateResource", "0");
        params.setParameter("mutateShift", "5");
        params.setParameter("mutateDiagonal", "0");
        params.setParameter("mutateTileMinNumber", seededGene + (int)(0.05 * (double)mapSizeX * (double)mapSizeY));
        params.setParameter("mutateTileMaxNumber", seededGene + (int)(0.2 * (double)mapSizeX * (double)mapSizeY));
        InfeasibleFitness ifn = new InfeasibleFitness(minBases, maxBases, minResources, maxResources);
        for (int i = 0; i < FeasibleFitness.labels.length; ++i) {
            smg.experiment(new FeasibleFitness(i), (Fitness)ifn, mapSizeX, mapSizeY, params, name);
        }
    }

    public static void main(String[] args) {
        generations = 6;
        StrategyGame_Population.set_experiment("experiment/tciaig/strategy_noOB/large/200pop/", 16, 16, 2, 10, 4, 30, 200);
    }
}

