/*
 * Decompiled with CFR 0.152.
 */
package experiments.thesis;

import ai.pathfinder.Connector;
import ai.pathfinder.Node;
import ai.pathfinder.Pathfinder;
import common.PathLibrary;
import dungeon.Dungeon;
import dungeon.genetic.DungeonEmbryogeny;
import dungeon.genetic.DungeonGene;
import dungeon.genetic.DungeonGeneticAlgorithm;
import fps.genetic.fitness.FeasibleFitness;
import fps.genetic.fitness.InfeasibleFitness;
import fps.visualization.FPSVisualizer;
import genetic.Embryogeny;
import genetic.FI2PopTrainer;
import genetic.Gene;
import genetic.GeneticAlgorithm;
import genetic.fitness.Fitness;
import genetic.fitness.WeightedFitness;
import genetic.logger.AllFitnessLogger;
import genetic.logger.BestFitnessLogger;
import processing.core.PApplet;
import processing.core.PImage;
import renderer.Render2D;
import util.collections.ParameterCollection;
import util.math2d.Point2D;
import util.math2d.Vector2D;
import util.statics.LogManager;

public class FPS_FI2pop {
    final int totalRuns = 50;
    final int generations = 101;

    public static Render2D renderWalls(PApplet p, Dungeon map, int imgSizeX, int imgSizeY) {
        int j;
        int i;
        int y;
        int x;
        int gridSize = 10;
        int corridorWidth = 2;
        int[] color = new int[]{p.color(0), p.color(255), p.color(120, 40, 0), p.color(200, 0, 0), p.color(255, 255, 0), p.color(140, 140, 140)};
        boolean[][] rewards = map.getRewardArray();
        boolean[][] monsters = map.getMonsterArray();
        boolean[][] exits = map.getExitArray();
        boolean[][] passable = map.getPassableArray();
        boolean[][] chokePoints = map.getPaths().getChokePoints();
        boolean[][] deadEnds = map.getPaths().getDeadEnds();
        boolean[][] openAreas = map.getPaths().getOpenAreas();
        Render2D renderer = new Render2D(p, map.getMapSizeX() * gridSize, map.getMapSizeY() * gridSize, imgSizeX, imgSizeY);
        renderer.renderGrid();
        renderer.renderBackground(color[0]);
        for (x = 0; x < passable.length; ++x) {
            for (y = 0; y < passable[x].length; ++y) {
                if (!passable[x][y] || chokePoints[x][y] || deadEnds[x][y] || passable[Math.max(0, x - 1)][y] || passable[Math.min(passable.length - 1, x + 1)][y] || passable[x][Math.max(0, y - 1)] || passable[x][Math.min(passable[0].length - 1, y + 1)]) continue;
                for (i = 1; i < gridSize - 1; ++i) {
                    for (j = 1; j < gridSize - 1; ++j) {
                        renderer.renderTile(x * gridSize + i, y * gridSize + j, color[1]);
                    }
                }
            }
        }
        for (x = 0; x < passable.length; ++x) {
            for (y = 0; y < passable[x].length; ++y) {
                if (y >= passable[x].length - 1 || x >= passable.length - 1 || !passable[x][y] || !passable[x][y + 1] || !passable[x + 1][y] || !passable[x + 1][y + 1]) continue;
                for (i = 1; i < 2 * gridSize - 1; ++i) {
                    for (j = 1; j < 2 * gridSize - 1; ++j) {
                        renderer.renderTile(x * gridSize + i, y * gridSize + j, color[1]);
                    }
                }
            }
        }
        if (map.getPaths() != null && map.getPaths().getAStar() != null) {
            Pathfinder astar = map.getPaths().getAStar();
            for (int i2 = 0; i2 < astar.nodes.size(); ++i2) {
                Node n = (Node)astar.nodes.get(i2);
                if (!n.walkable) continue;
                Connector conn = null;
                for (j = 0; j < n.links.size(); ++j) {
                    conn = (Connector)n.links.get(j);
                    Point2D start = PathLibrary.transformNode(n);
                    Point2D end = Vector2D.interpolate(PathLibrary.transformNode(n), PathLibrary.transformNode(conn.n), 0.5f);
                    if (start.x != end.x && start.y != end.y) continue;
                    start.x = (start.x + 0.5) * (double)gridSize;
                    start.y = (start.y + 0.5) * (double)gridSize;
                    end.x = (end.x + 0.5) * (double)gridSize;
                    end.y = (end.y + 0.5) * (double)gridSize;
                    renderer.renderLine(start, end, color[1], (float)corridorWidth);
                    renderer.renderMidrect(start, color[1], corridorWidth, corridorWidth);
                }
            }
        }
        return renderer;
    }

    public void experiment(WeightedFitness sfn, Fitness ifn, int mapSizeX, int mapSizeY, ParameterCollection params, String name) {
        String file = name + "/" + sfn.getLabel() + "/";
        PApplet p = new PApplet();
        BestFitnessLogger bLogger = new BestFitnessLogger(101, 50, sfn);
        AllFitnessLogger logger = new AllFitnessLogger(101, 50, sfn);
        for (int i = 0; i < FeasibleFitness.labels.length; ++i) {
            logger.addFitnessLogger((Fitness)new FeasibleFitness(i));
        }
        LogManager.addLogfile("Best_" + sfn.getLabel(), file + "/bestIndividuals.xml");
        LogManager.addLogfile("Times_" + sfn.getLabel(), file + "/times.csv");
        int[][] allFeasible = new int[101][50];
        int[][] allMatches = new int[101][50];
        int[][] bestDifference = new int[101][50];
        double[][] feasibleDiversity = new double[101][50];
        for (int r = 1; r <= 50; ++r) {
            long startTime = System.currentTimeMillis();
            DungeonEmbryogeny de = new DungeonEmbryogeny(mapSizeX, mapSizeY);
            DungeonGeneticAlgorithm ga = new DungeonGeneticAlgorithm(params);
            DungeonGeneticAlgorithm iga = new DungeonGeneticAlgorithm(params);
            ga.initializePopulation();
            iga.initializePopulation();
            FI2PopTrainer gTrainer = new FI2PopTrainer((Fitness)sfn, ifn, (Embryogeny)de, (GeneticAlgorithm)ga, (GeneticAlgorithm)iga, params);
            gTrainer.shufflePopulations();
            gTrainer.setLogID(file + r + "/log");
            gTrainer.evaluateParents();
            gTrainer.setLogID(file + r + "/log");
            LogManager.addLogfile("MapOutput" + sfn.getLabel() + "_" + r, file + r + "/geneticalgorithm_map.log");
            for (int i = 0; i < 101; ++i) {
                logger.storeGeneration(i, r, gTrainer.getFeasibleTrainer());
                bLogger.storeGeneration(i, r, gTrainer.getFeasibleTrainer());
                int matches = 0;
                int bestDiff = Integer.MAX_VALUE;
                double currDiversity = 0.0;
                for (int j = 0; j < gTrainer.getFeasibleTrainer().getPopulation().getPopulationSize(); ++j) {
                    Gene cg = gTrainer.getFeasibleTrainer().getPopulation().getGene(j);
                    int tc = 0;
                    int cf = 0;
                    for (int k = 0; k < gTrainer.getFeasibleTrainer().getPopulation().getPopulationSize(); ++k) {
                        cf = (int)((float)cf + gTrainer.getFeasibleTrainer().getPopulation().getGene(k).getDifference(cg));
                        ++tc;
                    }
                    currDiversity += (double)cf / (double)tc;
                }
                feasibleDiversity[i][r - 1] = currDiversity / (double)gTrainer.getFeasibleTrainer().getPopulation().getPopulationSize();
                allFeasible[i][r - 1] = gTrainer.getFeasibleTrainer().getPopulation().getPopulationSize();
                allMatches[i][r - 1] = matches;
                bestDifference[i][r - 1] = bestDiff;
                DungeonGene best = (DungeonGene)gTrainer.getBestFeasibleIndividual();
                if (best != null && i % 10 == 0) {
                    Dungeon im = de.createPhenotype(best.getGenotype());
                    PImage img = FPSVisualizer.renderThumbnail(p, im, mapSizeX, mapSizeY).getImage();
                    img.save(file + r + "/bestIndividual" + i + ".png");
                    PImage dung_img = FPSVisualizer.renderCorridors(p, im, mapSizeX * 20, mapSizeY * 20).getImage();
                    dung_img.save(file + r + "/bestIndividual" + i + "_dungeon.png");
                    PImage sprite_img = FPSVisualizer.renderSprite(p, im, mapSizeX * 16, mapSizeY * 16).getImage();
                    sprite_img.save(file + r + "/bestIndividual" + i + "_sprite.png");
                    System.out.println(sfn.getLabel() + " (" + i + ") " + gTrainer.getFeasibleTrainer().getMaxFitness());
                }
                if (i >= 101) continue;
                gTrainer.train(1);
            }
            long elapsedTime = System.currentTimeMillis() - startTime;
            LogManager.write("Times_" + sfn.getLabel(), elapsedTime + "");
            logger.writeRun(r, file);
            bLogger.writeRun(r, file);
            for (int k = 0; k < gTrainer.getFeasibleSize(); ++k) {
                Dungeon im = de.createPhenotype(((DungeonGene)gTrainer.getFeasibleTrainer().getPopulation().getGene(k)).getGenotype());
                PImage img = FPSVisualizer.renderThumbnail(p, im, mapSizeX, mapSizeY).getImage();
                img.save(file + r + "/final/" + k + ".png");
            }
            if (gTrainer.getFeasibleTrainer().getBestIndividual() == null) continue;
            DungeonGene bestGene = (DungeonGene)gTrainer.getFeasibleTrainer().getBestIndividual();
            Dungeon bestSketch = (Dungeon)bestGene.getPhenotype();
            LogManager.write("Best_" + sfn.getLabel(), bestGene.toXML());
            PImage thumb = FPSVisualizer.renderThumbnail(p, bestSketch, 80, 80).getImage();
            thumb.save(file + "/bestThumb" + r + ".png");
            PImage sprite_img = FPSVisualizer.renderSprite(p, bestSketch, mapSizeX * 16, mapSizeY * 16).getImage();
            sprite_img.save(file + "/bestSprite" + r + ".png");
            FPS_FI2pop.renderWalls(p, bestSketch, bestSketch.getMapSizeX() * 10, bestSketch.getMapSizeX() * 10).getImage().save(file + "/bestRooms" + r + ".png");
            p.saveStrings(file + "/bestAscii" + r + ".txt", bestSketch.toASCII().split(";"));
        }
        logger.writeAllProgress(file);
        bLogger.writeAllProgress(file);
        LogManager.addLogfile("FeasibleIndividuals" + sfn.getLabel(), file + "/feasibleIndividuals.csv");
        LogManager.addLogfile("FeasibleDiversity" + sfn.getLabel(), file + "/feasibleDiversity.csv");
        String output1 = "";
        String output2 = "";
        String output3 = "";
        String output4 = "";
        for (int i = 0; i < allFeasible.length; ++i) {
            for (int r = 0; r < allFeasible[i].length; ++r) {
                output1 = output1 + allFeasible[i][r] + ";";
                output2 = output2 + allMatches[i][r] + ";";
                output3 = output3 + bestDifference[i][r] + ";";
                output4 = output4 + feasibleDiversity[i][r] + ";";
            }
            LogManager.write("FeasibleIndividuals" + sfn.getLabel(), output1);
            LogManager.write("FeasibleDiversity" + sfn.getLabel(), output4);
            output1 = "";
            output2 = "";
            output3 = "";
            output4 = "";
        }
    }

    public static void set_experiment(String name, int mapSizeX, int mapSizeY, int minExits, int maxExits, int minMonsters, int maxMonsters, int minRewards, int maxRewards, int population) {
        LogManager.reset();
        FPS_FI2pop smg = new FPS_FI2pop();
        ParameterCollection params = new ParameterCollection();
        params.setParameter("population", population / 2);
        params.setParameter("maxGenerations", "500");
        params.setParameter("normalizeFitness", "1");
        params.setParameter("steadyPercentage", "1");
        params.setParameter("repair", "1");
        params.setParameter("enforceMinFeasiblePopulation", "0.5");
        params.setParameter("crossoverPoints", "2");
        params.setParameter("mapSizeX", "" + mapSizeX);
        params.setParameter("mapSizeY", "" + mapSizeY);
        params.setParameter("genotypeMinExits", "" + minExits);
        params.setParameter("genotypeMaxExits", "" + maxExits);
        params.setParameter("genotypeMinMonsters", "" + minMonsters);
        params.setParameter("genotypeMaxMonsters", "" + maxMonsters);
        params.setParameter("genotypeMinRewards", "" + minRewards);
        params.setParameter("genotypeMaxRewards", "" + maxRewards);
        params.setParameter("mutateAnyProbability", "1");
        params.setParameter("mutateOnlyProbability", "0");
        params.setParameter("mutateTile", "5");
        params.setParameter("mutateExit", "0");
        params.setParameter("mutateMonster", "0");
        params.setParameter("mutateReward", "0");
        params.setParameter("mutateShift", "5");
        params.setParameter("mutateDiagonal", "0");
        params.setParameter("mutateTileMinNumber", "" + (int)(0.05 * (double)mapSizeX * (double)mapSizeY));
        params.setParameter("mutateTileMaxNumber", "" + (int)(0.2 * (double)mapSizeX * (double)mapSizeY));
        InfeasibleFitness ifn = new InfeasibleFitness(minExits, maxExits, minMonsters, maxMonsters, minRewards, maxRewards);
        smg.experiment(new FeasibleFitness(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.5, 0.5), (Fitness)ifn, mapSizeX, mapSizeY, params, name);
        smg.experiment(new FeasibleFitness(0.0, 0.0, 0.5, 0.5, 0.0, 0.0, 0.0, 0.0), (Fitness)ifn, mapSizeX, mapSizeY, params, name);
        smg.experiment(new FeasibleFitness(0.0, 0.0, 0.0, 0.0, 0.5, 0.5, 0.0, 0.0), (Fitness)ifn, mapSizeX, mapSizeY, params, name);
        FeasibleFitness cfn = new FeasibleFitness(0.0, 0.0, 0.16666666666666666, 0.16666666666666666, 0.16666666666666666, 0.16666666666666666, 0.125, 0.16666666666666666);
        cfn.setLabel("all");
        smg.experiment(cfn, (Fitness)ifn, mapSizeX, mapSizeY, params, name);
    }

    public static void main(String[] args) {
        FPS_FI2pop.set_experiment("experiment/thesis/fps/16x16", 16, 16, 2, 2, 10, 15, 6, 6, 100);
    }
}

